/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.TestViewfsFileStatus;
import org.apache.hadoop.fs.viewfs.ViewFileSystemOverloadScheme;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestViewFsOverloadSchemeListStatus {
    private static final File TEST_DIR = GenericTestUtils.getTestDir(TestViewfsFileStatus.class.getSimpleName());
    private Configuration conf;
    private static final String FILE_NAME = "file";

    @Before
    public void setUp() {
        this.conf = new Configuration();
        this.conf.set(String.format("fs.%s.impl", FILE_NAME), ViewFileSystemOverloadScheme.class.getName());
        this.conf.set(String.format("fs.viewfs.overload.scheme.target.%s.impl", FILE_NAME), LocalFileSystem.class.getName());
        FileUtil.fullyDelete((File)TEST_DIR);
        Assert.assertTrue((boolean)TEST_DIR.mkdirs());
    }

    @After
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)TEST_DIR);
    }

    @Test
    public void testListStatusACL() throws IOException, URISyntaxException {
        String testfilename = "testFileACL";
        String childDirectoryName = "testDirectoryACL";
        TEST_DIR.mkdirs();
        File infile = new File(TEST_DIR, testfilename);
        byte[] content = "dingos".getBytes();
        try (FileOutputStream fos = new FileOutputStream(infile);){
            fos.write(content);
        }
        Assert.assertEquals((long)content.length, (long)infile.length());
        File childDir = new File(TEST_DIR, childDirectoryName);
        childDir.mkdirs();
        ConfigUtil.addLink((Configuration)this.conf, (String)"/file", (URI)infile.toURI());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/dir", (URI)childDir.toURI());
        String fileUriStr = "file:///";
        try (FileSystem vfs = FileSystem.get((URI)new URI(fileUriStr), (Configuration)this.conf);){
            Assert.assertEquals(ViewFileSystemOverloadScheme.class, vfs.getClass());
            FileStatus[] statuses = vfs.listStatus(new Path("/"));
            FileSystem localFs = ((ViewFileSystemOverloadScheme)vfs).getRawFileSystem(new Path(fileUriStr), this.conf);
            FileStatus fileStat = localFs.getFileStatus(new Path(infile.getPath()));
            FileStatus dirStat = localFs.getFileStatus(new Path(childDir.getPath()));
            for (FileStatus status : statuses) {
                if (status.getPath().getName().equals(FILE_NAME)) {
                    Assert.assertEquals((Object)fileStat.getPermission(), (Object)status.getPermission());
                    continue;
                }
                Assert.assertEquals((Object)dirStat.getPermission(), (Object)status.getPermission());
            }
            localFs.setPermission(new Path(infile.getPath()), FsPermission.valueOf((String)"-rwxr--r--"));
            localFs.setPermission(new Path(childDir.getPath()), FsPermission.valueOf((String)"-r--rwxr--"));
            for (FileStatus status : statuses = vfs.listStatus(new Path("/"))) {
                if (status.getPath().getName().equals(FILE_NAME)) {
                    Assert.assertEquals((Object)FsPermission.valueOf((String)"-rwxr--r--"), (Object)status.getPermission());
                    Assert.assertFalse((boolean)status.isDirectory());
                    continue;
                }
                Assert.assertEquals((Object)FsPermission.valueOf((String)"-r--rwxr--"), (Object)status.getPermission());
                Assert.assertTrue((boolean)status.isDirectory());
            }
        }
    }

    @Test(timeout=30000L)
    public void testViewFSOverloadSchemeWithoutAnyMountLinks() throws Exception {
        Path initUri = new Path(TEST_DIR.toURI().toString(), "init");
        try (FileSystem fs = FileSystem.get((URI)initUri.toUri(), (Configuration)this.conf);){
            ViewFileSystemOverloadScheme vfs = (ViewFileSystemOverloadScheme)fs;
            Assert.assertEquals((long)0L, (long)vfs.getMountPoints().length);
            Path testOnFallbackPath = new Path(TEST_DIR.toURI().toString(), "test");
            Assert.assertTrue((boolean)vfs.mkdirs(testOnFallbackPath));
            FileStatus[] status = vfs.listStatus(testOnFallbackPath.getParent());
            Assert.assertEquals((Object)Path.getPathWithoutSchemeAndAuthority((Path)testOnFallbackPath), (Object)Path.getPathWithoutSchemeAndAuthority((Path)status[0].getPath()));
            FileSystem lfs = vfs.getRawFileSystem(testOnFallbackPath, this.conf);
            FileStatus[] statusOnLocalFS = lfs.listStatus(testOnFallbackPath.getParent());
            Assert.assertEquals((Object)testOnFallbackPath.getName(), (Object)statusOnLocalFS[0].getPath().getName());
            Assert.assertFalse((boolean)lfs.exists(initUri));
        }
    }

    @AfterClass
    public static void cleanup() throws IOException {
        FileUtil.fullyDelete((File)TEST_DIR);
    }
}

