/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.DomainNameResolver;
import org.apache.hadoop.net.DomainNameResolverFactory;
import org.apache.hadoop.net.MockDomainNameResolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestMockDomainNameResolver {
    private Configuration conf;
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Before
    public void setup() {
        this.conf = new Configuration();
        this.conf.set("hadoop.domainname.resolver.impl", MockDomainNameResolver.class.getName());
    }

    @Test
    public void testMockDomainNameResolverCanBeCreated() throws IOException {
        DomainNameResolver resolver = DomainNameResolverFactory.newInstance((Configuration)this.conf, (String)"hadoop.domainname.resolver.impl");
        InetAddress[] addrs = resolver.getAllByDomainName("test.foo.bar");
        Assert.assertEquals((long)2L, (long)addrs.length);
        Assert.assertEquals((Object)"10.1.1.1", (Object)addrs[0].getHostAddress());
        Assert.assertEquals((Object)"10.1.1.2", (Object)addrs[1].getHostAddress());
    }

    @Test
    public void testMockDomainNameResolverCanNotBeCreated() throws UnknownHostException {
        DomainNameResolver resolver = DomainNameResolverFactory.newInstance((Configuration)this.conf, (String)"hadoop.domainname.resolver.impl");
        this.exception.expect(UnknownHostException.class);
        resolver.getAllByDomainName("unknown.foo.bar");
    }
}

