/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.test.TimedOutTestsListener;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.notification.Failure;

public class TestTimedOutTestsListener {
    @Test(timeout=30000L)
    public void testThreadDumpAndDeadlocks() throws Exception {
        new Deadlock();
        String s = null;
        while ((s = TimedOutTestsListener.buildDeadlockInfo()) == null) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)3L, (long)this.countStringOccurrences(s, "BLOCKED"));
        Failure failure = new Failure(null, (Throwable)new Exception("test timed out after"));
        StringWriter writer = new StringWriter();
        new TimedOutTestsListener(new PrintWriter(writer)).testFailure(failure);
        String out = writer.toString();
        Assert.assertTrue((boolean)out.contains("THREAD DUMP"));
        Assert.assertTrue((boolean)out.contains("DEADLOCKS DETECTED"));
        System.out.println(out);
    }

    private int countStringOccurrences(String s, String substr) {
        int n = 0;
        int index = 0;
        while ((index = s.indexOf(substr, index) + 1) != 0) {
            ++n;
        }
        return n;
    }

    public static class Deadlock {
        private CyclicBarrier barrier = new CyclicBarrier(6);

        public Deadlock() {
            DeadlockThread[] dThreads = new DeadlockThread[6];
            Monitor a = new Monitor("a");
            Monitor b = new Monitor("b");
            Monitor c = new Monitor("c");
            dThreads[0] = new DeadlockThread("MThread-1", a, b);
            dThreads[1] = new DeadlockThread("MThread-2", b, c);
            dThreads[2] = new DeadlockThread("MThread-3", c, a);
            ReentrantLock d = new ReentrantLock();
            ReentrantLock e = new ReentrantLock();
            ReentrantLock f = new ReentrantLock();
            dThreads[3] = new DeadlockThread("SThread-4", d, e);
            dThreads[4] = new DeadlockThread("SThread-5", e, f);
            dThreads[5] = new DeadlockThread("SThread-6", f, d);
            for (int i = 0; i < 6; ++i) {
                dThreads[i].setDaemon(true);
                dThreads[i].start();
            }
        }

        class Monitor {
            String name;

            Monitor(String name) {
                this.name = name;
            }
        }

        class DeadlockThread
        extends Thread {
            private Lock lock1;
            private Lock lock2;
            private Monitor mon1;
            private Monitor mon2;
            private boolean useSync;

            DeadlockThread(String name, Lock lock1, Lock lock2) {
                super(name);
                this.lock1 = null;
                this.lock2 = null;
                this.mon1 = null;
                this.mon2 = null;
                this.lock1 = lock1;
                this.lock2 = lock2;
                this.useSync = true;
            }

            DeadlockThread(String name, Monitor mon1, Monitor mon2) {
                super(name);
                this.lock1 = null;
                this.lock2 = null;
                this.mon1 = null;
                this.mon2 = null;
                this.mon1 = mon1;
                this.mon2 = mon2;
                this.useSync = false;
            }

            @Override
            public void run() {
                if (this.useSync) {
                    this.syncLock();
                } else {
                    this.monitorLock();
                }
            }

            private void syncLock() {
                this.lock1.lock();
                try {
                    try {
                        Deadlock.this.barrier.await();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.goSyncDeadlock();
                }
                finally {
                    this.lock1.unlock();
                }
            }

            private void goSyncDeadlock() {
                try {
                    Deadlock.this.barrier.await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.lock2.lock();
                throw new RuntimeException("should not reach here.");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void monitorLock() {
                Monitor monitor = this.mon1;
                synchronized (monitor) {
                    try {
                        Deadlock.this.barrier.await();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.goMonitorDeadlock();
                }
            }

            private void goMonitorDeadlock() {
                try {
                    Deadlock.this.barrier.await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Monitor monitor = this.mon2;
                synchronized (monitor) {
                    throw new RuntimeException(this.getName() + " should not reach here.");
                }
            }
        }
    }
}

