/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

abstract class AlgebraicMathBase<T>
extends EvalFunc<T>
implements Algebraic {
    protected KnownOpProvider opProvider;

    AlgebraicMathBase() {
    }

    protected void setOp(final KNOWN_OP op) {
        this.opProvider = new KnownOpProvider(){

            @Override
            public KNOWN_OP getOp() {
                return op;
            }
        };
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        for (Class<?> c : this.getClass().getDeclaredClasses()) {
            if (!Intermediate.class.isAssignableFrom(c)) continue;
            return c.getName();
        }
        for (Class<?> c : this.getClass().getClasses()) {
            if (!Intermediate.class.isAssignableFrom(c)) continue;
            return c.getName();
        }
        return null;
    }

    @Override
    public String getFinal() {
        for (Class<?> c : this.getClass().getDeclaredClasses()) {
            if (!Final.class.isAssignableFrom(c)) continue;
            return c.getName();
        }
        for (Class<?> c : this.getClass().getClasses()) {
            if (!Final.class.isAssignableFrom(c)) continue;
            return c.getName();
        }
        return null;
    }

    public static abstract class Final<T>
    extends EvalFunc<T>
    implements KnownOpProvider {
    }

    public static abstract class Intermediate
    extends EvalFunc<Tuple>
    implements KnownOpProvider {
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag bg = (DataBag)input.get(0);
                if (bg.iterator().hasNext()) {
                    return bg.iterator().next();
                }
                return tfact.newTuple((Object)null);
            }
            catch (ExecException e) {
                throw e;
            }
            catch (Exception e) {
                int errCode = 2106;
                throw new ExecException("Error executing an algebraic function", errCode, 4, e);
            }
        }
    }

    protected static interface KnownOpProvider {
        public KNOWN_OP getOp();
    }

    protected static enum KNOWN_OP {
        SUM,
        MIN,
        MAX;

    }
}

