/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.OperatorSubPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

public class MergeForEach
extends Rule {
    private OperatorSubPlan subPlan;

    public MergeForEach(String name) {
        super(name, false);
    }

    @Override
    protected OperatorPlan buildPattern() {
        LogicalPlan plan = new LogicalPlan();
        LOForEach foreach1 = new LOForEach(plan);
        plan.add(foreach1);
        return plan;
    }

    @Override
    public Transformer getNewTransformer() {
        return new MergeForEachTransformer();
    }

    public class MergeForEachTransformer
    extends Transformer {
        @Override
        public boolean check(OperatorPlan matched) throws FrontendException {
            LOForEach foreach1 = (LOForEach)matched.getSources().get(0);
            List<Operator> succs = MergeForEach.this.currentPlan.getSuccessors(foreach1);
            if (succs == null || succs.size() != 1 || !(succs.get(0) instanceof LOForEach)) {
                return false;
            }
            LOForEach foreach2 = (LOForEach)succs.get(0);
            Iterator<Operator> it = foreach2.getInnerPlan().getOperators();
            while (it.hasNext()) {
                Operator op = it.next();
                if (op instanceof LOGenerate || op instanceof LOInnerLoad) continue;
                return false;
            }
            LOGenerate gen1 = (LOGenerate)foreach1.getInnerPlan().getSinks().get(0);
            for (boolean flatten : gen1.getFlattenFlags()) {
                if (!flatten) continue;
                return false;
            }
            if (gen1.getUserDefinedSchema() != null) {
                Object object = gen1.getUserDefinedSchema().iterator();
                while (object.hasNext()) {
                    LogicalSchema s = (LogicalSchema)object.next();
                    if (s == null) continue;
                    return false;
                }
            }
            HashSet<Integer> inputs = new HashSet<Integer>();
            boolean duplicateInputs = false;
            for (Operator op : foreach2.getInnerPlan().getSources()) {
                if (!(op instanceof LOInnerLoad)) continue;
                LOInnerLoad innerLoad = (LOInnerLoad)op;
                int input = innerLoad.getProjection().getColNum();
                if (inputs.contains(input)) {
                    duplicateInputs = true;
                    break;
                }
                inputs.add(input);
                if (!innerLoad.getProjection().isRangeOrStarProject()) continue;
                return false;
            }
            if (duplicateInputs) {
                Iterator<Operator> it1 = foreach1.getInnerPlan().getOperators();
                while (it1.hasNext()) {
                    Operator op = it1.next();
                    if (!(op instanceof LOGenerate) && !(op instanceof LOInnerLoad)) {
                        return false;
                    }
                    if (!(op instanceof LOGenerate)) continue;
                    List<LogicalExpressionPlan> outputPlans = ((LOGenerate)op).getOutputPlans();
                    for (LogicalExpressionPlan outputPlan : outputPlans) {
                        Iterator<Operator> iter = outputPlan.getOperators();
                        while (iter.hasNext()) {
                            if (iter.next() instanceof ProjectExpression) continue;
                            return false;
                        }
                    }
                }
            }
            return true;
        }

        @Override
        public OperatorPlan reportChanges() {
            return MergeForEach.this.subPlan;
        }

        private Operator getOperatorToMerge(Operator op, OperatorPlan newPlan, LOForEach newForEach) {
            Operator opToMerge = op;
            if (op instanceof LOInnerLoad) {
                opToMerge = new LOInnerLoad(newPlan, newForEach, ((LOInnerLoad)op).getColNum());
            } else {
                opToMerge.setPlan(newPlan);
            }
            return opToMerge;
        }

        private Operator addBranchToPlan(LOGenerate gen, int branch, OperatorPlan newPlan, LOForEach newForEach) {
            Operator op = gen.getPlan().getPredecessors(gen).get(branch);
            Operator opToMerge = this.getOperatorToMerge(op, newPlan, newForEach);
            newPlan.add(opToMerge);
            Operator opNextToGen = opToMerge;
            Operator pred = gen.getPlan().getPredecessors(op) != null ? gen.getPlan().getPredecessors(op).get(0) : null;
            while (pred != null) {
                Operator predToMerge = this.getOperatorToMerge(pred, newPlan, newForEach);
                newPlan.add(predToMerge);
                newPlan.connect(predToMerge, op);
                op = pred;
                if (gen.getPlan().getPredecessors(pred) != null) {
                    pred = gen.getPlan().getPredecessors(pred).get(0);
                    continue;
                }
                pred = null;
            }
            return opNextToGen;
        }

        @Override
        public void transform(OperatorPlan matched) throws FrontendException {
            MergeForEach.this.subPlan = new OperatorSubPlan(MergeForEach.this.currentPlan);
            LOForEach foreach1 = (LOForEach)matched.getSources().get(0);
            LOGenerate gen1 = (LOGenerate)foreach1.getInnerPlan().getSinks().get(0);
            LOForEach foreach2 = (LOForEach)MergeForEach.this.currentPlan.getSuccessors(foreach1).get(0);
            LOGenerate gen2 = (LOGenerate)foreach2.getInnerPlan().getSinks().get(0);
            LOForEach newForEach = new LOForEach(MergeForEach.this.currentPlan);
            LogicalPlan newForEachInnerPlan = new LogicalPlan();
            newForEach.setInnerPlan(newForEachInnerPlan);
            newForEach.setAlias(foreach2.getAlias());
            newForEach.setRequestedParallelism(foreach1.getRequestedParallelism());
            ArrayList<LogicalExpressionPlan> newExpList = new ArrayList<LogicalExpressionPlan>();
            LOGenerate newGen = new LOGenerate(newForEachInnerPlan, newExpList, gen2.getFlattenFlags());
            newGen.setUserDefinedSchema(gen2.getUserDefinedSchema());
            newForEachInnerPlan.add(newGen);
            for (LogicalExpressionPlan exp2 : gen2.getOutputPlans()) {
                LogicalExpressionPlan newExpPlan = new LogicalExpressionPlan();
                LogicalExpressionPlan exp2Copy = exp2.deepCopy();
                newExpPlan.merge(exp2Copy);
                ArrayList<Operator> exp2Sinks = new ArrayList<Operator>();
                exp2Sinks.addAll(newExpPlan.getSinks());
                for (Operator exp2Sink : exp2Sinks) {
                    if (!(exp2Sink instanceof ProjectExpression)) continue;
                    ProjectExpression proj = (ProjectExpression)exp2Sink;
                    LOInnerLoad innerLoad = (LOInnerLoad)foreach2.getInnerPlan().getPredecessors(gen2).get(proj.getInputNum());
                    int exp1Pos = innerLoad.getProjection().getColNum();
                    LogicalExpressionPlan exp1 = gen1.getOutputPlans().get(exp1Pos);
                    LogicalExpressionPlan exp1Copy = exp1.deepCopy();
                    List<Operator> exp1Sources = newExpPlan.merge(exp1Copy);
                    Operator exp1Source = exp1Sources.get(0);
                    if (newExpPlan.getPredecessors(exp2Sink) != null) {
                        Operator exp2NextToSink = newExpPlan.getPredecessors(exp2Sink).get(0);
                        Pair<Integer, Integer> pos = newExpPlan.disconnect(exp2NextToSink, exp2Sink);
                        newExpPlan.remove(exp2Sink);
                        newExpPlan.connect(exp2NextToSink, (Integer)pos.first, exp1Source, 0);
                        continue;
                    }
                    newExpPlan.remove(exp2Sink);
                }
                List<Operator> exp1Sinks = newExpPlan.getSinks();
                for (Operator exp1Sink : exp1Sinks) {
                    if (!(exp1Sink instanceof ProjectExpression)) continue;
                    Operator opNextToGen = this.addBranchToPlan(gen1, ((ProjectExpression)exp1Sink).getInputNum(), newForEachInnerPlan, newForEach);
                    newForEachInnerPlan.connect(opNextToGen, newGen);
                    int input = newForEachInnerPlan.getPredecessors(newGen).indexOf(opNextToGen);
                    ((ProjectExpression)exp1Sink).setInputNum(input);
                }
                newExpList.add(newExpPlan);
            }
            for (LogicalExpressionPlan p : newGen.getOutputPlans()) {
                Iterator<Operator> iter = p.getOperators();
                while (iter.hasNext()) {
                    Operator op = iter.next();
                    if (!(op instanceof ProjectExpression)) continue;
                    ((ProjectExpression)op).setAttachedRelationalOp(newGen);
                }
            }
            Iterator<Operator> iter = newForEach.getInnerPlan().getOperators();
            while (iter.hasNext()) {
                Operator op = iter.next();
                if (!(op instanceof LOInnerLoad)) continue;
                ((LOInnerLoad)op).getProjection().setAttachedRelationalOp(newForEach);
            }
            Collection<Operator> newSoftLinkPreds = Utils.mergeCollection(MergeForEach.this.currentPlan.getSoftLinkPredecessors(foreach1), MergeForEach.this.currentPlan.getSoftLinkPredecessors(foreach2));
            ArrayList<Operator> foreach1SoftLinkPred = null;
            if (MergeForEach.this.currentPlan.getSoftLinkPredecessors(foreach1) != null) {
                foreach1SoftLinkPred = new ArrayList<Operator>();
                foreach1SoftLinkPred.addAll(MergeForEach.this.currentPlan.getSoftLinkPredecessors(foreach1));
            }
            if (foreach1SoftLinkPred != null) {
                for (Operator softPred : foreach1SoftLinkPred) {
                    MergeForEach.this.currentPlan.removeSoftLink(softPred, foreach1);
                }
            }
            ArrayList<Operator> foreach2SoftLinkPred = null;
            if (MergeForEach.this.currentPlan.getSoftLinkPredecessors(foreach2) != null) {
                foreach2SoftLinkPred = new ArrayList<Operator>();
                foreach2SoftLinkPred.addAll(MergeForEach.this.currentPlan.getSoftLinkPredecessors(foreach2));
            }
            if (foreach2SoftLinkPred != null) {
                for (Operator softPred : foreach2SoftLinkPred) {
                    MergeForEach.this.currentPlan.removeSoftLink(softPred, foreach2);
                }
            }
            MergeForEach.this.currentPlan.removeAndReconnect(foreach1);
            MergeForEach.this.currentPlan.replace(foreach2, newForEach);
            if (newSoftLinkPreds != null) {
                for (Operator softPred : newSoftLinkPreds) {
                    MergeForEach.this.currentPlan.createSoftLink(softPred, newForEach);
                }
            }
            MergeForEach.this.subPlan.add(newForEach);
        }
    }
}

