/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Ptr;
import org.jcodings.constants.PosixBracket;
import org.jcodings.unicode.UnicodeEncoding;
import org.joni.ApplyCaseFold;
import org.joni.ApplyCaseFoldArg;
import org.joni.BitStatus;
import org.joni.Lexer;
import org.joni.NameEntry;
import org.joni.Option;
import org.joni.Regex;
import org.joni.ScanEnvironment;
import org.joni.ast.AnchorNode;
import org.joni.ast.AnyCharNode;
import org.joni.ast.BackRefNode;
import org.joni.ast.CClassNode;
import org.joni.ast.CTypeNode;
import org.joni.ast.CallNode;
import org.joni.ast.ConsAltNode;
import org.joni.ast.EncloseNode;
import org.joni.ast.Node;
import org.joni.ast.QuantifierNode;
import org.joni.ast.StateNode;
import org.joni.ast.StringNode;
import org.joni.constants.TokenType;

class Parser
extends Lexer {
    protected final Regex regex;
    protected Node root;
    protected int returnCode;
    private static final int POSIX_BRACKET_NAME_MIN_LEN = 4;
    private static final int POSIX_BRACKET_CHECK_LIMIT_LENGTH = 20;
    private static final byte[] BRACKET_END = ":]".getBytes();

    protected Parser(ScanEnvironment env, byte[] bytes2, int p2, int end2) {
        super(env, bytes2, p2, end2);
        this.regex = env.reg;
    }

    protected final Node parse() {
        this.root = this.parseRegexp();
        this.regex.numMem = this.env.numMem;
        return this.root;
    }

    private boolean parsePosixBracket(CClassNode cc) {
        boolean not;
        this.mark();
        if (this.peekIs(94)) {
            this.inc();
            not = true;
        } else {
            not = false;
        }
        if (this.enc.strLength(this.bytes, this.p, this.stop) >= 7) {
            byte[][] pbs = PosixBracket.PBSNamesLower;
            for (int i2 = 0; i2 < pbs.length; ++i2) {
                byte[] name2 = pbs[i2];
                if (this.enc.strNCmp(this.bytes, this.p, this.stop, name2, 0, name2.length) != 0) continue;
                this.p = this.enc.step(this.bytes, this.p, this.stop, name2.length);
                if (this.enc.strNCmp(this.bytes, this.p, this.stop, BRACKET_END, 0, BRACKET_END.length) != 0) {
                    this.newSyntaxException("invalid POSIX bracket type");
                }
                cc.addCType(PosixBracket.PBSValues[i2], not, this.env, this);
                this.inc();
                this.inc();
                return false;
            }
        }
        this.c = 0;
        int i3 = 0;
        while (this.left() && (this.c = this.peek()) != 58 && this.c != 93) {
            this.inc();
            if (++i3 <= 20) continue;
        }
        if (this.c == 58 && this.left()) {
            this.inc();
            if (this.left()) {
                this.fetch();
                if (this.c == 93) {
                    this.newSyntaxException("invalid POSIX bracket type");
                }
            }
        }
        this.restore();
        return true;
    }

    private CClassNode parseCharProperty() {
        int ctype = this.fetchCharPropertyToCType();
        CClassNode n = new CClassNode();
        n.addCType(ctype, false, this.env, this);
        if (this.token.getPropNot()) {
            n.setNot();
        }
        return n;
    }

    private boolean codeExistCheck(int code, boolean ignoreEscaped) {
        this.mark();
        boolean inEsc = false;
        while (this.left()) {
            if (ignoreEscaped && inEsc) {
                inEsc = false;
                continue;
            }
            this.fetch();
            if (this.c == code) {
                this.restore();
                return true;
            }
            if (this.c != this.syntax.metaCharTable.esc) continue;
            inEsc = true;
        }
        this.restore();
        return false;
    }

    private CClassNode parseCharClass() {
        boolean neg;
        this.fetchTokenInCC();
        if (this.token.type == TokenType.CHAR && this.token.getC() == 94 && !this.token.escaped) {
            neg = true;
            this.fetchTokenInCC();
        } else {
            neg = false;
        }
        if (this.token.type == TokenType.CC_CLOSE && !this.syntax.op2OptionECMAScript()) {
            if (!this.codeExistCheck(93, true)) {
                this.newSyntaxException("empty char-class");
            }
            this.env.ccEscWarn("]");
            this.token.type = TokenType.CHAR;
        }
        CClassNode cc = new CClassNode();
        CClassNode prevCC = null;
        CClassNode workCC = null;
        CClassNode.CCStateArg arg2 = new CClassNode.CCStateArg();
        boolean andStart = false;
        arg2.state = CClassNode.CCSTATE.START;
        while (this.token.type != TokenType.CC_CLOSE) {
            boolean fetched = false;
            switch (this.token.type) {
                case CHAR: {
                    int len;
                    arg2.inType = this.token.getCode() >= 256 || (len = this.enc.codeToMbcLength(this.token.getC())) > 1 ? CClassNode.CCVALTYPE.CODE_POINT : CClassNode.CCVALTYPE.SB;
                    arg2.v = this.token.getC();
                    arg2.vIsRaw = false;
                    this.parseCharClassValEntry2(cc, arg2);
                    break;
                }
                case RAW_BYTE: {
                    int len;
                    if (!this.enc.isSingleByte() && this.token.base != 0) {
                        int i2;
                        byte[] buf = new byte[18];
                        int psave = this.p;
                        int base = this.token.base;
                        buf[0] = (byte)this.token.getC();
                        for (i2 = 1; i2 < this.enc.maxLength(); ++i2) {
                            this.fetchTokenInCC();
                            if (this.token.type != TokenType.RAW_BYTE || this.token.base != base) {
                                fetched = true;
                                break;
                            }
                            buf[i2] = (byte)this.token.getC();
                        }
                        if (i2 < this.enc.minLength()) {
                            this.newValueException("too short multibyte code string");
                        }
                        if (i2 < (len = this.enc.length(buf, 0, i2))) {
                            this.newValueException("too short multibyte code string");
                        } else if (i2 > len) {
                            this.p = psave;
                            for (i2 = 1; i2 < len; ++i2) {
                                this.fetchTokenInCC();
                            }
                            fetched = false;
                        }
                        if (i2 == 1) {
                            arg2.v = buf[0] & 0xFF;
                            arg2.inType = CClassNode.CCVALTYPE.SB;
                        } else {
                            arg2.v = this.enc.mbcToCode(buf, 0, buf.length);
                            arg2.inType = CClassNode.CCVALTYPE.CODE_POINT;
                        }
                    } else {
                        arg2.v = this.token.getC();
                        arg2.inType = CClassNode.CCVALTYPE.SB;
                    }
                    arg2.vIsRaw = true;
                    this.parseCharClassValEntry2(cc, arg2);
                    break;
                }
                case CODE_POINT: {
                    arg2.v = this.token.getCode();
                    arg2.vIsRaw = true;
                    this.parseCharClassValEntry(cc, arg2);
                    break;
                }
                case POSIX_BRACKET_OPEN: {
                    if (this.parsePosixBracket(cc)) {
                        this.env.ccEscWarn("[");
                        this.p = this.token.backP;
                        arg2.v = this.token.getC();
                        arg2.vIsRaw = false;
                        this.parseCharClassValEntry(cc, arg2);
                        break;
                    }
                    cc.nextStateClass(arg2, this.env);
                    break;
                }
                case CHAR_TYPE: {
                    cc.addCType(this.token.getPropCType(), this.token.getPropNot(), this.env, this);
                    cc.nextStateClass(arg2, this.env);
                    break;
                }
                case CHAR_PROPERTY: {
                    int ctype = this.fetchCharPropertyToCType();
                    cc.addCType(ctype, this.token.getPropNot(), this.env, this);
                    cc.nextStateClass(arg2, this.env);
                    break;
                }
                case CC_RANGE: {
                    if (arg2.state == CClassNode.CCSTATE.VALUE) {
                        this.fetchTokenInCC();
                        fetched = true;
                        if (this.token.type == TokenType.CC_CLOSE) {
                            this.parseCharClassRangeEndVal(cc, arg2);
                            break;
                        }
                        if (this.token.type == TokenType.CC_AND) {
                            this.env.ccEscWarn("-");
                            this.parseCharClassRangeEndVal(cc, arg2);
                            break;
                        }
                        arg2.state = CClassNode.CCSTATE.RANGE;
                        break;
                    }
                    if (arg2.state == CClassNode.CCSTATE.START) {
                        arg2.v = this.token.getC();
                        arg2.vIsRaw = false;
                        this.fetchTokenInCC();
                        fetched = true;
                        if (this.token.type == TokenType.CC_RANGE || andStart) {
                            this.env.ccEscWarn("-");
                        }
                        this.parseCharClassValEntry(cc, arg2);
                        break;
                    }
                    if (arg2.state == CClassNode.CCSTATE.RANGE) {
                        this.env.ccEscWarn("-");
                        this.parseCharClassSbChar(cc, arg2);
                        break;
                    }
                    this.fetchTokenInCC();
                    fetched = true;
                    if (this.token.type == TokenType.CC_CLOSE) {
                        this.parseCharClassRangeEndVal(cc, arg2);
                        break;
                    }
                    if (this.token.type == TokenType.CC_AND) {
                        this.env.ccEscWarn("-");
                        this.parseCharClassRangeEndVal(cc, arg2);
                        break;
                    }
                    if (this.syntax.allowDoubleRangeOpInCC()) {
                        this.env.ccEscWarn("-");
                        this.parseCharClassSbChar(cc, arg2);
                        break;
                    }
                    this.newSyntaxException("unmatched range specifier in char-class");
                    break;
                }
                case CC_CC_OPEN: {
                    CClassNode acc = this.parseCharClass();
                    cc.or(acc, this.enc);
                    break;
                }
                case CC_AND: {
                    if (arg2.state == CClassNode.CCSTATE.VALUE) {
                        arg2.v = 0;
                        arg2.vIsRaw = false;
                        cc.nextStateValue(arg2, this.env);
                    }
                    andStart = true;
                    arg2.state = CClassNode.CCSTATE.START;
                    if (prevCC != null) {
                        prevCC.and(cc, this.enc);
                    } else {
                        prevCC = cc;
                        if (workCC == null) {
                            workCC = new CClassNode();
                        }
                        cc = workCC;
                    }
                    cc.clear();
                    break;
                }
                case EOT: {
                    this.newSyntaxException("premature end of char-class");
                }
                default: {
                    this.newInternalException("internal parser error (bug)");
                }
            }
            if (fetched) continue;
            this.fetchTokenInCC();
        }
        if (arg2.state == CClassNode.CCSTATE.VALUE) {
            arg2.v = 0;
            arg2.vIsRaw = false;
            cc.nextStateValue(arg2, this.env);
        }
        if (prevCC != null) {
            prevCC.and(cc, this.enc);
            cc = prevCC;
        }
        if (neg) {
            cc.setNot();
        } else {
            cc.clearNot();
        }
        if (cc.isNot() && this.syntax.notNewlineInNegativeCC() && !cc.isEmpty()) {
            int NEW_LINE = 10;
            if (this.enc.isNewLine(10)) {
                if (this.enc.codeToMbcLength(10) == 1) {
                    cc.bs.set(10);
                } else {
                    cc.addCodeRange(this.env, 10, 10);
                }
            }
        }
        return cc;
    }

    private void parseCharClassSbChar(CClassNode cc, CClassNode.CCStateArg arg2) {
        arg2.inType = CClassNode.CCVALTYPE.SB;
        arg2.v = this.token.getC();
        arg2.vIsRaw = false;
        this.parseCharClassValEntry2(cc, arg2);
    }

    private void parseCharClassRangeEndVal(CClassNode cc, CClassNode.CCStateArg arg2) {
        arg2.v = 45;
        arg2.vIsRaw = false;
        this.parseCharClassValEntry(cc, arg2);
    }

    private void parseCharClassValEntry(CClassNode cc, CClassNode.CCStateArg arg2) {
        int len = this.enc.codeToMbcLength(arg2.v);
        arg2.inType = len == 1 ? CClassNode.CCVALTYPE.SB : CClassNode.CCVALTYPE.CODE_POINT;
        this.parseCharClassValEntry2(cc, arg2);
    }

    private void parseCharClassValEntry2(CClassNode cc, CClassNode.CCStateArg arg2) {
        cc.nextStateValue(arg2, this.env);
    }

    private Node parseEnclose(TokenType term) {
        EncloseNode en;
        Node node;
        block68: {
            int num;
            block67: {
                node = null;
                if (!this.left()) {
                    this.newSyntaxException("end pattern with unmatched parenthesis");
                }
                int option = this.env.option;
                if (!this.peekIs(63) || !this.syntax.op2QMarkGroupEffect()) break block67;
                this.inc();
                if (!this.left()) {
                    this.newSyntaxException("end pattern in group");
                }
                boolean listCapture = false;
                this.fetch();
                switch (this.c) {
                    case 58: {
                        this.fetchToken();
                        node = this.parseSubExp(term);
                        this.returnCode = 1;
                        return node;
                    }
                    case 61: {
                        node = new AnchorNode(1024);
                        break;
                    }
                    case 33: {
                        node = new AnchorNode(2048);
                        if (this.syntax.op2OptionECMAScript()) {
                            this.env.pushPrecReadNotNode(node);
                            break;
                        }
                        break block68;
                    }
                    case 62: {
                        node = new EncloseNode(4);
                        break;
                    }
                    case 39: {
                        if (this.syntax.op2QMarkLtNamedGroup()) {
                            listCapture = false;
                            node = this.parseEncloseNamedGroup2(listCapture);
                            break;
                        }
                        this.newSyntaxException("undefined group option");
                        break;
                    }
                    case 60: {
                        this.fetch();
                        if (this.c == 61) {
                            node = new AnchorNode(4096);
                            break;
                        }
                        if (this.c == 33) {
                            node = new AnchorNode(8192);
                            break;
                        }
                        if (this.syntax.op2QMarkLtNamedGroup()) {
                            this.unfetch();
                            this.c = 60;
                            listCapture = false;
                            node = this.parseEncloseNamedGroup2(listCapture);
                            break;
                        }
                        this.newSyntaxException("undefined group option");
                        break;
                    }
                    case 64: {
                        if (this.syntax.op2AtMarkCaptureHistory()) {
                            if (this.syntax.op2QMarkLtNamedGroup()) {
                                this.fetch();
                                if (this.c == 60 || this.c == 39) {
                                    listCapture = true;
                                    node = this.parseEncloseNamedGroup2(listCapture);
                                }
                                this.unfetch();
                            }
                            en = new EncloseNode(this.env.option, false);
                            int num2 = this.env.addMemEntry();
                            if (num2 >= 32) {
                                this.newValueException("group number is too big for capture history");
                            }
                            en.regNum = num2;
                            node = en;
                            break;
                        }
                        this.newSyntaxException("undefined group option");
                        break;
                    }
                    case 40: {
                        if (this.syntax.op2QMarkLParenCondition()) {
                            int num3 = -1;
                            int name2 = -1;
                            this.fetch();
                            if (this.enc.isDigit(this.c)) {
                                this.unfetch();
                                num3 = this.fetchName(40, true);
                                if (this.syntax.strictCheckBackref() && (num3 > this.env.numMem || this.env.memNodes == null || this.env.memNodes[num3] == null)) {
                                    this.newValueException("invalid backref number/name");
                                }
                            } else if (this.c == 60 || this.c == 39) {
                                NameEntry e;
                                name2 = this.p;
                                num3 = this.fetchName(this.c, false);
                                int nameEnd = this.value;
                                this.fetch();
                                if (this.c != 41) {
                                    this.newSyntaxException("undefined group option");
                                }
                                if ((e = this.env.reg.nameToGroupNumbers(this.bytes, name2, nameEnd)) == null) {
                                    this.newValueException("undefined name <%n> reference", name2, nameEnd);
                                }
                                if (this.syntax.strictCheckBackref()) {
                                    if (e.backNum == 1) {
                                        if (e.backRef1 > this.env.numMem || this.env.memNodes == null || this.env.memNodes[e.backRef1] == null) {
                                            this.newValueException("invalid backref number/name");
                                        }
                                    } else {
                                        for (int i2 = 0; i2 < e.backNum; ++i2) {
                                            if (e.backRefs[i2] <= this.env.numMem && this.env.memNodes != null && this.env.memNodes[e.backRefs[i2]] != null) continue;
                                            this.newValueException("invalid backref number/name");
                                        }
                                    }
                                }
                                num3 = e.backNum == 1 ? e.backRef1 : e.backRefs[0];
                            }
                            EncloseNode en2 = new EncloseNode(8);
                            en2.regNum = num3;
                            if (name2 != -1) {
                                en2.setNameRef();
                            }
                            node = en2;
                            break;
                        }
                        this.newSyntaxException("undefined group option");
                        break;
                    }
                    case 45: 
                    case 97: 
                    case 100: 
                    case 105: 
                    case 108: 
                    case 109: 
                    case 115: 
                    case 117: 
                    case 120: {
                        boolean neg = false;
                        while (true) {
                            switch (this.c) {
                                case 41: 
                                case 58: {
                                    break;
                                }
                                case 45: {
                                    neg = true;
                                    break;
                                }
                                case 120: {
                                    option = BitStatus.bsOnOff(option, 2, neg);
                                    break;
                                }
                                case 105: {
                                    option = BitStatus.bsOnOff(option, 1, neg);
                                    break;
                                }
                                case 115: {
                                    if (this.syntax.op2OptionPerl()) {
                                        option = BitStatus.bsOnOff(option, 4, neg);
                                        break;
                                    }
                                    this.newSyntaxException("undefined group option");
                                    break;
                                }
                                case 109: {
                                    if (this.syntax.op2OptionPerl()) {
                                        option = BitStatus.bsOnOff(option, 8, !neg);
                                        break;
                                    }
                                    if (this.syntax.op2OptionRuby()) {
                                        option = BitStatus.bsOnOff(option, 4, neg);
                                        break;
                                    }
                                    this.newSyntaxException("undefined group option");
                                    break;
                                }
                                case 97: {
                                    if ((this.syntax.op2OptionPerl() || this.syntax.op2OptionRuby()) && !neg) {
                                        option = BitStatus.bsOnOff(option, 4096, false);
                                        option = BitStatus.bsOnOff(option, 8192, true);
                                        option = BitStatus.bsOnOff(option, 16384, true);
                                        break;
                                    }
                                    this.newSyntaxException("undefined group option");
                                }
                                case 117: {
                                    if ((this.syntax.op2OptionPerl() || this.syntax.op2OptionRuby()) && !neg) {
                                        option = BitStatus.bsOnOff(option, 4096, true);
                                        option = BitStatus.bsOnOff(option, 8192, true);
                                        option = BitStatus.bsOnOff(option, 16384, true);
                                        break;
                                    }
                                    this.newSyntaxException("undefined group option");
                                }
                                case 100: {
                                    if (this.syntax.op2OptionPerl() && !neg) {
                                        option = BitStatus.bsOnOff(option, 4096, true);
                                        break;
                                    }
                                    if (this.syntax.op2OptionRuby() && !neg) {
                                        option = BitStatus.bsOnOff(option, 4096, false);
                                        option = BitStatus.bsOnOff(option, 8192, false);
                                        option = BitStatus.bsOnOff(option, 16384, false);
                                        break;
                                    }
                                    this.newSyntaxException("undefined group option");
                                    break;
                                }
                                case 108: {
                                    if (this.syntax.op2OptionPerl() && !neg) {
                                        option = BitStatus.bsOnOff(option, 4096, true);
                                        break;
                                    }
                                    this.newSyntaxException("undefined group option");
                                    break;
                                }
                                default: {
                                    this.newSyntaxException("undefined group option");
                                }
                            }
                            if (this.c == 41) {
                                EncloseNode en3 = new EncloseNode(option, 0);
                                node = en3;
                                this.returnCode = 2;
                                return node;
                            }
                            if (this.c == 58) {
                                int prev = this.env.option;
                                this.env.option = option;
                                this.fetchToken();
                                Node target = this.parseSubExp(term);
                                this.env.option = prev;
                                EncloseNode en4 = new EncloseNode(option, 0);
                                en4.setTarget(target);
                                node = en4;
                                this.returnCode = 0;
                                return node;
                            }
                            if (!this.left()) {
                                this.newSyntaxException("end pattern in group");
                            }
                            this.fetch();
                        }
                    }
                    default: {
                        this.newSyntaxException("undefined group option");
                        break;
                    }
                }
                break block68;
            }
            if (Option.isDontCaptureGroup(this.env.option)) {
                this.fetchToken();
                node = this.parseSubExp(term);
                this.returnCode = 1;
                return node;
            }
            EncloseNode en5 = new EncloseNode(this.env.option, false);
            en5.regNum = num = this.env.addMemEntry();
            node = en5;
        }
        this.fetchToken();
        Node target = this.parseSubExp(term);
        if (node.getType() == 7) {
            AnchorNode an = (AnchorNode)node;
            an.setTarget(target);
            if (this.syntax.op2OptionECMAScript() && an.type == 2048) {
                this.env.popPrecReadNotNode(an);
            }
        } else {
            en = (EncloseNode)node;
            en.setTarget(target);
            if (en.type == 1) {
                if (this.syntax.op2OptionECMAScript()) {
                    en.containingAnchor = this.env.currentPrecReadNotNode();
                }
                this.env.setMemNode(en.regNum, node);
            } else if (en.type == 8 && target.getType() != 9) {
                en.setTarget(ConsAltNode.newAltNode(target, ConsAltNode.newAltNode(StringNode.EMPTY, null)));
            }
        }
        this.returnCode = 0;
        return node;
    }

    private Node parseEncloseNamedGroup2(boolean listCapture) {
        int nm = this.p;
        int num = this.fetchName(this.c, false);
        int nameEnd = this.value;
        num = this.env.addMemEntry();
        if (listCapture && num >= 32) {
            this.newValueException("group number is too big for capture history");
        }
        this.regex.nameAdd(this.bytes, nm, nameEnd, num, this.syntax);
        EncloseNode en = new EncloseNode(this.env.option, true);
        en.regNum = num;
        EncloseNode node = en;
        if (listCapture) {
            this.env.captureHistory = BitStatus.bsOnAtSimple(this.env.captureHistory, num);
        }
        ++this.env.numNamed;
        return node;
    }

    private int findStrPosition(int[] s2, int n, int from, int to, Ptr nextChar) {
        int p2 = from;
        int i2 = 0;
        while (p2 < to) {
            int x = this.enc.mbcToCode(this.bytes, p2, to);
            int q = p2 + this.enc.length(this.bytes, p2, to);
            if (x == s2[0]) {
                for (i2 = 1; i2 < n && q < to && (x = this.enc.mbcToCode(this.bytes, q, to)) == s2[i2]; q += this.enc.length(this.bytes, q, to), ++i2) {
                }
                if (i2 >= n) {
                    if (this.bytes[nextChar.p] != 0) {
                        nextChar.p = q;
                    }
                    return p2;
                }
            }
            p2 = q;
        }
        return -1;
    }

    private Node parseExp(TokenType term) {
        if (this.token.type == term) {
            return StringNode.EMPTY;
        }
        Node node = null;
        boolean group2 = false;
        block0 : switch (this.token.type) {
            case EOT: 
            case ALT: {
                return StringNode.EMPTY;
            }
            case SUBEXP_OPEN: {
                node = this.parseEnclose(TokenType.SUBEXP_CLOSE);
                if (this.returnCode == 1) {
                    group2 = true;
                    break;
                }
                if (this.returnCode != 2) break;
                int prev = this.env.option;
                EncloseNode en = (EncloseNode)node;
                this.env.option = en.option;
                this.fetchToken();
                Node target = this.parseSubExp(term);
                this.env.option = prev;
                en.setTarget(target);
                return node;
            }
            case SUBEXP_CLOSE: {
                if (!this.syntax.allowUnmatchedCloseSubexp()) {
                    this.newSyntaxException("unmatched close parenthesis");
                }
                if (this.token.escaped) {
                    return this.parseExpTkRawByte(group2);
                }
                return this.parseExpTkByte(group2);
            }
            case LINEBREAK: {
                byte[] buflb = new byte[14];
                int len1 = this.enc.codeToMbc(13, buflb, 0);
                int len2 = this.enc.codeToMbc(10, buflb, len1);
                StringNode left2 = new StringNode(buflb, 0, len1 + len2);
                left2.setRaw();
                CClassNode right = new CClassNode();
                if (this.enc.minLength() > 1) {
                    right.addCodeRange(this.env, 10, 13);
                } else {
                    right.bs.setRange(10, 13);
                }
                if (this.enc.toString().startsWith("UTF")) {
                    right.addCodeRange(this.env, 133, 133);
                    right.addCodeRange(this.env, 8232, 8233);
                }
                EncloseNode en = new EncloseNode(4);
                en.setTarget(ConsAltNode.newAltNode(left2, ConsAltNode.newAltNode(right, null)));
                node = en;
                break;
            }
            case EXTENDED_GRAPHEME_CLUSTER: {
                int ctype;
                if (this.enc instanceof UnicodeEncoding && (ctype = this.enc.propertyNameToCType(new byte[]{77}, 0, 1)) > 0) {
                    CClassNode cc1 = new CClassNode();
                    cc1.addCType(ctype, false, this.env, this);
                    cc1.setNot();
                    CClassNode cc2 = new CClassNode();
                    cc1.addCType(ctype, false, this.env, this);
                    QuantifierNode qn = new QuantifierNode(0, -1, false);
                    qn.setTarget(cc2);
                    EncloseNode en2 = new EncloseNode(4);
                    en2.setTarget(ConsAltNode.newListNode(cc1, ConsAltNode.newListNode(qn, null)));
                    node = en2;
                }
                if (node != null) break;
                AnyCharNode np1 = new AnyCharNode();
                EncloseNode on = new EncloseNode(BitStatus.bsOnOff(this.env.option, 4, false), 0);
                on.setTarget(np1);
                node = np1;
                break;
            }
            case KEEP: {
                node = new AnchorNode(65536);
                break;
            }
            case STRING: {
                return this.parseExpTkByte(group2);
            }
            case RAW_BYTE: {
                return this.parseExpTkRawByte(group2);
            }
            case CODE_POINT: {
                byte[] buf = new byte[7];
                int num = this.enc.codeToMbc(this.token.getCode(), buf, 0);
                node = new StringNode(buf, 0, num);
                break;
            }
            case QUOTE_OPEN: {
                int[] endOp = new int[]{this.syntax.metaCharTable.esc, 69};
                int qstart = this.p;
                Ptr nextChar = new Ptr();
                int qend = this.findStrPosition(endOp, endOp.length, qstart, this.stop, nextChar);
                if (qend == -1) {
                    nextChar.p = qend = this.stop;
                }
                node = new StringNode(this.bytes, qstart, qend);
                this.p = nextChar.p;
                break;
            }
            case CHAR_TYPE: {
                switch (this.token.getPropCType()) {
                    case 260: 
                    case 265: 
                    case 268: {
                        CClassNode cc = new CClassNode();
                        cc.addCType(this.token.getPropCType(), false, this.env, this);
                        if (this.token.getPropNot()) {
                            cc.setNot();
                        }
                        node = cc;
                        break block0;
                    }
                    case 12: {
                        node = new CTypeNode(this.token.getPropCType(), this.token.getPropNot(), false);
                        break block0;
                    }
                    case 4: 
                    case 9: 
                    case 11: {
                        CClassNode ccn = new CClassNode();
                        ccn.addCType(this.token.getPropCType(), false, this.env, this);
                        if (this.token.getPropNot()) {
                            ccn.setNot();
                        }
                        node = ccn;
                        break block0;
                    }
                }
                this.newInternalException("internal parser error (bug)");
                break;
            }
            case CHAR_PROPERTY: {
                node = this.parseCharProperty();
                break;
            }
            case CC_CC_OPEN: {
                CClassNode cc;
                node = cc = this.parseCharClass();
                if (!Option.isIgnoreCase(this.env.option)) break;
                ApplyCaseFoldArg arg2 = new ApplyCaseFoldArg(this.env, cc);
                this.enc.applyAllCaseFold(this.env.caseFoldFlag, ApplyCaseFold.INSTANCE, arg2);
                if (arg2.altRoot == null) break;
                node = ConsAltNode.newAltNode(node, arg2.altRoot);
                break;
            }
            case ANYCHAR: {
                node = new AnyCharNode();
                break;
            }
            case ANYCHAR_ANYTIME: {
                node = new AnyCharNode();
                QuantifierNode qn = new QuantifierNode(0, -1, false);
                qn.setTarget(node);
                node = qn;
                break;
            }
            case BACKREF: {
                int[] nArray;
                if (this.syntax.op2OptionECMAScript() && this.token.getBackrefNum() == 1 && this.env.memNodes != null) {
                    EncloseNode encloseNode = (EncloseNode)this.env.memNodes[this.token.getBackrefRef1()];
                    boolean shouldIgnore = false;
                    if (encloseNode != null && encloseNode.containingAnchor != null) {
                        shouldIgnore = true;
                        for (Node anchorNode : this.env.precReadNotNodes) {
                            if (anchorNode != encloseNode.containingAnchor) continue;
                            shouldIgnore = false;
                            break;
                        }
                    }
                    if (shouldIgnore) {
                        node = StringNode.EMPTY;
                        break;
                    }
                    node = new BackRefNode(this.token.getBackrefNum(), new int[]{this.token.getBackrefRef1()}, this.token.getBackrefByName(), this.token.getBackrefExistLevel(), this.token.getBackrefLevel(), this.env);
                    break;
                }
                if (this.token.getBackrefNum() > 1) {
                    nArray = this.token.getBackrefRefs();
                } else {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = this.token.getBackrefRef1();
                }
                int[] backRefs = nArray;
                node = new BackRefNode(this.token.getBackrefNum(), backRefs, this.token.getBackrefByName(), this.token.getBackrefExistLevel(), this.token.getBackrefLevel(), this.env);
                break;
            }
            case CALL: {
                int gNum = this.token.getCallGNum();
                if (gNum < 0 && (gNum = this.backrefRelToAbs(gNum)) <= 0) {
                    this.newValueException("invalid backref number/name");
                }
                node = new CallNode(this.bytes, this.token.getCallNameP(), this.token.getCallNameEnd(), gNum);
                ++this.env.numCall;
                break;
            }
            case ANCHOR: {
                node = new AnchorNode(this.token.getAnchorSubtype());
                break;
            }
            case OP_REPEAT: 
            case INTERVAL: {
                if (this.syntax.contextIndepRepeatOps()) {
                    if (this.syntax.contextInvalidRepeatOps()) {
                        this.newSyntaxException("target of repeat operator is not specified");
                        break;
                    }
                    node = StringNode.EMPTY;
                    break;
                }
                return this.parseExpTkByte(group2);
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
        this.fetchToken();
        return this.parseExpRepeat(node, group2);
    }

    private Node parseExpTkByte(boolean group2) {
        StringNode node = new StringNode(this.bytes, this.token.backP, this.p);
        while (true) {
            this.fetchToken();
            if (this.token.type != TokenType.STRING) break;
            if (this.token.backP == node.end) {
                node.end = this.p;
                continue;
            }
            node.cat(this.bytes, this.token.backP, this.p);
        }
        return this.parseExpRepeat(node, group2);
    }

    private Node parseExpTkRawByte(boolean group2) {
        StringNode node = new StringNode((byte)this.token.getC());
        node.setRaw();
        int len = 1;
        while (true) {
            if (len >= this.enc.minLength() && len == this.enc.length(node.bytes, node.p, node.end)) {
                this.fetchToken();
                node.clearRaw();
                return this.parseExpRepeat(node, group2);
            }
            this.fetchToken();
            if (this.token.type != TokenType.RAW_BYTE) {
                this.newValueException("too short multibyte code string");
            }
            node.cat((byte)this.token.getC());
            ++len;
        }
    }

    private Node parseExpRepeat(Node target, boolean group2) {
        while (this.token.type == TokenType.OP_REPEAT || this.token.type == TokenType.INTERVAL) {
            if (target.isInvalidQuantifier()) {
                this.newSyntaxException("target of repeat operator is invalid");
            }
            if (!group2 && this.syntax.op2OptionECMAScript() && target.getType() == 5) {
                this.newSyntaxException("nested repeat is not allowed");
            }
            QuantifierNode qtfr = new QuantifierNode(this.token.getRepeatLower(), this.token.getRepeatUpper(), this.token.type == TokenType.INTERVAL);
            qtfr.greedy = this.token.getRepeatGreedy();
            int ret = qtfr.setQuantifier(target, group2, this.env, this.bytes, this.getBegin(), this.getEnd());
            StateNode qn = qtfr;
            if (this.token.getRepeatPossessive()) {
                EncloseNode en = new EncloseNode(4);
                en.setTarget(qn);
                qn = en;
            }
            if (ret == 0 || this.syntax.op2OptionECMAScript() && ret == 1) {
                target = qn;
            } else if (ret == 2) {
                target = ConsAltNode.newListNode(target, null);
                ConsAltNode tmp = ((ConsAltNode)target).setCdr(ConsAltNode.newListNode(qn, null));
                this.fetchToken();
                return this.parseExpRepeatForCar(target, tmp, group2);
            }
            this.fetchToken();
        }
        return target;
    }

    private Node parseExpRepeatForCar(Node top, ConsAltNode target, boolean group2) {
        while (this.token.type == TokenType.OP_REPEAT || this.token.type == TokenType.INTERVAL) {
            if (target.car.isInvalidQuantifier()) {
                this.newSyntaxException("target of repeat operator is invalid");
            }
            QuantifierNode qtfr = new QuantifierNode(this.token.getRepeatLower(), this.token.getRepeatUpper(), this.token.type == TokenType.INTERVAL);
            qtfr.greedy = this.token.getRepeatGreedy();
            int ret = qtfr.setQuantifier(target.car, group2, this.env, this.bytes, this.getBegin(), this.getEnd());
            StateNode qn = qtfr;
            if (this.token.getRepeatPossessive()) {
                EncloseNode en = new EncloseNode(4);
                en.setTarget(qn);
                qn = en;
            }
            if (ret == 0) {
                target.setCar(qn);
            } else if (ret == 2) assert (false);
            this.fetchToken();
        }
        return top;
    }

    private Node parseBranch(TokenType term) {
        ConsAltNode top;
        Node node = this.parseExp(term);
        if (this.token.type == TokenType.EOT || this.token.type == term || this.token.type == TokenType.ALT) {
            return node;
        }
        ConsAltNode t = top = ConsAltNode.newListNode(node, null);
        while (this.token.type != TokenType.EOT && this.token.type != term && this.token.type != TokenType.ALT) {
            node = this.parseExp(term);
            if (node.getType() == 8) {
                t.setCdr((ConsAltNode)node);
                while (((ConsAltNode)node).cdr != null) {
                    node = ((ConsAltNode)node).cdr;
                }
                t = (ConsAltNode)node;
                continue;
            }
            t.setCdr(ConsAltNode.newListNode(node, null));
            t = t.cdr;
        }
        return top;
    }

    private Node parseSubExp(TokenType term) {
        Node node = this.parseBranch(term);
        if (this.token.type == term) {
            return node;
        }
        if (this.token.type == TokenType.ALT) {
            ConsAltNode top;
            ConsAltNode t = top = ConsAltNode.newAltNode(node, null);
            while (this.token.type == TokenType.ALT) {
                this.fetchToken();
                node = this.parseBranch(term);
                t.setCdr(ConsAltNode.newAltNode(node, null));
                t = t.cdr;
            }
            if (this.token.type != term) {
                this.parseSubExpError(term);
            }
            return top;
        }
        this.parseSubExpError(term);
        return null;
    }

    private void parseSubExpError(TokenType term) {
        if (term == TokenType.SUBEXP_CLOSE) {
            this.newSyntaxException("end pattern with unmatched parenthesis");
        } else {
            this.newInternalException("internal parser error (bug)");
        }
    }

    private Node parseRegexp() {
        this.fetchToken();
        return this.parseSubExp(TokenType.EOT);
    }
}

