/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF32BEEncoding;
import org.jcodings.specific.UTF32LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyConverter;
import org.jruby.RubyEncoding;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyMethod;
import org.jruby.RubyNumeric;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.encoding.RubyCoderResult;
import org.jruby.util.encoding.Transcoder;
import org.jruby.util.io.IOEncodable;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;

public class EncodingUtils {
    public static final int ECONV_ERROR_HANDLER_MASK = 255;
    public static final int ECONV_INVALID_MASK = 15;
    public static final int ECONV_INVALID_REPLACE = 2;
    public static final int ECONV_UNDEF_MASK = 240;
    public static final int ECONV_UNDEF_REPLACE = 32;
    public static final int ECONV_UNDEF_HEX_CHARREF = 48;
    public static final int ECONV_DECORATOR_MASK = 65280;
    public static final int ECONV_NEWLINE_DECORATOR_MASK = 16128;
    public static final int ECONV_NEWLINE_DECORATOR_READ_MASK = 3840;
    public static final int ECONV_NEWLINE_DECORATOR_WRITE_MASK = 12288;
    public static final int ECONV_UNIVERSAL_NEWLINE_DECORATOR = 256;
    public static final int ECONV_CRLF_NEWLINE_DECORATOR = 4096;
    public static final int ECONV_CR_NEWLINE_DECORATOR = 8192;
    public static final int ECONV_XML_TEXT_DECORATOR = 16384;
    public static final int ECONV_XML_ATTR_CONTENT_DECORATOR = 32768;
    public static final int ECONV_STATEFUL_DECORATOR_MASK = 0xF00000;
    public static final int ECONV_XML_ATTR_QUOTE_DECORATOR = 0x100000;
    public static final int ECONV_PARTIAL_INPUT = 65536;
    public static final int ECONV_AFTER_OUTPUT = 131072;
    public static final int ECONV_DEFAULT_NEWLINE_DECORATOR = Platform.IS_WINDOWS ? 4096 : 0;
    public static final int DEFAULT_TEXTMODE = Platform.IS_WINDOWS ? 4096 : 0;
    public static final int TEXTMODE_NEWLINE_DECORATOR_ON_WRITE = Platform.IS_WINDOWS ? 4096 : -1;
    private static final byte[] NULL_BYTE_ARRAY = new byte[0];
    public static final int PERM = 0;
    public static final int VMODE = 1;

    public static String printECFlags(int flags) {
        StringBuilder builder = new StringBuilder();
        if ((flags & 0xFF) != 0) {
            builder.append("ERROR_HANDLING ");
        }
        if ((flags & 0xF) != 0) {
            builder.append("INVALID_HANDLING ");
        }
        if ((flags & 0xFF00) != 0) {
            builder.append("DECORATOR_HANDLING ");
            if ((flags & 0x100) != 0) {
                builder.append("UNIVERSAL NEWLINE  ");
            }
            if ((flags & 0x1000) != 0) {
                builder.append("CRLF NEWLINE ");
            }
            if ((flags & 0x2000) != 0) {
                builder.append("CR NEWLINE ");
            }
            if ((flags & 0x4000) != 0) {
                builder.append("XMLTEXT ");
            }
            if ((flags & 0x8000) != 0) {
                builder.append("XMLATTRCONTENT ");
            }
        }
        if ((flags & 0xF00000) != 0) {
            builder.append("ERROR_HANDLING ");
        }
        if ((flags & 0x10000) != 0) {
            builder.append("PARTIAL INPUT ");
        }
        if ((flags & 0x20000) != 0) {
            builder.append("AFTER OUTPUT ");
        }
        return builder.toString();
    }

    public static Encoding rbToEncoding(ThreadContext context, IRubyObject enc) {
        if (enc instanceof RubyEncoding) {
            return ((RubyEncoding)enc).getEncoding();
        }
        return EncodingUtils.toEncoding(context, enc);
    }

    public static Encoding toEncoding(ThreadContext context, IRubyObject enc) {
        RubyString encStr = enc.convertToString();
        if (!encStr.getEncoding().isAsciiCompatible()) {
            throw context.runtime.newArgumentError("invalid name encoding (non ASCII)");
        }
        Encoding idx = context.runtime.getEncodingService().getEncodingFromObject(enc);
        return idx;
    }

    public static IRubyObject[] openArgsToArgs(Ruby runtime, IRubyObject firstElement, RubyHash options2) {
        IRubyObject value2 = EncodingUtils.hashARef(runtime, options2, "open_args");
        if (value2.isNil()) {
            return new IRubyObject[]{firstElement, options2};
        }
        RubyArray array = value2.convertToArray();
        Object[] openArgs = new IRubyObject[array.size()];
        value2.convertToArray().toArray(openArgs);
        IRubyObject[] args2 = new IRubyObject[openArgs.length + 1];
        args2[0] = firstElement;
        System.arraycopy(openArgs, 0, args2, 1, openArgs.length);
        return args2;
    }

    public static void extractBinmode(Ruby runtime, IRubyObject optionsArg, int[] fmode_p) {
        int fmodeMask = 0;
        IRubyObject v = EncodingUtils.hashARef(runtime, optionsArg, "textmode");
        if (!v.isNil() && v.isTrue()) {
            fmodeMask |= 0x1000;
        }
        if (!(v = EncodingUtils.hashARef(runtime, optionsArg, "binmode")).isNil() && v.isTrue()) {
            fmodeMask |= 4;
        }
        if ((fmodeMask & 4) != 0 && (fmodeMask & 0x1000) != 0) {
            throw runtime.newArgumentError("both textmode and binmode specified");
        }
        fmode_p[0] = fmode_p[0] | fmodeMask;
    }

    private static IRubyObject hashARef(Ruby runtime, IRubyObject hash2, String symbol) {
        if (hash2 == null || !(hash2 instanceof RubyHash)) {
            return runtime.getNil();
        }
        IRubyObject value2 = ((RubyHash)hash2).fastARef(runtime.newSymbol(symbol));
        return value2 == null ? runtime.getNil() : value2;
    }

    public static Encoding ascii8bitEncoding(Ruby runtime) {
        return runtime.getEncodingService().getAscii8bitEncoding();
    }

    public static final int MODE_BTMODE(int fmode, int a, int b2, int c) {
        return (fmode & 4) != 0 ? b2 : ((fmode & 0x1000) != 0 ? c : a);
    }

    public static int SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(Encoding enc2, int ecflags) {
        if (enc2 != null && (ecflags & ECONV_DEFAULT_NEWLINE_DECORATOR) != 0) {
            return ecflags | 0x100;
        }
        return ecflags;
    }

    public static void extractModeEncoding(ThreadContext context, IOEncodable ioEncodable, IRubyObject[] vmodeAndVperm_p, IRubyObject options2, int[] oflags_p, int[] fmode_p) {
        int ecflags;
        IRubyObject[] ecopts_p;
        block20: {
            IRubyObject v;
            ecopts_p = new IRubyObject[]{context.nil};
            boolean hasEnc = false;
            boolean hasVmode = false;
            IRubyObject vmode = vmodeAndVperm_p[1];
            EncodingUtils.ioExtIntToEncs(context, ioEncodable, null, null, 0);
            while (true) {
                if (vmodeAndVperm_p[1] == null || vmodeAndVperm_p[1].isNil()) {
                    fmode_p[0] = 1;
                    oflags_p[0] = ModeFlags.RDONLY;
                } else {
                    IRubyObject intmode = TypeConverter.checkIntegerType(context.runtime, vmodeAndVperm_p[1], "to_int");
                    if (!intmode.isNil()) {
                        vmodeAndVperm_p[1] = intmode;
                        oflags_p[0] = RubyNumeric.num2int(intmode);
                        fmode_p[0] = ModeFlags.getOpenFileFlagsFor(oflags_p[0]);
                    } else {
                        String p2 = vmodeAndVperm_p[1].convertToString().asJavaString();
                        int colonSplit = p2.indexOf(":");
                        String mode2 = colonSplit == -1 ? p2 : p2.substring(0, colonSplit);
                        try {
                            fmode_p[0] = OpenFile.getFModeFromString(mode2);
                            oflags_p[0] = OpenFile.getModeFlagsAsIntFrom(fmode_p[0]);
                        }
                        catch (InvalidValueException e) {
                            throw context.runtime.newArgumentError("illegal access mode " + vmodeAndVperm_p[1]);
                        }
                        if (colonSplit != -1) {
                            hasEnc = true;
                            EncodingUtils.parseModeEncoding(context, ioEncodable, p2.substring(colonSplit + 1), fmode_p);
                        } else {
                            Encoding e = (fmode_p[0] & 4) != 0 ? EncodingUtils.ascii8bitEncoding(context.runtime) : null;
                            EncodingUtils.ioExtIntToEncs(context, ioEncodable, e, null, fmode_p[0]);
                        }
                    }
                }
                if (options2 == null || options2.isNil()) {
                    int n = ecflags = (fmode_p[0] & 1) != 0 ? EncodingUtils.MODE_BTMODE(fmode_p[0], ECONV_DEFAULT_NEWLINE_DECORATOR, 0, 256) : 0;
                    if (TEXTMODE_NEWLINE_DECORATOR_ON_WRITE != -1) {
                        ecflags |= (fmode_p[0] & 2) != 0 ? EncodingUtils.MODE_BTMODE(fmode_p[0], TEXTMODE_NEWLINE_DECORATOR_ON_WRITE, 0, TEXTMODE_NEWLINE_DECORATOR_ON_WRITE) : 0;
                    }
                    ecflags = EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(ioEncodable.getEnc2(), ecflags);
                    ecopts_p[0] = context.nil;
                    break block20;
                }
                EncodingUtils.extractBinmode(context.runtime, options2, fmode_p);
                if ((fmode_p[0] & 4) != 0) {
                    oflags_p[0] = oflags_p[0] | ModeFlags.BINARY;
                    if (!hasEnc) {
                        EncodingUtils.ioExtIntToEncs(context, ioEncodable, EncodingUtils.ascii8bitEncoding(context.runtime), null, fmode_p[0]);
                    }
                } else if (DEFAULT_TEXTMODE != 0 && (vmode == null || vmode.isNil())) {
                    fmode_p[0] = fmode_p[0] | DEFAULT_TEXTMODE;
                }
                if (hasVmode || (v = EncodingUtils.hashARef(context.runtime, options2, "mode")).isNil()) break;
                if (vmodeAndVperm_p[1] != null && !vmodeAndVperm_p[1].isNil()) {
                    throw context.runtime.newArgumentError("mode specified twice");
                }
                hasVmode = true;
                vmodeAndVperm_p[1] = v;
            }
            v = EncodingUtils.hashARef(context.runtime, options2, "perm");
            if (!v.isNil() && vmodeAndVperm_p[0] != null) {
                if (!vmodeAndVperm_p[0].isNil()) {
                    throw context.runtime.newArgumentError("perm specified twice");
                }
                vmodeAndVperm_p[0] = v;
            }
            int n = ecflags = (fmode_p[0] & 1) != 0 ? EncodingUtils.MODE_BTMODE(fmode_p[0], ECONV_DEFAULT_NEWLINE_DECORATOR, 0, 256) : 0;
            if (TEXTMODE_NEWLINE_DECORATOR_ON_WRITE != -1) {
                ecflags |= (fmode_p[0] & 2) != 0 ? EncodingUtils.MODE_BTMODE(fmode_p[0], TEXTMODE_NEWLINE_DECORATOR_ON_WRITE, 0, TEXTMODE_NEWLINE_DECORATOR_ON_WRITE) : 0;
            }
            if (EncodingUtils.ioExtractEncodingOption(context, ioEncodable, options2, fmode_p) && hasEnc) {
                throw context.runtime.newArgumentError("encoding specified twice");
            }
            ecflags = EncodingUtils.SET_UNIVERSAL_NEWLINE_DECORATOR_IF_ENC2(ioEncodable.getEnc2(), ecflags);
            ecflags = EncodingUtils.econvPrepareOptions(context, options2, ecopts_p, ecflags);
        }
        EncodingUtils.validateEncodingBinmode(context, fmode_p, ecflags, ioEncodable);
        ioEncodable.setEcflags(ecflags);
        ioEncodable.setEcopts(ecopts_p[0]);
    }

    public static boolean ioExtractEncodingOption(ThreadContext context, IOEncodable ioEncodable, IRubyObject options2, int[] fmode_p) {
        IRubyObject tmp;
        Ruby runtime = context.runtime;
        IRubyObject encoding2 = context.nil;
        IRubyObject extenc = null;
        IRubyObject intenc = null;
        boolean extracted = false;
        Encoding extencoding = null;
        Object intencoding = null;
        if (options2 != null || !options2.isNil()) {
            IRubyObject internalOpt;
            IRubyObject externalOpt;
            RubyHash opts = (RubyHash)options2;
            IRubyObject encodingOpt = opts.op_aref(context, runtime.newSymbol("encoding"));
            if (!encodingOpt.isNil()) {
                encoding2 = encodingOpt;
            }
            if (!(externalOpt = opts.op_aref(context, runtime.newSymbol("external_encoding"))).isNil()) {
                extenc = externalOpt;
            }
            if (!(internalOpt = opts.op_aref(context, runtime.newSymbol("internal_encoding"))).isNil()) {
                intenc = internalOpt;
            }
        }
        if (!(extenc == null && intenc == null || encoding2.isNil())) {
            if (runtime.isVerbose()) {
                runtime.getWarnings().warn("Ignoring encoding parameter '" + encoding2 + "': " + (extenc == null ? "internal" : "external") + "_encoding is used");
            }
            encoding2 = context.nil;
        }
        if (extenc != null && !extenc.isNil()) {
            extencoding = EncodingUtils.rbToEncoding(context, extenc);
        }
        if (intenc != null) {
            String p2;
            intencoding = intenc.isNil() ? null : (!(tmp = intenc.checkStringType19()).isNil() ? ((p2 = tmp.toString()).equals("-") ? null : EncodingUtils.rbToEncoding(context, intenc)) : EncodingUtils.rbToEncoding(context, intenc));
            if (extencoding == intencoding) {
                intencoding = null;
            }
        }
        if (!encoding2.isNil()) {
            extracted = true;
            tmp = encoding2.checkStringType19();
            if (!tmp.isNil()) {
                EncodingUtils.parseModeEncoding(context, ioEncodable, tmp.asJavaString(), fmode_p);
            } else {
                EncodingUtils.ioExtIntToEncs(context, ioEncodable, EncodingUtils.rbToEncoding(context, encoding2), null, 0);
            }
        } else if (extenc != null || intenc != null) {
            extracted = true;
            EncodingUtils.ioExtIntToEncs(context, ioEncodable, extencoding, (Encoding)intencoding, 0);
        }
        return extracted;
    }

    public static void ioExtIntToEncs(ThreadContext context, IOEncodable encodable, Encoding external, Encoding internal, int fmode) {
        boolean defaultExternal = false;
        if (external == null) {
            external = context.runtime.getDefaultExternalEncoding();
            defaultExternal = true;
        }
        if (external == EncodingUtils.ascii8bitEncoding(context.runtime)) {
            internal = null;
        } else if (internal == null) {
            internal = context.runtime.getDefaultInternalEncoding();
        }
        if (internal == null || (fmode & 0x100000) == 0 && internal == external) {
            encodable.setEnc((Encoding)(defaultExternal && internal != external ? null : external));
            encodable.setEnc2(null);
        } else {
            encodable.setEnc(internal);
            encodable.setEnc2(external);
        }
    }

    public static void parseModeEncoding(ThreadContext context, IOEncodable ioEncodable, String option, int[] fmode_p) {
        Encoding idx;
        String[] encs;
        Ruby runtime = context.runtime;
        EncodingService service = runtime.getEncodingService();
        Encoding idx2 = null;
        if (fmode_p == null) {
            fmode_p = new int[]{0};
        }
        if ((encs = option.split(":", 2)).length == 2) {
            String estr = encs[0];
            if (estr.toLowerCase().startsWith("bom|utf-")) {
                fmode_p[0] = fmode_p[0] | 0x100000;
                ioEncodable.setBOM(true);
                estr = estr.substring(4);
            }
            idx = context.runtime.getEncodingService().getEncodingFromString(estr);
        } else {
            String estr = option;
            if (estr.toLowerCase().startsWith("bom|utf-")) {
                fmode_p[0] = fmode_p[0] | 0x100000;
                ioEncodable.setBOM(true);
                estr = estr.substring(4);
            }
            idx = context.runtime.getEncodingService().getEncodingFromString(estr);
        }
        Encoding extEnc = idx;
        Encoding intEnc = null;
        if (encs.length == 2) {
            if (encs[1].equals("-")) {
                intEnc = null;
            } else {
                idx2 = context.runtime.getEncodingService().getEncodingFromString(encs[1]);
                if (idx2 == idx) {
                    context.runtime.getWarnings().warn("ignoring internal encoding " + idx2 + ": it is identical to external encoding " + idx);
                    intEnc = null;
                } else {
                    intEnc = idx2;
                }
            }
        }
        EncodingUtils.ioExtIntToEncs(context, ioEncodable, extEnc, intEnc, fmode_p[0]);
    }

    public static int econvPrepareOpts(ThreadContext context, IRubyObject opthash, IRubyObject[] opts) {
        return EncodingUtils.econvPrepareOptions(context, opthash, opts, 0);
    }

    public static int econvPrepareOptions(ThreadContext context, IRubyObject opthash, IRubyObject[] opts, int ecflags) {
        IRubyObject newhash = context.nil;
        if (opthash.isNil()) {
            opts[0] = context.nil;
            return ecflags;
        }
        ecflags = EncodingUtils.econvOpts(context, opthash, ecflags);
        IRubyObject v = ((RubyHash)opthash).op_aref(context, context.runtime.newSymbol("replace"));
        if (!v.isNil()) {
            RubyString v_str = v.convertToString();
            if (v_str.scanForCodeRange() == 96) {
                throw context.runtime.newArgumentError("replacement string is broken: " + v_str);
            }
            v = v_str.freeze(context);
            newhash = RubyHash.newHash(context.runtime);
            ((RubyHash)newhash).op_aset(context, context.runtime.newSymbol("replace"), v);
        }
        if (!(v = ((RubyHash)opthash).op_aref(context, context.runtime.newSymbol("fallback"))).isNil()) {
            boolean condition;
            IRubyObject h = TypeConverter.checkHashType(context.runtime, v);
            if (h.isNil()) {
                condition = h instanceof RubyProc || h instanceof RubyMethod || h.respondsTo("[]");
            } else {
                v = h;
                condition = true;
            }
            if (condition) {
                if (newhash.isNil()) {
                    newhash = RubyHash.newHash(context.runtime);
                }
                ((RubyHash)newhash).op_aset(context, context.runtime.newSymbol("fallback"), v);
            }
        }
        if (!newhash.isNil()) {
            newhash.setFrozen(true);
        }
        opts[0] = newhash;
        return ecflags;
    }

    public static int econvOpts(ThreadContext context, IRubyObject opt, int ecflags) {
        Ruby runtime = context.runtime;
        IRubyObject v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("invalid"));
        if (!v.isNil()) {
            if (v == runtime.newSymbol("replace")) {
                ecflags |= 2;
            } else {
                throw runtime.newArgumentError("unknown value for invalid character option");
            }
        }
        if (!(v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("undef"))).isNil()) {
            if (v == runtime.newSymbol("replace")) {
                ecflags |= 0x20;
            } else {
                throw runtime.newArgumentError("unknown value for undefined character option");
            }
        }
        if (!(v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("replace"))).isNil() && (ecflags & 2) != 0) {
            ecflags |= 0x20;
        }
        if (!(v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("xml"))).isNil()) {
            if (v == runtime.newSymbol("text")) {
                ecflags |= 0x4030;
            } else if (v == runtime.newSymbol("attr")) {
                ecflags |= 0x108030;
            } else {
                throw runtime.newArgumentError("unexpected value for xml option: " + v);
            }
        }
        if (!(v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("newline"))).isNil()) {
            ecflags &= 0xFFFFC0FF;
            if (v == runtime.newSymbol("universal")) {
                ecflags |= 0x100;
            } else if (v == runtime.newSymbol("crlf")) {
                ecflags |= 0x1000;
            } else if (v == runtime.newSymbol("cr")) {
                ecflags |= 0x2000;
            } else if (v != runtime.newSymbol("lf")) {
                throw runtime.newArgumentError("unexpected value for newline option");
            }
        }
        int setflags = 0;
        boolean newlineflag = false;
        v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("universal_newline"));
        if (v.isTrue()) {
            setflags |= 0x100;
        }
        newlineflag |= !v.isNil();
        v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("crlf_newline"));
        if (v.isTrue()) {
            setflags |= 0x1000;
        }
        newlineflag |= !v.isNil();
        v = ((RubyHash)opt).op_aref(context, runtime.newSymbol("cr_newline"));
        if (v.isTrue()) {
            setflags |= 0x2000;
        }
        if (newlineflag |= !v.isNil()) {
            ecflags &= 0xFFFFC0FF;
            ecflags |= setflags;
        }
        return ecflags;
    }

    public static Transcoder econvOpenOpts(ThreadContext context, byte[] sourceEncoding, byte[] destinationEncoding, int ecflags, IRubyObject opthash) {
        IRubyObject replacement2;
        Ruby runtime = context.runtime;
        if (opthash == null || opthash.isNil()) {
            replacement2 = context.nil;
        } else {
            if (!(opthash instanceof RubyHash) || !opthash.isFrozen()) {
                throw runtime.newRuntimeError("bug: EncodingUtils.econvOpenOpts called with invalid opthash");
            }
            replacement2 = ((RubyHash)opthash).op_aref(context, runtime.newSymbol("replace"));
        }
        return Transcoder.open(context, sourceEncoding, destinationEncoding, ecflags, replacement2);
    }

    public static RaiseException econvOpenExc(ThreadContext context, byte[] sourceEncoding, byte[] destinationEncoding, int ecflags) {
        String message2 = EncodingUtils.econvDescription(context, sourceEncoding, destinationEncoding, ecflags, "code converter not found (") + ")";
        return context.runtime.newConverterNotFoundError(message2);
    }

    public static String econvDescription(ThreadContext context, byte[] sourceEncoding, byte[] destinationEncoding, int ecflags, String message2) {
        return message2 + new String(sourceEncoding) + " to " + new String(destinationEncoding);
    }

    public static Encoding econvAsciicompatEncoding(Encoding enc) {
        return RubyConverter.NONASCII_TO_ASCII.get(enc);
    }

    public static boolean encAsciicompat(Encoding enc) {
        return EncodingUtils.encMbminlen(enc) == 1 && !EncodingUtils.encDummy(enc);
    }

    public static int encAscget(byte[] bytes2, int offset2, int end2, int[] chlen, Encoding enc) {
        if (enc.isAsciiCompatible()) {
            byte c = bytes2[offset2];
            if (!Encoding.isAscii(c)) {
                return -1;
            }
            if (chlen != null) {
                chlen[0] = 1;
            }
            return c;
        }
        int l = StringSupport.preciseLength(enc, bytes2, offset2, end2);
        if (StringSupport.MBCLEN_CHARFOUND_LEN(l) == 0) {
            return -1;
        }
        int c = enc.mbcToCode(bytes2, offset2, end2);
        if (!Encoding.isAscii(c)) {
            return -1;
        }
        if (chlen != null) {
            chlen[0] = 1;
        }
        return c;
    }

    public static int encMbminlen(Encoding encoding2) {
        return encoding2.minLength();
    }

    public static boolean encDummy(Encoding enc) {
        return enc.isDummy();
    }

    public static Encoding encGet(ThreadContext context, IRubyObject obj) {
        if (obj instanceof EncodingCapable) {
            return ((EncodingCapable)((Object)obj)).getEncoding();
        }
        return context.runtime.getDefaultInternalEncoding();
    }

    public static boolean encodingEqual(byte[] enc1, byte[] enc2) {
        return new String(enc1).equalsIgnoreCase(new String(enc2));
    }

    public static Encoding encArg(ThreadContext context, IRubyObject encval, byte[][] name_p, Encoding[] enc_p) {
        enc_p[0] = EncodingUtils.toEncodingIndex(context, encval);
        name_p[0] = enc_p[0] == null ? ((RubyString)encval.anyToString()).getBytes() : enc_p[0].getName();
        return enc_p[0];
    }

    public static Encoding toEncodingIndex(ThreadContext context, IRubyObject enc) {
        if (enc instanceof RubyEncoding) {
            return ((RubyEncoding)enc).getEncoding();
        }
        if ((enc = enc.checkStringType19()).isNil()) {
            return null;
        }
        if (!((RubyString)enc).getEncoding().isAsciiCompatible()) {
            return null;
        }
        return context.runtime.getEncodingService().getEncodingFromObjectNoError(enc);
    }

    public static IRubyObject encodedDup(ThreadContext context, IRubyObject newstr, IRubyObject str, Encoding encindex) {
        if (encindex == null) {
            return str.dup();
        }
        if (newstr == str) {
            newstr = str.dup();
        } else {
            ((RubyBasicObject)newstr).setMetaClass(str.getMetaClass());
        }
        ((RubyString)newstr).modify19();
        return EncodingUtils.strEncodeAssociate(context, newstr, encindex);
    }

    public static IRubyObject strEncodeAssociate(ThreadContext context, IRubyObject str, Encoding encidx) {
        EncodingUtils.encAssociateIndex(str, encidx);
        if (EncodingUtils.encAsciicompat(encidx)) {
            ((RubyString)str).scanForCodeRange();
        } else {
            ((RubyString)str).setCodeRange(64);
        }
        return str;
    }

    public static IRubyObject encAssociateIndex(IRubyObject obj, Encoding encidx) {
        ((RubyBasicObject)obj).checkFrozen();
        if (((EncodingCapable)((Object)obj)).getEncoding() == encidx) {
            return obj;
        }
        if (!((RubyString)obj).isCodeRangeAsciiOnly() || EncodingUtils.encAsciicompat(encidx)) {
            ((RubyString)obj).clearCodeRange();
        }
        ((EncodingCapable)((Object)obj)).setEncoding(encidx);
        return obj;
    }

    public static IRubyObject strEncode(ThreadContext context, IRubyObject str, IRubyObject ... args2) {
        IRubyObject[] newstr_p = new IRubyObject[]{str};
        Encoding dencindex = EncodingUtils.strTranscode(context, args2, newstr_p);
        return EncodingUtils.encodedDup(context, newstr_p[0], str, dencindex);
    }

    public static IRubyObject rbStrEncode(ThreadContext context, IRubyObject str, IRubyObject to, int ecflags, IRubyObject ecopt) {
        IRubyObject[] newstr_p = new IRubyObject[]{str};
        Encoding dencindex = EncodingUtils.strTranscode0(context, 1, new IRubyObject[]{to}, newstr_p, ecflags, ecopt);
        return EncodingUtils.encodedDup(context, newstr_p[0], str, dencindex);
    }

    public static Encoding strTranscode(ThreadContext context, IRubyObject[] args2, IRubyObject[] self_p) {
        IRubyObject tmp;
        int ecflags = 0;
        int argc = args2.length;
        IRubyObject[] ecopts_p = new IRubyObject[]{context.nil};
        if (args2.length >= 1 && !(tmp = TypeConverter.checkHashType(context.runtime, args2[args2.length - 1])).isNil()) {
            --argc;
            ecflags = EncodingUtils.econvPrepareOpts(context, tmp, ecopts_p);
        }
        return EncodingUtils.strTranscode0(context, argc, args2, self_p, ecflags, ecopts_p[0]);
    }

    public static Encoding strTranscode0(ThreadContext context, int argc, IRubyObject[] args2, IRubyObject[] self_p, int ecflags, IRubyObject ecopts) {
        IRubyObject arg1;
        Ruby runtime = context.runtime;
        IRubyObject str = self_p[0];
        Encoding[] senc_p = new Encoding[]{null};
        Encoding[] denc_p = new Encoding[]{null};
        byte[][] sname_p = new byte[][]{null};
        byte[][] dname_p = new byte[][]{null};
        if (argc > 2) {
            throw context.runtime.newArgumentError(args2.length, 2);
        }
        if (argc == 0) {
            arg1 = runtime.getEncodingService().getDefaultInternal();
            if (arg1 == null || arg1.isNil()) {
                if (ecflags == 0) {
                    return null;
                }
                arg1 = EncodingUtils.objEncoding(context, str);
            }
            ecflags |= 0x22;
        } else {
            arg1 = args2[0];
        }
        IRubyObject arg2 = argc <= 1 ? context.nil : args2[1];
        Encoding dencindex = EncodingUtils.strTranscodeEncArgs(context, str, arg1, arg2, sname_p, senc_p, dname_p, denc_p);
        if ((ecflags & 0x10FF00) == 0) {
            if (senc_p[0] != null && senc_p[0] == denc_p[0]) {
                str = (ecflags & 0xF) != 0 ? str.dup() : str.dup();
                self_p[0] = str;
                return dencindex;
            }
            if (senc_p[0] != null && denc_p[0] != null && senc_p[0].isAsciiCompatible() && denc_p[0].isAsciiCompatible() && ((RubyString)str).scanForCodeRange() == 32) {
                return dencindex;
            }
            if (EncodingUtils.encodingEqual(sname_p[0], dname_p[0])) {
                return arg2.isNil() ? null : dencindex;
            }
        } else if (EncodingUtils.encodingEqual(sname_p[0], dname_p[0])) {
            sname_p[0] = NULL_BYTE_ARRAY;
            dname_p[0] = NULL_BYTE_ARRAY;
        }
        ByteList fromp = ((RubyString)str).getByteList().shallowDup();
        RubyString dest = runtime.newString();
        ByteList destp = dest.getByteList();
        EncodingUtils.transcodeLoop(context, fromp, destp, sname_p[0], dname_p[0], ecflags, ecopts);
        if (denc_p[0] == null) {
            dencindex = EncodingUtils.defineDummyEncoding(context, dname_p[0]);
        }
        self_p[0] = dest;
        return dencindex;
    }

    public static IRubyObject objEncoding(ThreadContext context, IRubyObject obj) {
        Encoding enc = EncodingUtils.encGet(context, obj);
        if (enc == null) {
            throw context.runtime.newTypeError("unknown encoding");
        }
        return context.runtime.getEncodingService().convertEncodingToRubyEncoding(enc);
    }

    public static Encoding strTranscodeEncArgs(ThreadContext context, IRubyObject str, IRubyObject arg1, IRubyObject arg2, byte[][] sname_p, Encoding[] senc_p, byte[][] dname_p, Encoding[] denc_p) {
        Encoding dencindex = EncodingUtils.encArg(context, arg1, dname_p, denc_p);
        if (arg2.isNil()) {
            senc_p[0] = EncodingUtils.encGet(context, str);
            sname_p[0] = senc_p[0].getName();
        } else {
            EncodingUtils.encArg(context, arg2, sname_p, senc_p);
        }
        return dencindex;
    }

    public static boolean encRegistered(byte[] name2) {
        return EncodingDB.getEncodings().get(name2) != null;
    }

    public static void encCheckDuplication(ThreadContext context, byte[] name2) {
        if (EncodingUtils.encRegistered(name2)) {
            throw context.runtime.newArgumentError("encoding " + new String(name2) + " is already registered");
        }
    }

    public static Encoding encReplicate(ThreadContext context, byte[] name2, Encoding encoding2) {
        EncodingUtils.encCheckDuplication(context, name2);
        EncodingDB.replicate(new String(name2), new String(encoding2.getName()));
        return EncodingDB.getEncodings().get(name2).getEncoding();
    }

    public static Encoding defineDummyEncoding(ThreadContext context, byte[] name2) {
        Encoding dummy = EncodingUtils.encReplicate(context, name2, EncodingUtils.ascii8bitEncoding(context.runtime));
        return dummy;
    }

    public static void transcodeLoop(ThreadContext context, ByteList fromp, ByteList dest, byte[] sname, byte[] dname, int ecflags, IRubyObject ecopts) {
        Transcoder ec = EncodingUtils.econvOpenOpts(context, sname, dname, ecflags, ecopts);
        if (ec == null) {
            throw EncodingUtils.econvOpenExc(context, sname, dname, ecflags);
        }
        RubyCoderResult result2 = ec.transcode(context, fromp, dest);
    }

    public static void ioSetEncodingByBOM(ThreadContext context, RubyIO io2) {
        Ruby runtime = context.runtime;
        Encoding bomEncoding = EncodingUtils.ioStripBOM(io2);
        if (bomEncoding != null) {
            RubyEncoding theBom = runtime.getEncodingService().getEncoding(bomEncoding);
            IRubyObject theInternal = io2.internal_encoding(context);
            io2.setEncoding(runtime.getCurrentContext(), theBom, theInternal, context.nil);
        }
    }

    public static Encoding ioStripBOM(RubyIO io2) {
        int b1 = io2.getcCommon();
        switch (b1) {
            case 239: {
                int b2 = io2.getcCommon();
                if (b2 == 187) {
                    int b3 = io2.getcCommon();
                    if (b3 == 191) {
                        return UTF8Encoding.INSTANCE;
                    }
                    io2.ungetcCommon(b3);
                }
                io2.ungetcCommon(b2);
                break;
            }
            case 254: {
                int b2 = io2.getcCommon();
                if (b2 == 255) {
                    return UTF16BEEncoding.INSTANCE;
                }
                io2.ungetcCommon(b2);
                break;
            }
            case 255: {
                int b2 = io2.getcCommon();
                if (b2 == 254) {
                    int b4;
                    int b3 = io2.getcCommon();
                    if (b3 == 0) {
                        b4 = io2.getcCommon();
                        if (b4 == 0) {
                            return UTF32LEEncoding.INSTANCE;
                        }
                    } else {
                        io2.ungetcCommon(b3);
                        return UTF16LEEncoding.INSTANCE;
                    }
                    io2.ungetcCommon(b4);
                    io2.ungetcCommon(b3);
                }
                io2.ungetcCommon(b2);
                break;
            }
            case 0: {
                int b2 = io2.getcCommon();
                if (b2 == 0) {
                    int b3 = io2.getcCommon();
                    if (b3 == 254) {
                        int b4 = io2.getcCommon();
                        if (b4 == 255) {
                            return UTF32BEEncoding.INSTANCE;
                        }
                        io2.ungetcCommon(b4);
                    }
                    io2.ungetcCommon(b3);
                }
                io2.ungetcCommon(b2);
            }
        }
        io2.ungetcCommon(b1);
        return null;
    }

    public static void validateEncodingBinmode(ThreadContext context, int[] fmode_p, int ecflags, IOEncodable ioEncodable) {
        Ruby runtime = context.runtime;
        int fmode = fmode_p[0];
        if ((fmode & 1) != 0 && ioEncodable.getEnc2() == null && (fmode & 4) == 0 && !(ioEncodable.getEnc() != null ? ioEncodable.getEnc() : runtime.getDefaultExternalEncoding()).isAsciiCompatible()) {
            throw runtime.newArgumentError("ASCII incompatible encoding needs binmode");
        }
        if ((fmode & 4) == 0 && (DEFAULT_TEXTMODE != 0 || (ecflags & 0xFF00) != 0)) {
            fmode_p[0] = fmode |= DEFAULT_TEXTMODE;
        } else if (DEFAULT_TEXTMODE == 0 && (ecflags & 0x3F00) == 0) {
            fmode_p[0] = fmode &= 0xFFFFEFFF;
        }
    }

    public static void rbEncSetDefaultExternal(ThreadContext context, IRubyObject encoding2) {
        if (encoding2.isNil()) {
            throw context.runtime.newArgumentError("default external can not be nil");
        }
        Encoding[] enc_p = new Encoding[]{context.runtime.getDefaultExternalEncoding()};
        EncodingUtils.encSetDefaultEncoding(context, enc_p, encoding2, "external");
        context.runtime.setDefaultExternalEncoding(enc_p[0]);
    }

    public static void rbEncSetDefaultInternal(ThreadContext context, IRubyObject encoding2) {
        Encoding[] enc_p = new Encoding[]{context.runtime.getDefaultInternalEncoding()};
        EncodingUtils.encSetDefaultEncoding(context, enc_p, encoding2, "internal");
        context.runtime.setDefaultInternalEncoding(enc_p[0]);
    }

    public static boolean encSetDefaultEncoding(ThreadContext context, Encoding[] def_p, IRubyObject encoding2, String name2) {
        boolean overridden = false;
        if (def_p != null) {
            overridden = true;
        }
        def_p[0] = encoding2.isNil() ? null : EncodingUtils.rbToEncoding(context, encoding2);
        if (name2.equals("external")) {
            // empty if block
        }
        return overridden;
    }

    public static Encoding defaultExternalEncoding(Ruby runtime) {
        if (runtime.getDefaultExternalEncoding() != null) {
            return runtime.getDefaultExternalEncoding();
        }
        return runtime.getEncodingService().getLocaleEncoding();
    }

    public static void rbStrBufCat(Ruby runtime, RubyString str, ByteList ptr) {
        if (ptr.length() == 0) {
            return;
        }
        EncodingUtils.strBufCat(runtime, str, ptr);
    }

    public static void strBufCat(Ruby runtime, RubyString str, ByteList ptr) {
        int off = -1;
        str.modify();
        if (ptr.length() == 0) {
            return;
        }
        int total2 = str.size() + ptr.length();
        str.getByteList().ensure(total2);
        str.getByteList().append(ptr);
    }

    public static void encStrBufCat(Ruby runtime, RubyString str, ByteList ptr, Encoding enc) {
        EncodingUtils.encCrStrBufCat(runtime, str, ptr, enc, 0, null);
    }

    public static void encCrStrBufCat(Ruby runtime, RubyString str, ByteList ptr, Encoding ptrEnc, int ptr_cr, int[] ptr_cr_ret) {
        int res_cr;
        Encoding resEnc;
        int str_cr;
        Encoding strEnc = str.getEncoding();
        boolean incompatible = false;
        int n = str_cr = str.size() > 0 ? str.getCodeRange() : 32;
        if (strEnc == ptrEnc) {
            if (str_cr == 0) {
                ptr_cr = 0;
            } else if (ptr_cr == 0) {
                ptr_cr = StringSupport.codeRangeScan(ptrEnc, ptr);
            }
        } else {
            if (!strEnc.isAsciiCompatible() || !ptrEnc.isAsciiCompatible()) {
                if (ptr.getRealSize() == 0) {
                    return;
                }
                if (str.size() == 0) {
                    EncodingUtils.rbStrBufCat(runtime, str, ptr);
                    str.setEncodingAndCodeRange(ptrEnc, ptr_cr);
                    return;
                }
                incompatible = true;
            }
            if (!incompatible) {
                if (ptr_cr == 0) {
                    ptr_cr = StringSupport.codeRangeScan(ptrEnc, ptr);
                }
                if (str_cr == 0 && (strEnc == ASCIIEncoding.INSTANCE || ptr_cr != 32)) {
                    str_cr = str.scanForCodeRange();
                }
            }
        }
        if (ptr_cr_ret != null) {
            ptr_cr_ret[0] = ptr_cr;
        }
        if (incompatible || strEnc != ptrEnc && str_cr != 32 && ptr_cr != 32) {
            throw runtime.newEncodingCompatibilityError("incompatible encodings: " + strEnc + " and " + ptrEnc);
        }
        if (str_cr == 0) {
            resEnc = strEnc;
            res_cr = 0;
        } else if (str_cr == 32) {
            if (ptr_cr == 32) {
                resEnc = strEnc;
                res_cr = 32;
            } else {
                resEnc = ptrEnc;
                res_cr = ptr_cr;
            }
        } else if (str_cr == 64) {
            resEnc = strEnc;
            res_cr = ptr_cr == 32 || ptr_cr == 64 ? str_cr : ptr_cr;
        } else {
            resEnc = strEnc;
            res_cr = str_cr;
            if (0 < ptr.getRealSize()) {
                res_cr = 0;
            }
        }
        EncodingUtils.strBufCat(runtime, str, ptr);
        str.setEncodingAndCodeRange(resEnc, res_cr);
    }
}

