/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestRegionLoad {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionLoad.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionLoad.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static Admin admin;
    private static final TableName TABLE_1;
    private static final TableName TABLE_2;
    private static final TableName TABLE_3;
    private static final TableName[] tables;
    private static final int MSG_INTERVAL = 500;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 500);
        UTIL.startMiniCluster(4);
        admin = UTIL.getAdmin();
        admin.setBalancerRunning(false, true);
        TestRegionLoad.createTables();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private static void createTables() throws IOException, InterruptedException {
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"f")};
        for (TableName tableName : tables) {
            Table table = UTIL.createTable(tableName, (byte[][])FAMILIES, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
            UTIL.waitTableAvailable(tableName);
            UTIL.loadTable(table, FAMILIES[0]);
        }
    }

    @Test
    public void testRegionLoad() throws Exception {
        for (ServerName serverName : admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
            List regions = admin.getOnlineRegions(serverName);
            LOG.info("serverName=" + serverName + ", regions=" + regions.stream().map(r -> r.getRegionNameAsString()).collect(Collectors.toList()));
            Collection regionLoads = admin.getRegionMetrics(serverName).stream().map(r -> new RegionLoad(r)).collect(Collectors.toList());
            LOG.info("serverName=" + serverName + ", regionLoads=" + regionLoads.stream().map(r -> Bytes.toString((byte[])r.getRegionName())).collect(Collectors.toList()));
            this.checkRegionsAndRegionLoads(regions, regionLoads);
        }
        for (TableName table : new TableName[]{TABLE_1, TABLE_2, TABLE_3}) {
            List tableRegions = admin.getTableRegions(table);
            ArrayList regionLoads = Lists.newArrayList();
            for (ServerName serverName : admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
                regionLoads.addAll(admin.getRegionMetrics(serverName, table).stream().map(r -> new RegionLoad(r)).collect(Collectors.toList()));
            }
            this.checkRegionsAndRegionLoads(tableRegions, regionLoads);
        }
        TimeUnit.MILLISECONDS.sleep(1500L);
        ClusterStatus clusterStatus = new ClusterStatus(admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)));
        for (ServerName serverName : clusterStatus.getServers()) {
            ServerLoad serverLoad = clusterStatus.getLoad(serverName);
            Map regionLoads = admin.getRegionMetrics(serverName).stream().collect(Collectors.toMap(e -> e.getRegionName(), e -> new RegionLoad(e), (v1, v2) -> {
                throw new RuntimeException("impossible!!");
            }, () -> new TreeMap(Bytes.BYTES_COMPARATOR)));
            LOG.debug("serverName=" + serverName + ", getRegionLoads=" + serverLoad.getRegionsLoad().keySet().stream().map(r -> Bytes.toString((byte[])r)).collect(Collectors.toList()));
            LOG.debug("serverName=" + serverName + ", regionLoads=" + regionLoads.keySet().stream().map(r -> Bytes.toString((byte[])r)).collect(Collectors.toList()));
            this.compareRegionLoads(serverLoad.getRegionsLoad(), regionLoads);
        }
    }

    private void compareRegionLoads(Map<byte[], RegionLoad> regionLoadCluster, Map<byte[], RegionLoad> regionLoads) {
        Assert.assertEquals((String)"No of regionLoads from clusterStatus and regionloads from RS doesn't match", (long)regionLoadCluster.size(), (long)regionLoads.size());
        for (byte[] regionName : regionLoadCluster.keySet()) {
            regionLoads.remove(regionName);
        }
        Assert.assertEquals((String)"regionLoads from SN should be empty", (long)0L, (long)regionLoads.size());
    }

    private void checkRegionsAndRegionLoads(Collection<HRegionInfo> regions, Collection<RegionLoad> regionLoads) {
        for (RegionLoad load : regionLoads) {
            Assert.assertNotNull((Object)load.regionLoadPB);
        }
        Assert.assertEquals((String)"No of regions and regionloads doesn't match", (long)regions.size(), (long)regionLoads.size());
        TreeMap regionLoadMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        for (RegionLoad regionLoad : regionLoads) {
            regionLoadMap.put(regionLoad.getName(), regionLoad);
        }
        for (HRegionInfo info : regions) {
            Assert.assertTrue((String)("Region not in regionLoadMap region:" + info.getRegionNameAsString() + " regionMap: " + regionLoadMap), (boolean)regionLoadMap.containsKey(info.getRegionName()));
        }
    }

    static {
        TABLE_1 = TableName.valueOf((String)"table_1");
        TABLE_2 = TableName.valueOf((String)"table_2");
        TABLE_3 = TableName.valueOf((String)"table_3");
        tables = new TableName[]{TABLE_1, TABLE_2, TABLE_3};
    }
}

