/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractTestRegionLocator;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableRegionLocator
extends AbstractTestRegionLocator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableRegionLocator.class);
    private static AsyncConnection CONN;

    @BeforeClass
    public static void setUp() throws Exception {
        TestAsyncTableRegionLocator.startClusterAndCreateTable();
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    @Override
    protected byte[][] getStartKeys(TableName tableName) throws IOException {
        return (byte[][])((List)FutureUtils.get((Future)CONN.getRegionLocator(tableName).getStartKeys())).toArray((T[])new byte[0][]);
    }

    @Override
    protected byte[][] getEndKeys(TableName tableName) throws IOException {
        return (byte[][])((List)FutureUtils.get((Future)CONN.getRegionLocator(tableName).getEndKeys())).toArray((T[])new byte[0][]);
    }

    @Override
    protected Pair<byte[][], byte[][]> getStartEndKeys(TableName tableName) throws IOException {
        List startEndKeys = (List)FutureUtils.get((Future)CONN.getRegionLocator(tableName).getStartEndKeys());
        byte[][] startKeys = new byte[startEndKeys.size()][];
        byte[][] endKeys = new byte[startEndKeys.size()][];
        int n = startEndKeys.size();
        for (int i = 0; i < n; ++i) {
            Pair pair = (Pair)startEndKeys.get(i);
            startKeys[i] = (byte[])pair.getFirst();
            endKeys[i] = (byte[])pair.getSecond();
        }
        return Pair.newPair((Object)startKeys, (Object)endKeys);
    }

    @Override
    protected HRegionLocation getRegionLocation(TableName tableName, byte[] row, int replicaId) throws IOException {
        return (HRegionLocation)FutureUtils.get((Future)CONN.getRegionLocator(tableName).getRegionLocation(row, replicaId));
    }

    @Override
    protected List<HRegionLocation> getRegionLocations(TableName tableName, byte[] row) throws IOException {
        return (List)FutureUtils.get((Future)CONN.getRegionLocator(tableName).getRegionLocations(row));
    }

    @Override
    protected List<HRegionLocation> getAllRegionLocations(TableName tableName) throws IOException {
        return (List)FutureUtils.get((Future)CONN.getRegionLocator(tableName).getAllRegionLocations());
    }

    @Override
    protected void clearCache(TableName tableName) throws IOException {
        CONN.getRegionLocator(tableName).clearRegionLocationCache();
    }
}

