/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientSideRegionScanner;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.IndexOnlyLruBlockCache;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, ClientTests.class})
public class TestClientSideRegionScanner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClientSideRegionScanner.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf;
    private Path rootDir;
    private FileSystem fs;
    private TableDescriptor htd;
    private RegionInfo hri;
    private Scan scan;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.rootDir = TEST_UTIL.getDefaultRootDirPath();
        this.fs = TEST_UTIL.getTestFileSystem();
        this.htd = TEST_UTIL.getAdmin().getDescriptor(TableName.META_TABLE_NAME);
        this.hri = (RegionInfo)TEST_UTIL.getAdmin().getRegions(TableName.META_TABLE_NAME).get(0);
        this.scan = new Scan();
    }

    @Test
    public void testDefaultBlockCache() throws IOException {
        Configuration copyConf = new Configuration(this.conf);
        ClientSideRegionScanner clientSideRegionScanner = new ClientSideRegionScanner(copyConf, this.fs, this.rootDir, this.htd, this.hri, this.scan, null);
        BlockCache blockCache = clientSideRegionScanner.getRegion().getBlockCache();
        Assert.assertNotNull((Object)blockCache);
        Assert.assertTrue((boolean)(blockCache instanceof IndexOnlyLruBlockCache));
        Assert.assertTrue((0x2000000L == blockCache.getMaxSize() ? 1 : 0) != 0);
    }

    @Test
    public void testConfiguredBlockCache() throws IOException {
        Configuration copyConf = new Configuration(this.conf);
        long blockCacheFixedSize = 0x100000L;
        copyConf.setLong("hfile.onheap.block.cache.fixed.size", blockCacheFixedSize);
        ClientSideRegionScanner clientSideRegionScanner = new ClientSideRegionScanner(copyConf, this.fs, this.rootDir, this.htd, this.hri, this.scan, null);
        BlockCache blockCache = clientSideRegionScanner.getRegion().getBlockCache();
        Assert.assertNotNull((Object)blockCache);
        Assert.assertTrue((boolean)(blockCache instanceof IndexOnlyLruBlockCache));
        Assert.assertTrue((blockCacheFixedSize == blockCache.getMaxSize() ? 1 : 0) != 0);
    }

    @Test
    public void testNoBlockCache() throws IOException {
        Configuration copyConf = new Configuration(this.conf);
        copyConf.setFloat("hfile.block.cache.size", 0.0f);
        ClientSideRegionScanner clientSideRegionScanner = new ClientSideRegionScanner(copyConf, this.fs, this.rootDir, this.htd, this.hri, this.scan, null);
        BlockCache blockCache = clientSideRegionScanner.getRegion().getBlockCache();
        Assert.assertNull((Object)blockCache);
    }
}

