/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.MasterRegistry;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.Uninterruptibles;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestMasterAddressRefresher {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterAddressRefresher.class);

    @Test
    public void testPeriodicMasterEndPointRefresh() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.client.master_registry.refresh_interval_secs", 1L);
        conf.setLong("hbase.client.master_registry.min_secs_between_refreshes", 0L);
        try (DummyMasterRegistry registry = new DummyMasterRegistry(conf);){
            Waiter.waitFor((Configuration)conf, (long)5000L, () -> registry.getMastersCount() > 3);
        }
    }

    @Test
    public void testDurationBetweenRefreshes() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.client.master_registry.refresh_interval_secs", Integer.MAX_VALUE);
        conf.setLong("hbase.client.master_registry.min_secs_between_refreshes", 1L);
        try (DummyMasterRegistry registry = new DummyMasterRegistry(conf);){
            for (int i = 0; i < 10000; ++i) {
                registry.masterAddressRefresher.refreshNow();
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            List<Long> callTimeStamps = registry.getCallTimeStamps();
            Assert.assertTrue((String)String.valueOf(registry.getMastersCount()), (registry.getMastersCount() <= 20 ? 1 : 0) != 0);
            Assert.assertTrue((callTimeStamps.size() > 0 ? 1 : 0) != 0);
            for (int i = 1; i < callTimeStamps.size() - 1; ++i) {
                long delta = callTimeStamps.get(i) - callTimeStamps.get(i - 1);
                Assert.assertTrue((String)callTimeStamps.toString(), (delta > 990L ? 1 : 0) != 0);
            }
        }
    }

    private class DummyMasterRegistry
    extends MasterRegistry {
        private final AtomicInteger getMastersCallCounter;
        private final List<Long> callTimeStamps;

        DummyMasterRegistry(Configuration conf) throws IOException {
            super(conf);
            this.getMastersCallCounter = new AtomicInteger(0);
            this.callTimeStamps = new ArrayList<Long>();
        }

        CompletableFuture<List<ServerName>> getMasters() {
            this.getMastersCallCounter.incrementAndGet();
            this.callTimeStamps.add(EnvironmentEdgeManager.currentTime());
            return CompletableFuture.completedFuture(new ArrayList());
        }

        public int getMastersCount() {
            return this.getMastersCallCounter.get();
        }

        public List<Long> getCallTimeStamps() {
            return this.callTimeStamps;
        }
    }
}

