/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestStochasticLoadBalancerRegionReplica
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStochasticLoadBalancerRegionReplica.class);

    @Test
    public void testReplicaCost() {
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.RegionReplicaHostCostFunction costFunction = new StochasticLoadBalancer.RegionReplicaHostCostFunction(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            BaseLoadBalancer.Cluster cluster = this.mockCluster(mockCluster);
            costFunction.init(cluster);
            double cost = costFunction.cost();
            Assert.assertTrue((cost >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((cost <= 1.01 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testReplicaCostForReplicas() {
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.RegionReplicaHostCostFunction costFunction = new StochasticLoadBalancer.RegionReplicaHostCostFunction(conf);
        int[] servers = new int[]{3, 3, 3, 3, 3};
        TreeMap<ServerName, List<RegionInfo>> clusterState = this.mockClusterServers(servers);
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, null);
        costFunction.init(cluster);
        double costWithoutReplicas = costFunction.cost();
        Assert.assertEquals((double)0.0, (double)costWithoutReplicas, (double)0.0);
        RegionInfo replica1 = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)clusterState.firstEntry().getValue().get(0), (int)1);
        clusterState.lastEntry().getValue().add(replica1);
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, null);
        costFunction.init(cluster);
        double costWith1ReplicaDifferentServer = costFunction.cost();
        Assert.assertEquals((double)0.0, (double)costWith1ReplicaDifferentServer, (double)0.0);
        RegionInfo replica2 = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)replica1, (int)2);
        clusterState.lastEntry().getValue().add(replica2);
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, null);
        costFunction.init(cluster);
        double costWith1ReplicaSameServer = costFunction.cost();
        Assert.assertTrue((costWith1ReplicaDifferentServer < costWith1ReplicaSameServer ? 1 : 0) != 0);
        clusterState = this.mockClusterServers(servers);
        Iterator<Map.Entry<ServerName, List<RegionInfo>>> it = clusterState.entrySet().iterator();
        Map.Entry<ServerName, List<RegionInfo>> entry = it.next();
        RegionInfo hri = entry.getValue().get(0);
        replica1 = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hri, (int)1);
        replica2 = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hri, (int)2);
        RegionInfo replica3 = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hri, (int)3);
        entry.getValue().add(replica1);
        entry.getValue().add(replica2);
        it.next().getValue().add(replica3);
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, null);
        costFunction.init(cluster);
        double costWith3ReplicasSameServer = costFunction.cost();
        clusterState = this.mockClusterServers(servers);
        hri = clusterState.firstEntry().getValue().get(0);
        replica1 = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hri, (int)1);
        replica2 = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hri, (int)2);
        replica3 = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hri, (int)3);
        clusterState.firstEntry().getValue().add(replica1);
        clusterState.lastEntry().getValue().add(replica2);
        clusterState.lastEntry().getValue().add(replica3);
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, null);
        costFunction.init(cluster);
        double costWith2ReplicasOnTwoServers = costFunction.cost();
        Assert.assertTrue((costWith2ReplicasOnTwoServers < costWith3ReplicasSameServer ? 1 : 0) != 0);
    }

    @Test
    public void testNeedsBalanceForColocatedReplicas() {
        List<RegionInfo> regions = this.randomRegions(1);
        ServerName s1 = ServerName.valueOf((String)"host1", (int)1000, (long)11111L);
        ServerName s2 = ServerName.valueOf((String)"host11", (int)1000, (long)11111L);
        HashMap<ServerName, List<Object>> map = new HashMap<ServerName, List<Object>>();
        map.put(s1, regions);
        regions.add(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)regions.get(0), (int)1));
        regions = this.randomRegions(1);
        map.put(s2, regions);
        Assert.assertTrue((boolean)loadBalancer.needsBalance(HConstants.ENSEMBLE_TABLE_NAME, new BaseLoadBalancer.Cluster(map, null, null, null)));
        map.clear();
        regions = this.randomRegions(1);
        ArrayList<RegionInfo> regionsOnS2 = new ArrayList<RegionInfo>(1);
        regionsOnS2.add(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)regions.get(0), (int)1));
        map.put(s1, regions);
        map.put(s2, regionsOnS2);
        map.put(ServerName.valueOf((String)"host2", (int)1000, (long)11111L), this.randomRegions(1));
        Assert.assertFalse((boolean)loadBalancer.needsBalance(HConstants.ENSEMBLE_TABLE_NAME, new BaseLoadBalancer.Cluster(map, null, null, (RackManager)new ForTestRackManagerOne())));
    }

    @Test
    public void testRegionReplicasOnSmallCluster() {
        int numNodes = 10;
        int numRegions = 1000;
        int replication = 3;
        int numRegionsPerServer = 80;
        int numTables = 10;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, true, true);
    }

    private static class ForTestRackManagerOne
    extends RackManager {
        private ForTestRackManagerOne() {
        }

        public String getRack(ServerName server) {
            return server.getHostname().endsWith("1") ? "rack1" : "rack2";
        }
    }
}

