/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;

final class ScanOptions {
    private final Authorizations authorizations;
    private final byte[] defaultLabels;
    private final Set<Column> columnSet;
    private final List<IterInfo> ssiList;
    private final Map<String, Map<String, String>> ssio;
    private final AtomicBoolean interruptFlag;
    private final int num;
    private final boolean isolated;
    private SamplerConfiguration samplerConfig;
    private final long batchTimeOut;
    private String classLoaderContext;

    ScanOptions(int num, Authorizations authorizations, byte[] defaultLabels, Set<Column> columnSet, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, AtomicBoolean interruptFlag, boolean isolated, SamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext) {
        this.num = num;
        this.authorizations = authorizations;
        this.defaultLabels = defaultLabels;
        this.columnSet = columnSet;
        this.ssiList = ssiList;
        this.ssio = ssio;
        this.interruptFlag = interruptFlag;
        this.isolated = isolated;
        this.samplerConfig = samplerConfig;
        this.batchTimeOut = batchTimeOut;
        this.classLoaderContext = classLoaderContext;
    }

    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    public byte[] getDefaultLabels() {
        return this.defaultLabels;
    }

    public Set<Column> getColumnSet() {
        return this.columnSet;
    }

    public List<IterInfo> getSsiList() {
        return this.ssiList;
    }

    public Map<String, Map<String, String>> getSsio() {
        return this.ssio;
    }

    public AtomicBoolean getInterruptFlag() {
        return this.interruptFlag;
    }

    public int getNum() {
        return this.num;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public SamplerConfiguration getSamplerConfiguration() {
        return this.samplerConfig;
    }

    public SamplerConfigurationImpl getSamplerConfigurationImpl() {
        if (this.samplerConfig == null) {
            return null;
        }
        return new SamplerConfigurationImpl(this.samplerConfig);
    }

    public long getBatchTimeOut() {
        return this.batchTimeOut;
    }

    public String getClassLoaderContext() {
        return this.classLoaderContext;
    }

    public void setClassLoaderContext(String context) {
        this.classLoaderContext = context;
    }
}

