/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestGet {
    private static final byte[] ROW = new byte[]{114};
    private static final String PB_GET = "CgNyb3ciEwoPdGVzdC5Nb2NrRmlsdGVyEgAwATgB";
    private static final String PB_GET_WITH_FILTER_LIST = "CgFyIosBCilvcmcuYXBhY2hlLmhhZG9vcC5oYmFzZS5maWx0ZXIuRmlsdGVyTGlzdBJeCAESEwoPdGVzdC5Nb2NrRmlsdGVyEgASEQoNbXkuTW9ja0ZpbHRlchIAEjIKLG9yZy5hcGFjaGUuaGFkb29wLmhiYXNlLmZpbHRlci5LZXlPbmx5RmlsdGVyEgIIADABOAE=";
    private static final String MOCK_FILTER_JAR = "UEsDBBQACAgIANWDlEMAAAAAAAAAAAAAAAAJAAQATUVUQS1JTkYv/soAAAMAUEsHCAAAAAACAAAAAAAAAFBLAwQUAAgICADVg5RDAAAAAAAAAAAAAAAAFAAAAE1FVEEtSU5GL01BTklGRVNULk1G803My0xLLS7RDUstKs7Mz7NSMNQz4OVyLkpNLElN0XWqBAmY6xnEG1gqaPgXJSbnpCo45xcV5BcllgCVa/Jy8XIBAFBLBwgxyqRbQwAAAEQAAABQSwMEFAAICAgAUoOUQwAAAAAAAAAAAAAAABMAAABteS9Nb2NrRmlsdGVyLmNsYXNzdZHPTsJAEMa/LYVCRVFQMd68gQc38YrxUJUTetGQGE7bstrVwjbbYsSn0hOJJj6AD2WcFoP/4iYzX+bb32xmd9/en18B7GPLhY11BxsurEw3GUoHaqzSQ4ZCq91nsI/0UDLUemoszyYjX5oL4Ufk1Hs6EFFfGJXVn6adhirJ6NGUn+rgtquiVJoOQyUWJpFdo0cMjdbAa/8hnNj3pqmkbmvgMbgn94GMU6XHiYMm1ed6YgJJeDbNV+fejbgTVRRRYlj+cSZDW5trLmIRhJKHYqh1zENfJJJf5QCfcx45DJ3/WLmYgx/LRNJ1I/UgMmMxIXbo9WxkywLLZqHsUMVJGWlxdwb2lG+XKZdys4kK5eocgIsl0grVy0Q5+e9Y+V75BdblDIXHX/3b3/rLWEGNdJXCJmeNop7zjQ9QSwcI1kzyMToBAADsAQAAUEsDBBQACAgIAFKDlEMAAAAAAAAAAAAAAAAVAAAAdGVzdC9Nb2NrRmlsdGVyLmNsYXNzdVHBTsJAFJwthUJFERQx3ryBBzfxivFQlRN60ZAYTtuy2tXCNtti1K/SE4kmfoAfZXwtBg3RTd6bzOy8zezux+frO4ADbLuwsemg6cLKcIuhdKgmKj1iKLQ7Awb7WI8kQ62vJvJ8OvaluRR+REqjrwMRDYRRGf8W7TRUCUO9n8ok5Wc6uOupKJWmy1CJhUlkz+gxQ7M99Dp/eJzY9x5JZrCGHoN7+hDIOFV6kjhoEb/QUxNIsmeJfib3b8W9qKKIEslLpzJ0tLnhIhZBKHkoRlrHPPRFIvl1buBzn0cKQ/c/r1wk4ScykXTpSD2JTFhkxC69oY1sWWBZGuoOMU7ICIt7M7CXfLtMvZSLLVSoV+cGuFghrBBfJZeT/5GV75XfYF3NUHhemt/5NV/GGmqE61Q2KXWqRu7f+AJQSwcIrS5nKDoBAADyAQAAUEsBAhQAFAAICAgA1YOUQwAAAAACAAAAAAAAAAkABAAAAAAAAAAAAAAAAAAAAE1FVEEtSU5GL/7KAABQSwECFAAUAAgICADVg5RDMcqkW0MAAABEAAAAFAAAAAAAAAAAAAAAAAA9AAAATUVUQS1JTkYvTUFOSUZFU1QuTUZQSwECFAAUAAgICABSg5RD1kzyMToBAADsAQAAEwAAAAAAAAAAAAAAAADCAAAAbXkvTW9ja0ZpbHRlci5jbGFzc1BLAQIUABQACAgIAFKDlEOtLmcoOgEAAPIBAAAVAAAAAAAAAAAAAAAAAD0CAAB0ZXN0L01vY2tGaWx0ZXIuY2xhc3NQSwUGAAAAAAQABAABAQAAugMAAAAA";

    @Test
    public void testAttributesSerialization() throws IOException {
        Get get = new Get(Bytes.toBytes((String)"row"));
        get.setAttribute("attribute1", Bytes.toBytes((String)"value1"));
        get.setAttribute("attribute2", Bytes.toBytes((String)"value2"));
        get.setAttribute("attribute3", Bytes.toBytes((String)"value3"));
        ClientProtos.Get getProto = ProtobufUtil.toGet((Get)get);
        Get get2 = ProtobufUtil.toGet((ClientProtos.Get)getProto);
        Assert.assertNull((Object)get2.getAttribute("absent"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), get2.getAttribute("attribute1")));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), get2.getAttribute("attribute2")));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value3"), get2.getAttribute("attribute3")));
        Assert.assertEquals((long)3L, (long)get2.getAttributesMap().size());
    }

    @Test
    public void testGetAttributes() {
        Get get = new Get(ROW);
        Assert.assertTrue((boolean)get.getAttributesMap().isEmpty());
        Assert.assertNull((Object)get.getAttribute("absent"));
        get.setAttribute("absent", null);
        Assert.assertTrue((boolean)get.getAttributesMap().isEmpty());
        Assert.assertNull((Object)get.getAttribute("absent"));
        get.setAttribute("attribute1", Bytes.toBytes((String)"value1"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), get.getAttribute("attribute1")));
        Assert.assertEquals((long)1L, (long)get.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), (byte[])get.getAttributesMap().get("attribute1")));
        get.setAttribute("attribute1", Bytes.toBytes((String)"value12"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value12"), get.getAttribute("attribute1")));
        Assert.assertEquals((long)1L, (long)get.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value12"), (byte[])get.getAttributesMap().get("attribute1")));
        get.setAttribute("attribute2", Bytes.toBytes((String)"value2"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), get.getAttribute("attribute2")));
        Assert.assertEquals((long)2L, (long)get.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), (byte[])get.getAttributesMap().get("attribute2")));
        get.setAttribute("attribute2", null);
        Assert.assertNull((Object)get.getAttribute("attribute2"));
        Assert.assertEquals((long)1L, (long)get.getAttributesMap().size());
        Assert.assertNull(get.getAttributesMap().get("attribute2"));
        get.setAttribute("attribute2", null);
        Assert.assertNull((Object)get.getAttribute("attribute2"));
        Assert.assertEquals((long)1L, (long)get.getAttributesMap().size());
        Assert.assertNull(get.getAttributesMap().get("attribute2"));
        get.setAttribute("attribute1", null);
        Assert.assertNull((Object)get.getAttribute("attribute1"));
        Assert.assertTrue((boolean)get.getAttributesMap().isEmpty());
        Assert.assertNull(get.getAttributesMap().get("attribute1"));
    }

    @Test
    public void testNullQualifier() {
        Get get = new Get(ROW);
        byte[] family = Bytes.toBytes((String)"family");
        get.addColumn(family, null);
        Set qualifiers = (Set)get.getFamilyMap().get(family);
        Assert.assertEquals((long)1L, (long)qualifiers.size());
    }

    @Test
    public void TestGetRowFromGetCopyConstructor() throws Exception {
        Get get = new Get(ROW);
        get.setFilter(null);
        get.setAuthorizations(new Authorizations(new String[]{"foo"}));
        get.setACL("u", new Permission(new Permission.Action[]{Permission.Action.READ}));
        get.setConsistency(Consistency.TIMELINE);
        get.setReplicaId(2);
        get.setIsolationLevel(IsolationLevel.READ_UNCOMMITTED);
        get.setCheckExistenceOnly(true);
        get.setClosestRowBefore(true);
        get.setTimeRange(3L, 4L);
        get.setMaxVersions(11);
        get.setMaxResultsPerColumnFamily(10);
        get.setRowOffsetPerColumnFamily(11);
        get.setCacheBlocks(true);
        Get copyGet = new Get(get);
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])get.getRow(), (byte[])copyGet.getRow()));
        Assert.assertEquals((Object)get.getId(), (Object)copyGet.getId());
        Assert.assertEquals((Object)get.getFilter(), (Object)copyGet.getFilter());
        Assert.assertTrue((boolean)get.getAuthorizations().toString().equals(copyGet.getAuthorizations().toString()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])get.getACL(), (byte[])copyGet.getACL()));
        Assert.assertEquals((Object)get.getConsistency(), (Object)copyGet.getConsistency());
        Assert.assertEquals((long)get.getReplicaId(), (long)copyGet.getReplicaId());
        Assert.assertEquals((Object)get.getIsolationLevel(), (Object)copyGet.getIsolationLevel());
        Assert.assertEquals((Object)get.isCheckExistenceOnly(), (Object)copyGet.isCheckExistenceOnly());
        Assert.assertEquals((Object)get.isClosestRowBefore(), (Object)copyGet.isClosestRowBefore());
        Assert.assertTrue((boolean)get.getTimeRange().equals(copyGet.getTimeRange()));
        Assert.assertEquals((Object)get.isClosestRowBefore(), (Object)copyGet.isClosestRowBefore());
        Assert.assertEquals((long)get.getMaxVersions(), (long)copyGet.getMaxVersions());
        Assert.assertEquals((long)get.getMaxResultsPerColumnFamily(), (long)copyGet.getMaxResultsPerColumnFamily());
        Assert.assertEquals((long)get.getRowOffsetPerColumnFamily(), (long)copyGet.getRowOffsetPerColumnFamily());
        Assert.assertEquals((Object)get.getCacheBlocks(), (Object)copyGet.getCacheBlocks());
        Assert.assertEquals((Object)get.getId(), (Object)copyGet.getId());
    }

    @Test
    public void testDynamicFilter() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        String localPath = conf.get("hbase.local.dir") + File.separator + "jars" + File.separator;
        File jarFile = new File(localPath, "MockFilter.jar");
        jarFile.delete();
        Assert.assertFalse((String)("Should be deleted: " + jarFile.getPath()), (boolean)jarFile.exists());
        ClientProtos.Get getProto1 = ClientProtos.Get.parseFrom((byte[])Base64.decode((String)PB_GET));
        ClientProtos.Get getProto2 = ClientProtos.Get.parseFrom((byte[])Base64.decode((String)PB_GET_WITH_FILTER_LIST));
        try {
            ProtobufUtil.toGet((ClientProtos.Get)getProto1);
            Assert.fail((String)"Should not be able to load the filter class");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe.getCause() instanceof ClassNotFoundException));
        }
        try {
            ProtobufUtil.toGet((ClientProtos.Get)getProto2);
            Assert.fail((String)"Should not be able to load the filter class");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe.getCause() instanceof InvocationTargetException));
            InvocationTargetException ite = (InvocationTargetException)ioe.getCause();
            Assert.assertTrue((boolean)(ite.getTargetException() instanceof DeserializationException));
        }
        FileOutputStream fos = new FileOutputStream(jarFile);
        fos.write(Base64.decode((String)MOCK_FILTER_JAR));
        fos.close();
        Get get1 = ProtobufUtil.toGet((ClientProtos.Get)getProto1);
        Assert.assertEquals((Object)"test.MockFilter", (Object)get1.getFilter().getClass().getName());
        Get get2 = ProtobufUtil.toGet((ClientProtos.Get)getProto2);
        Assert.assertTrue((boolean)(get2.getFilter() instanceof FilterList));
        List filters = ((FilterList)get2.getFilter()).getFilters();
        Assert.assertEquals((long)3L, (long)filters.size());
        Assert.assertEquals((Object)"test.MockFilter", (Object)((Filter)filters.get(0)).getClass().getName());
        Assert.assertEquals((Object)"my.MockFilter", (Object)((Filter)filters.get(1)).getClass().getName());
        Assert.assertTrue((boolean)(filters.get(2) instanceof KeyOnlyFilter));
    }
}

