/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.commands.ActiveCompactionIterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ListCompactionsCommand
extends Shell.Command {
    private Option tserverOption;
    private Option disablePaginationOpt;

    @Override
    public String description() {
        return "lists what compactions are currently running in accumulo. See the accumulo.core.client.admin.ActiveCompaciton javadoc for more information about columns.";
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        List<String> tservers;
        boolean paginate;
        InstanceOperations instanceOps = shellState.getConnector().instanceOperations();
        boolean bl = paginate = !cl.hasOption(this.disablePaginationOpt.getOpt());
        if (cl.hasOption(this.tserverOption.getOpt())) {
            tservers = new ArrayList<String>();
            tservers.add(cl.getOptionValue(this.tserverOption.getOpt()));
        } else {
            tservers = instanceOps.getTabletServers();
        }
        shellState.printLines(new ActiveCompactionIterator(tservers, instanceOps), paginate);
        return 0;
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options opts = new Options();
        this.tserverOption = new Option("ts", "tabletServer", true, "tablet server to list compactions for");
        this.tserverOption.setArgName("tablet server");
        opts.addOption(this.tserverOption);
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disable pagination of output");
        opts.addOption(this.disablePaginationOpt);
        return opts;
    }
}

