/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.gc;

import com.beust.jcommander.Parameter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileUtil;
import org.apache.accumulo.core.gc.thrift.GCMonitorService;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.gc.thrift.GcCycleStats;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.SecurityUtil;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.gc.GarbageCollectWriteAheadLogs;
import org.apache.accumulo.server.master.state.tables.TableManager;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.trace.TraceFileSystem;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.server.util.OfflineMetadataScanner;
import org.apache.accumulo.server.util.TServerUtils;
import org.apache.accumulo.server.util.TabletIterator;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.trace.instrument.CountSampler;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.accumulo.trace.instrument.thrift.TraceWrap;
import org.apache.accumulo.trace.thrift.TInfo;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.thrift.TProcessor;
import org.apache.zookeeper.KeeperException;

public class SimpleGarbageCollector
implements GCMonitorService.Iface {
    private static final Text EMPTY_TEXT = new Text();
    private static final float CANDIDATE_MEMORY_PERCENTAGE = 0.75f;
    private boolean candidateMemExceeded;
    private static final Logger log = Logger.getLogger(SimpleGarbageCollector.class);
    private TCredentials credentials;
    private long gcStartDelay;
    private boolean checkForBulkProcessingFiles;
    private FileSystem fs;
    private Trash trash = null;
    private boolean safemode = false;
    private boolean offline = false;
    private boolean verbose = false;
    private String address = "localhost";
    private ZooLock lock;
    private Key continueKey = null;
    private GCStatus status = new GCStatus(new GcCycleStats(), new GcCycleStats(), new GcCycleStats(), new GcCycleStats());
    private int numDeleteThreads;
    private Instance instance;
    static final String METADATA_TABLE_DIR = "/!0";

    public static void main(String[] args) throws UnknownHostException, IOException {
        SecurityUtil.serverLogin();
        Instance instance = HdfsZooInstance.getInstance();
        ServerConfiguration serverConf = new ServerConfiguration(instance);
        FileSystem fs = FileUtil.getFileSystem((Configuration)CachedConfiguration.getInstance(), (AccumuloConfiguration)serverConf.getConfiguration());
        Accumulo.init(fs, serverConf, "gc");
        String address = "localhost";
        SimpleGarbageCollector gc = new SimpleGarbageCollector();
        Opts opts = new Opts();
        opts.parseArgs(SimpleGarbageCollector.class.getName(), args, new Object[0]);
        if (opts.safeMode) {
            gc.setSafeMode();
        }
        if (opts.offline) {
            gc.setOffline();
        }
        if (opts.verbose) {
            gc.setVerbose();
        }
        if (opts.address != null) {
            gc.useAddress(address);
        }
        gc.init(fs, instance, SecurityConstants.getSystemCredentials(), serverConf.getConfiguration().getBoolean(Property.GC_TRASH_IGNORE));
        Accumulo.enableTracing(address, "gc");
        gc.run();
    }

    public void setSafeMode() {
        this.safemode = true;
    }

    public void setOffline() {
        this.offline = true;
    }

    public void setVerbose() {
        this.verbose = true;
    }

    public void useAddress(String address) {
        this.address = address;
    }

    public void init(FileSystem fs, Instance instance, TCredentials credentials, boolean noTrash) throws IOException {
        this.fs = TraceFileSystem.wrap(fs);
        this.credentials = credentials;
        this.instance = instance;
        this.gcStartDelay = instance.getConfiguration().getTimeInMillis(Property.GC_CYCLE_START);
        long gcDelay = instance.getConfiguration().getTimeInMillis(Property.GC_CYCLE_DELAY);
        this.numDeleteThreads = instance.getConfiguration().getCount(Property.GC_DELETE_THREADS);
        log.info((Object)("start delay: " + (this.offline ? "0 sec (offline)" : this.gcStartDelay + " milliseconds")));
        log.info((Object)("time delay: " + gcDelay + " milliseconds"));
        log.info((Object)("safemode: " + this.safemode));
        log.info((Object)("offline: " + this.offline));
        log.info((Object)("verbose: " + this.verbose));
        log.info((Object)("memory threshold: 0.75 of " + Runtime.getRuntime().maxMemory() + " bytes"));
        log.info((Object)("delete threads: " + this.numDeleteThreads));
        if (!noTrash) {
            this.trash = new Trash(fs, fs.getConf());
        }
    }

    private void run() {
        if (!this.offline) {
            try {
                this.getZooLock(this.startStatsService());
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
                System.exit(1);
            }
            try {
                log.debug((Object)("Sleeping for " + this.gcStartDelay + " milliseconds before beginning garbage collection cycles"));
                Thread.sleep(this.gcStartDelay);
            }
            catch (InterruptedException e) {
                log.warn((Object)e, (Throwable)e);
                return;
            }
        }
        CountSampler sampler = new CountSampler(100L);
        while (true) {
            if (sampler.next()) {
                Trace.on((String)"gc");
            }
            Span gcSpan = Trace.start((String)"loop");
            long tStart = System.currentTimeMillis();
            try {
                System.gc();
                this.candidateMemExceeded = false;
                this.checkForBulkProcessingFiles = false;
                Span candidatesSpan = Trace.start((String)"getCandidates");
                this.status.current.started = System.currentTimeMillis();
                SortedSet<String> candidates = this.getCandidates();
                this.status.current.candidates = candidates.size();
                candidatesSpan.stop();
                Span confirmDeletesSpan = Trace.start((String)"confirmDeletes");
                this.confirmDeletes(candidates);
                this.status.current.inUse = this.status.current.candidates - (long)candidates.size();
                confirmDeletesSpan.stop();
                if (this.safemode) {
                    if (this.verbose) {
                        System.out.println("SAFEMODE: There are " + candidates.size() + " data file candidates marked for deletion.%n" + "          Examine the log files to identify them.%n" + "          They can be removed by executing: bin/accumulo gc --offline%n" + "WARNING:  Do not run the garbage collector in offline mode unless you are positive%n" + "          that the accumulo METADATA table is in a clean state, or that accumulo%n" + "          has not yet been run, in the case of an upgrade.");
                    }
                    log.info((Object)"SAFEMODE: Listing all data file candidates for deletion");
                    for (String s : candidates) {
                        log.info((Object)("SAFEMODE: " + s));
                    }
                    log.info((Object)"SAFEMODE: End candidates for deletion");
                } else {
                    Span deleteSpan = Trace.start((String)"deleteFiles");
                    this.deleteFiles(candidates);
                    log.info((Object)("Number of data file candidates for deletion: " + this.status.current.candidates));
                    log.info((Object)("Number of data file candidates still in use: " + this.status.current.inUse));
                    log.info((Object)("Number of successfully deleted data files: " + this.status.current.deleted));
                    log.info((Object)("Number of data files delete failures: " + this.status.current.errors));
                    deleteSpan.stop();
                    this.cleanUpDeletedTableDirs(candidates);
                }
                this.status.current.finished = System.currentTimeMillis();
                this.status.last = this.status.current;
                this.status.current = new GcCycleStats();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
            long tStop = System.currentTimeMillis();
            log.info((Object)String.format("Collect cycle took %.2f seconds", (double)(tStop - tStart) / 1000.0));
            if (this.offline) break;
            if (this.candidateMemExceeded) {
                log.info((Object)"Gathering of candidates was interrupted due to memory shortage. Bypassing cycle delay to collect the remaining candidates.");
                continue;
            }
            Span waLogs = Trace.start((String)"walogs");
            try {
                GarbageCollectWriteAheadLogs walogCollector = new GarbageCollectWriteAheadLogs(this.instance, this.fs, this.trash == null);
                log.info((Object)"Beginning garbage collection of write-ahead logs");
                walogCollector.collect(this.status);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
            waLogs.stop();
            gcSpan.stop();
            try {
                Connector connector = this.instance.getConnector(this.credentials.getPrincipal(), CredentialHelper.extractToken((TCredentials)this.credentials));
                connector.tableOperations().compact("!METADATA", null, null, true, true);
            }
            catch (Exception e) {
                log.warn((Object)e, (Throwable)e);
            }
            Trace.offNoFlush();
            try {
                long gcDelay = this.instance.getConfiguration().getTimeInMillis(Property.GC_CYCLE_DELAY);
                log.debug((Object)("Sleeping for " + gcDelay + " milliseconds"));
                Thread.sleep(gcDelay);
            }
            catch (InterruptedException e) {
                log.warn((Object)e, (Throwable)e);
                return;
            }
        }
    }

    private boolean moveToTrash(Path path) throws IOException {
        if (this.trash == null) {
            return false;
        }
        try {
            return this.trash.moveToTrash(path);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    private void cleanUpDeletedTableDirs(SortedSet<String> candidates) throws Exception {
        HashSet<String> tableIdsWithDeletes = new HashSet<String>();
        for (String delete : candidates) {
            if (!this.isDir(delete)) continue;
            String tableId = delete.split("/")[1];
            tableIdsWithDeletes.add(tableId);
        }
        Tables.clearCache((Instance)this.instance);
        Set tableIdsInZookeeper = Tables.getIdToNameMap((Instance)this.instance).keySet();
        tableIdsWithDeletes.removeAll(tableIdsInZookeeper);
        for (String delTableId : tableIdsWithDeletes) {
            Path p;
            FileStatus[] tabletDirs = null;
            try {
                tabletDirs = this.fs.listStatus(new Path(ServerConstants.getTablesDir() + "/" + delTableId));
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
            if (tabletDirs == null || tabletDirs.length != 0 || this.moveToTrash(p = new Path(ServerConstants.getTablesDir() + "/" + delTableId))) continue;
            this.fs.delete(p, false);
        }
    }

    private void getZooLock(InetSocketAddress addr) throws KeeperException, InterruptedException {
        String address = addr.getHostName() + ":" + addr.getPort();
        String path = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/gc/lock";
        ZooLock.LockWatcher lockWatcher = new ZooLock.LockWatcher(){

            public void lostLock(ZooLock.LockLossReason reason) {
                Halt.halt("GC lock in zookeeper lost (reason = " + reason + "), exiting!");
            }

            public void unableToMonitorLockNode(final Throwable e) {
                Halt.halt(-1, new Runnable(){

                    @Override
                    public void run() {
                        log.fatal((Object)"No longer able to monitor lock node ", e);
                    }
                });
            }
        };
        while (true) {
            this.lock = new ZooLock(path);
            if (this.lock.tryLock(lockWatcher, new ServerServices(address, ServerServices.Service.GC_CLIENT).toString().getBytes())) break;
            UtilWaitThread.sleep((long)1000L);
        }
    }

    private InetSocketAddress startStatsService() throws UnknownHostException {
        GCMonitorService.Processor processor = new GCMonitorService.Processor((GCMonitorService.Iface)TraceWrap.service((Object)this));
        int port = this.instance.getConfiguration().getPort(Property.GC_PORT);
        long maxMessageSize = this.instance.getConfiguration().getMemoryInBytes(Property.GENERAL_MAX_MESSAGE_SIZE);
        try {
            TServerUtils.startTServer(port, (TProcessor)processor, this.getClass().getSimpleName(), "GC Monitor Service", 2, 1000L, maxMessageSize);
        }
        catch (Exception ex) {
            log.fatal((Object)ex, (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return new InetSocketAddress(Accumulo.getLocalAddress(new String[]{"--address", this.address}), port);
    }

    SortedSet<String> getCandidates() throws Exception {
        TreeSet<String> candidates = new TreeSet<String>();
        if (this.offline) {
            this.checkForBulkProcessingFiles = true;
            try {
                for (String validExtension : FileOperations.getValidExtensions()) {
                    for (FileStatus stat : this.fs.globStatus(new Path(ServerConstants.getTablesDir() + "/*/*/*." + validExtension))) {
                        String cand = stat.getPath().toUri().getPath();
                        if (cand.contains(ServerConstants.getRootTabletDir())) continue;
                        candidates.add(cand.substring(ServerConstants.getTablesDir().length()));
                        log.debug((Object)("Offline candidate: " + cand));
                    }
                }
            }
            catch (IOException e) {
                log.error((Object)"Unable to check the filesystem for offline candidates. Removing all candidates for deletion to be safe.", (Throwable)e);
                candidates.clear();
            }
            return candidates;
        }
        this.checkForBulkProcessingFiles = false;
        Range range = Constants.METADATA_DELETES_FOR_METADATA_KEYSPACE;
        candidates.addAll(this.getBatch("!!~del", range));
        if (this.candidateMemExceeded) {
            return candidates;
        }
        range = Constants.METADATA_DELETES_KEYSPACE;
        candidates.addAll(this.getBatch("~del", range));
        return candidates;
    }

    private Collection<String> getBatch(String prefix, Range range) throws Exception {
        if (this.continueKey != null) {
            if (!range.contains(this.continueKey)) {
                return Collections.emptyList();
            }
            range = new Range(this.continueKey, true, range.getEndKey(), range.isEndKeyInclusive());
            this.continueKey = null;
        }
        Scanner scanner = this.instance.getConnector(this.credentials.getPrincipal(), CredentialHelper.extractToken((TCredentials)this.credentials)).createScanner("!METADATA", Constants.NO_AUTHS);
        scanner.setRange(range);
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : scanner) {
            String cand = ((Key)entry.getKey()).getRow().toString().substring(prefix.length());
            result.add(cand);
            this.checkForBulkProcessingFiles |= cand.toLowerCase(Locale.ENGLISH).contains("b-");
            if (!SimpleGarbageCollector.almostOutOfMemory()) continue;
            this.candidateMemExceeded = true;
            log.info((Object)"List of delete candidates has exceeded the memory threshold. Attempting to delete what has been gathered so far.");
            this.continueKey = (Key)entry.getKey();
            break;
        }
        return result;
    }

    public static boolean almostOutOfMemory() {
        Runtime runtime = Runtime.getRuntime();
        return (float)(runtime.totalMemory() - runtime.freeMemory()) > 0.75f * (float)runtime.maxMemory();
    }

    public void confirmDeletes(SortedSet<String> candidates) throws AccumuloException {
        OfflineMetadataScanner scanner;
        if (this.offline) {
            try {
                scanner = new OfflineMetadataScanner(this.instance.getConfiguration(), this.fs);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create offline metadata scanner", e);
            }
        }
        try {
            scanner = new IsolatedScanner(this.instance.getConnector(this.credentials.getPrincipal(), CredentialHelper.extractToken((TCredentials)this.credentials)).createScanner("!METADATA", Constants.NO_AUTHS));
        }
        catch (AccumuloSecurityException ex) {
            throw new AccumuloException((Throwable)ex);
        }
        catch (TableNotFoundException ex) {
            throw new AccumuloException((Throwable)ex);
        }
        if (this.checkForBulkProcessingFiles) {
            log.debug((Object)"Checking for bulk processing flags");
            scanner.setRange(Constants.METADATA_BLIP_KEYSPACE);
            Iterator i$ = scanner.iterator();
            while (i$.hasNext()) {
                Map.Entry entry = (Map.Entry)i$.next();
                String blipPath = ((Key)entry.getKey()).getRow().toString().substring("~blip".length());
                Iterator tailIter = candidates.tailSet(blipPath).iterator();
                int count = 0;
                while (tailIter.hasNext() && ((String)tailIter.next()).startsWith(blipPath)) {
                    ++count;
                    tailIter.remove();
                }
                if (count <= 0) continue;
                log.debug((Object)("Folder has bulk processing flag: " + blipPath));
            }
        }
        scanner.clearColumns();
        scanner.fetchColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY);
        scanner.fetchColumnFamily(Constants.METADATA_SCANFILE_COLUMN_FAMILY);
        Constants.METADATA_DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
        TabletIterator tabletIterator = new TabletIterator(scanner, Constants.METADATA_KEYSPACE, false, true);
        while (tabletIterator.hasNext()) {
            Object tabletKeyValues = tabletIterator.next();
            for (Map.Entry entry : tabletKeyValues.entrySet()) {
                String delete;
                if (((Key)entry.getKey()).getColumnFamily().equals((Object)Constants.METADATA_DATAFILE_COLUMN_FAMILY) || ((Key)entry.getKey()).getColumnFamily().equals((Object)Constants.METADATA_SCANFILE_COLUMN_FAMILY)) {
                    String path;
                    String cf = ((Key)entry.getKey()).getColumnQualifier().toString();
                    if (cf.startsWith("../")) {
                        delete = cf.substring(2);
                    } else {
                        String table = new String(KeyExtent.tableOfMetadataRow((Text)((Key)entry.getKey()).getRow()));
                        delete = "/" + table + cf;
                    }
                    if (candidates.remove(delete)) {
                        log.debug((Object)("Candidate was still in use in the METADATA table: " + delete));
                    }
                    if (!candidates.remove(path = delete.substring(0, delete.lastIndexOf(47)))) continue;
                    log.debug((Object)("Candidate was still in use in the METADATA table: " + path));
                    continue;
                }
                if (Constants.METADATA_DIRECTORY_COLUMN.hasColumns((Key)entry.getKey())) {
                    String table = new String(KeyExtent.tableOfMetadataRow((Text)((Key)entry.getKey()).getRow()));
                    delete = "/" + table + ((Value)entry.getValue()).toString();
                    if (!candidates.remove(delete)) continue;
                    log.debug((Object)("Candidate was still in use in the METADATA table: " + delete));
                    continue;
                }
                throw new AccumuloException("Scanner over metadata table returned unexpected column : " + entry.getKey());
            }
        }
    }

    private static void putMarkerDeleteMutation(String delete, BatchWriter writer, BatchWriter rootWriter) throws MutationsRejectedException {
        if (delete.startsWith(METADATA_TABLE_DIR)) {
            Mutation m = new Mutation(new Text("!!~del" + delete));
            m.putDelete(EMPTY_TEXT, EMPTY_TEXT);
            rootWriter.addMutation(m);
        } else {
            Mutation m = new Mutation(new Text("~del" + delete));
            m.putDelete(EMPTY_TEXT, EMPTY_TEXT);
            writer.addMutation(m);
        }
    }

    private void deleteFiles(SortedSet<String> confirmedDeletes) {
        BatchWriter writer = null;
        BatchWriter rootWriter = null;
        if (!this.offline) {
            try {
                Connector c = this.instance.getConnector("!SYSTEM", SecurityConstants.getSystemToken());
                writer = c.createBatchWriter("!METADATA", new BatchWriterConfig());
                rootWriter = c.createBatchWriter("!METADATA", new BatchWriterConfig());
            }
            catch (Exception e) {
                log.error((Object)"Unable to create writer to remove file from the !METADATA table", (Throwable)e);
            }
        }
        Iterator cdIter = confirmedDeletes.iterator();
        String lastDir = null;
        while (cdIter.hasNext()) {
            String delete = (String)cdIter.next();
            if (this.isDir(delete)) {
                lastDir = delete;
                continue;
            }
            if (lastDir == null) continue;
            if (delete.startsWith(lastDir)) {
                log.debug((Object)("Ignoring " + delete + " because " + lastDir + " exist"));
                try {
                    SimpleGarbageCollector.putMarkerDeleteMutation(delete, writer, rootWriter);
                }
                catch (MutationsRejectedException e) {
                    throw new RuntimeException(e);
                }
                cdIter.remove();
                continue;
            }
            lastDir = null;
        }
        final BatchWriter finalWriter = writer;
        final BatchWriter finalRootWriter = rootWriter;
        ExecutorService deleteThreadPool = Executors.newFixedThreadPool(this.numDeleteThreads, (ThreadFactory)new NamingThreadFactory("deleting"));
        for (final String delete : confirmedDeletes) {
            Runnable deleteTask = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String fullPath = ServerConstants.getTablesDir() + delete;
                    log.debug((Object)("Deleting " + fullPath));
                    try {
                        boolean removeFlag;
                        Path p = new Path(fullPath);
                        if (SimpleGarbageCollector.this.moveToTrash(p) || SimpleGarbageCollector.this.fs.delete(p, true)) {
                            removeFlag = true;
                            SimpleGarbageCollector simpleGarbageCollector = SimpleGarbageCollector.this;
                            synchronized (simpleGarbageCollector) {
                                ++((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.deleted;
                            }
                        }
                        if (SimpleGarbageCollector.this.fs.exists(p)) {
                            removeFlag = false;
                            SimpleGarbageCollector simpleGarbageCollector = SimpleGarbageCollector.this;
                            synchronized (simpleGarbageCollector) {
                                ++((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.errors;
                            }
                            log.warn((Object)("File exists, but was not deleted for an unknown reason: " + p));
                        } else {
                            removeFlag = true;
                            SimpleGarbageCollector simpleGarbageCollector = SimpleGarbageCollector.this;
                            synchronized (simpleGarbageCollector) {
                                ++((SimpleGarbageCollector)SimpleGarbageCollector.this).status.current.errors;
                            }
                            String[] parts = delete.split("/");
                            if (parts.length > 2) {
                                String tableId = parts[1];
                                String tabletDir = parts[2];
                                TableManager.getInstance().updateTableStateCache(tableId);
                                TableState tableState = TableManager.getInstance().getTableState(tableId);
                                if (tableState != null && tableState != TableState.DELETING && !tabletDir.startsWith("c-")) {
                                    log.warn((Object)("File doesn't exist: " + p));
                                }
                            } else {
                                log.warn((Object)("Very strange path name: " + delete));
                            }
                        }
                        if (removeFlag && finalWriter != null) {
                            SimpleGarbageCollector.putMarkerDeleteMutation(delete, finalWriter, finalRootWriter);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
            };
            deleteThreadPool.execute(deleteTask);
        }
        deleteThreadPool.shutdown();
        try {
            while (!deleteThreadPool.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (InterruptedException e1) {
            log.error((Object)e1, (Throwable)e1);
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (MutationsRejectedException e) {
                log.error((Object)"Problem removing entries from the metadata table: ", (Throwable)e);
            }
        }
        if (rootWriter != null) {
            try {
                rootWriter.close();
            }
            catch (MutationsRejectedException e) {
                log.error((Object)"Problem removing entries from the metadata table: ", (Throwable)e);
            }
        }
    }

    private boolean isDir(String delete) {
        int slashCount = 0;
        for (int i = 0; i < delete.length(); ++i) {
            if (delete.charAt(i) != '/') continue;
            ++slashCount;
        }
        return slashCount == 2;
    }

    public GCStatus getStatus(TInfo info, TCredentials credentials) {
        return this.status;
    }

    static class Opts
    extends Help {
        @Parameter(names={"-v", "--verbose"}, description="extra information will get printed to stdout also")
        boolean verbose = false;
        @Parameter(names={"-s", "--safemode"}, description="safe mode will not delete files")
        boolean safeMode = false;
        @Parameter(names={"-o", "--offline"}, description="offline mode will run once and check data files directly; this is dangerous if accumulo is running or not shut down properly")
        boolean offline = false;
        @Parameter(names={"-a", "--address"}, description="specify our local address")
        String address = null;

        Opts() {
        }
    }
}

