/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.recovery;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.recovery.HadoopLogCloser;
import org.apache.accumulo.server.master.recovery.LogCloser;
import org.apache.accumulo.server.trace.TraceFileSystem;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;

public class RecoveryManager {
    private static Logger log = Logger.getLogger(RecoveryManager.class);
    private Map<String, Long> recoveryDelay = new HashMap<String, Long>();
    private Set<String> closeTasksQueued = new HashSet<String>();
    private Set<String> sortsQueued = new HashSet<String>();
    private ScheduledExecutorService executor;
    private Master master;
    private ZooCache zooCache;

    public RecoveryManager(Master master) {
        this.master = master;
        this.executor = Executors.newScheduledThreadPool(4, (ThreadFactory)new NamingThreadFactory("Walog sort starter "));
        this.zooCache = new ZooCache();
        try {
            List<String> workIDs = new DistributedWorkQueue(ZooUtil.getRoot((Instance)master.getInstance()) + "/recovery").getWorkQueued();
            this.sortsQueued.addAll(workIDs);
        }
        catch (Exception e) {
            log.warn((Object)e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateSort(String host, String file) throws KeeperException, InterruptedException {
        String source = this.getSource(host, file).toString();
        new DistributedWorkQueue(ZooUtil.getRoot((Instance)this.master.getInstance()) + "/recovery").addWork(file, source.getBytes());
        RecoveryManager recoveryManager = this;
        synchronized (recoveryManager) {
            this.sortsQueued.add(file);
        }
        String path = ZooUtil.getRoot((Instance)this.master.getInstance()) + "/recovery" + "/" + file;
        log.info((Object)("Created zookeeper entry " + path + " with data " + source));
    }

    private Path getSource(String server, String file) {
        String source = Constants.getWalDirectory((AccumuloConfiguration)this.master.getSystemConfiguration()) + "/" + server + "/" + file;
        if (server.contains(":")) {
            source = Constants.getWalDirectory((AccumuloConfiguration)this.master.getSystemConfiguration()) + "/" + file;
        }
        return new Path(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recoverLogs(KeyExtent extent, Collection<Collection<String>> walogs) throws IOException {
        boolean recoveryNeeded = false;
        for (Collection<String> logs : walogs) {
            for (String walog : logs) {
                boolean sortQueued;
                String[] parts = walog.split("/");
                String host = parts[0];
                String filename = parts[1];
                RecoveryManager recoveryManager = this;
                synchronized (recoveryManager) {
                    sortQueued = this.sortsQueued.contains(filename);
                }
                if (sortQueued && this.zooCache.get(ZooUtil.getRoot((Instance)this.master.getInstance()) + "/recovery" + "/" + filename) == null) {
                    recoveryManager = this;
                    synchronized (recoveryManager) {
                        this.sortsQueued.remove(filename);
                    }
                }
                if (this.master.getFileSystem().exists(new Path(Constants.getRecoveryDir((AccumuloConfiguration)this.master.getSystemConfiguration()) + "/" + filename + "/finished"))) {
                    recoveryManager = this;
                    synchronized (recoveryManager) {
                        this.closeTasksQueued.remove(filename);
                        this.recoveryDelay.remove(filename);
                        this.sortsQueued.remove(filename);
                        continue;
                    }
                }
                recoveryNeeded = true;
                recoveryManager = this;
                synchronized (recoveryManager) {
                    if (!this.closeTasksQueued.contains(filename) && !this.sortsQueued.contains(filename)) {
                        AccumuloConfiguration aconf = this.master.getConfiguration().getConfiguration();
                        LogCloser closer = Master.createInstanceFromPropertyName(aconf, Property.MASTER_WALOG_CLOSER_IMPLEMETATION, LogCloser.class, new HadoopLogCloser());
                        Long delay = this.recoveryDelay.get(filename);
                        delay = delay == null ? Long.valueOf(this.master.getSystemConfiguration().getTimeInMillis(Property.MASTER_RECOVERY_DELAY)) : Long.valueOf(Math.min(2L * delay, 300000L));
                        log.info((Object)("Starting recovery of " + filename + " (in : " + delay / 1000L + "s) created for " + host + ", tablet " + extent + " holds a reference"));
                        this.executor.schedule(new LogSortTask(closer, host, filename), (long)delay, TimeUnit.MILLISECONDS);
                        this.closeTasksQueued.add(filename);
                        this.recoveryDelay.put(filename, delay);
                    }
                }
            }
        }
        return recoveryNeeded;
    }

    private class LogSortTask
    implements Runnable {
        private String filename;
        private String host;
        private LogCloser closer;

        public LogSortTask(LogCloser closer, String host, String filename) {
            this.closer = closer;
            this.host = host;
            this.filename = filename;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean rescheduled = false;
            try {
                long time;
                Object localFs = RecoveryManager.this.master.getFileSystem();
                if (localFs instanceof TraceFileSystem) {
                    localFs = ((TraceFileSystem)((Object)localFs)).getImplementation();
                }
                if ((time = this.closer.close(RecoveryManager.this.master, (FileSystem)localFs, RecoveryManager.this.getSource(this.host, this.filename))) > 0L) {
                    RecoveryManager.this.executor.schedule(this, time, TimeUnit.MILLISECONDS);
                    rescheduled = true;
                } else {
                    RecoveryManager.this.initiateSort(this.host, this.filename);
                }
            }
            catch (FileNotFoundException e) {
                log.debug((Object)("Unable to initate log sort for " + this.filename + ": " + e));
            }
            catch (Exception e) {
                log.warn((Object)("Failed to initiate log sort " + this.filename), (Throwable)e);
            }
            finally {
                if (!rescheduled) {
                    RecoveryManager e = RecoveryManager.this;
                    synchronized (e) {
                        RecoveryManager.this.closeTasksQueued.remove(this.filename);
                    }
                }
            }
        }
    }
}

