/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.tabletserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.blockfile.cache.BlockCache;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.InterruptibleIterator;
import org.apache.accumulo.core.iterators.system.SourceSwitchingIterator;
import org.apache.accumulo.core.iterators.system.TimeSettingIterator;
import org.apache.accumulo.core.util.MetadataTable;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReportingIterator;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.tabletserver.TooManyFilesException;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class FileManager {
    private static final Logger log = Logger.getLogger(FileManager.class);
    int maxOpen;
    private Map<String, List<OpenReader>> openFiles;
    private HashMap<FileSKVIterator, String> reservedReaders;
    private Semaphore filePermits;
    private FileSystem fs;
    private BlockCache dataCache = null;
    private BlockCache indexCache = null;
    private long maxIdleTime;
    private final ServerConfiguration conf;

    FileManager(ServerConfiguration conf, FileSystem fs, int maxOpen, BlockCache dataCache, BlockCache indexCache) {
        if (maxOpen <= 0) {
            throw new IllegalArgumentException("maxOpen <= 0");
        }
        this.conf = conf;
        this.dataCache = dataCache;
        this.indexCache = indexCache;
        this.filePermits = new Semaphore(maxOpen, true);
        this.maxOpen = maxOpen;
        this.fs = fs;
        this.openFiles = new HashMap<String, List<OpenReader>>();
        this.reservedReaders = new HashMap();
        this.maxIdleTime = conf.getConfiguration().getTimeInMillis(Property.TSERV_MAX_IDLE);
        SimpleTimer.getInstance().schedule(new IdleFileCloser(), this.maxIdleTime, this.maxIdleTime / 2L);
    }

    private static int countReaders(Map<String, List<OpenReader>> files) {
        int count = 0;
        for (List<OpenReader> list : files.values()) {
            count += list.size();
        }
        return count;
    }

    private List<FileSKVIterator> takeLRUOpenFiles(int numToTake) {
        ArrayList openReaders = new ArrayList();
        for (Map.Entry<String, List<OpenReader>> entry : this.openFiles.entrySet()) {
            openReaders.addAll(entry.getValue());
        }
        Collections.sort(openReaders);
        ArrayList<FileSKVIterator> ret = new ArrayList<FileSKVIterator>();
        for (int i = 0; i < numToTake; ++i) {
            OpenReader or = (OpenReader)openReaders.get(i);
            List<OpenReader> ofl = this.openFiles.get(or.fileName);
            if (!ofl.remove(or)) {
                throw new RuntimeException("Failed to remove open reader that should have been there");
            }
            if (ofl.size() == 0) {
                this.openFiles.remove(or.fileName);
            }
            ret.add(or.reader);
        }
        return ret;
    }

    private static <T> List<T> getFileList(String file, Map<String, List<T>> files) {
        List<T> ofl = files.get(file);
        if (ofl == null) {
            ofl = new ArrayList<T>();
            files.put(file, ofl);
        }
        return ofl;
    }

    private void closeReaders(List<FileSKVIterator> filesToClose) {
        for (FileSKVIterator reader : filesToClose) {
            try {
                reader.close();
            }
            catch (Exception e) {
                log.error((Object)("Failed to close file " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private List<String> takeOpenFiles(Collection<String> files, List<FileSKVIterator> reservedFiles, Map<FileSKVIterator, String> readersReserved) {
        LinkedList<String> filesToOpen = new LinkedList<String>(files);
        Iterator iterator = filesToOpen.iterator();
        while (iterator.hasNext()) {
            String file = (String)iterator.next();
            List<OpenReader> ofl = this.openFiles.get(file);
            if (ofl == null || ofl.size() <= 0) continue;
            OpenReader openReader = ofl.remove(ofl.size() - 1);
            reservedFiles.add(openReader.reader);
            readersReserved.put(openReader.reader, file);
            if (ofl.size() == 0) {
                this.openFiles.remove(file);
            }
            iterator.remove();
        }
        return filesToOpen;
    }

    private synchronized String getReservedReadeFilename(FileSKVIterator reader) {
        return this.reservedReaders.get(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FileSKVIterator> reserveReaders(Text table, Collection<String> files, boolean continueOnFailure) throws IOException {
        if (files.size() >= this.maxOpen) {
            throw new IllegalArgumentException("requested files exceeds max open");
        }
        if (files.size() == 0) {
            return Collections.emptyList();
        }
        List<String> filesToOpen = null;
        List<FileSKVIterator> filesToClose = Collections.emptyList();
        ArrayList<FileSKVIterator> reservedFiles = new ArrayList<FileSKVIterator>();
        HashMap<FileSKVIterator, String> readersReserved = new HashMap<FileSKVIterator, String>();
        this.filePermits.acquireUninterruptibly(files.size());
        FileManager fileManager = this;
        synchronized (fileManager) {
            filesToOpen = this.takeOpenFiles(files, reservedFiles, readersReserved);
            int numOpen = FileManager.countReaders(this.openFiles);
            if (filesToOpen.size() + numOpen + this.reservedReaders.size() > this.maxOpen) {
                filesToClose = this.takeLRUOpenFiles(filesToOpen.size() + numOpen + this.reservedReaders.size() - this.maxOpen);
            }
        }
        this.closeReaders(filesToClose);
        for (String file : filesToOpen) {
            try {
                FileSKVIterator reader = FileOperations.getInstance().openReader(file, false, this.fs, this.fs.getConf(), (AccumuloConfiguration)this.conf.getTableConfiguration(table.toString()), this.dataCache, this.indexCache);
                reservedFiles.add(reader);
                readersReserved.put(reader, file);
            }
            catch (Exception e) {
                ProblemReports.getInstance().report(new ProblemReport(table.toString(), ProblemType.FILE_READ, file, e));
                if (continueOnFailure) {
                    this.filePermits.release(1);
                    log.warn((Object)("Failed to open file " + file + " " + e.getMessage() + " continuing..."));
                    continue;
                }
                this.closeReaders(reservedFiles);
                this.filePermits.release(files.size());
                log.error((Object)("Failed to open file " + file + " " + e.getMessage()));
                throw new IOException("Failed to open " + file, e);
            }
        }
        fileManager = this;
        synchronized (fileManager) {
            this.reservedReaders.putAll(readersReserved);
        }
        return reservedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseReaders(List<FileSKVIterator> readers, boolean sawIOException) {
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (!this.reservedReaders.keySet().containsAll(readers)) {
                throw new IllegalArgumentException("Asked to release readers that were never reserved ");
            }
            for (FileSKVIterator reader : readers) {
                try {
                    reader.closeDeepCopies();
                }
                catch (IOException e) {
                    log.warn((Object)e, (Throwable)e);
                    sawIOException = true;
                }
            }
            for (FileSKVIterator reader : readers) {
                String fileName = this.reservedReaders.remove(reader);
                if (sawIOException) continue;
                FileManager.getFileList(fileName, this.openFiles).add(new OpenReader(fileName, reader));
            }
        }
        if (sawIOException) {
            this.closeReaders(readers);
        }
        this.filePermits.release(readers.size());
    }

    public ScanFileManager newScanFileManager(KeyExtent tablet) {
        return new ScanFileManager(tablet);
    }

    public class ScanFileManager {
        private ArrayList<FileDataSource> dataSources;
        private ArrayList<FileSKVIterator> tabletReservedReaders = new ArrayList();
        private KeyExtent tablet;
        private boolean continueOnFailure;

        ScanFileManager(KeyExtent tablet) {
            this.dataSources = new ArrayList();
            this.tablet = tablet;
            this.continueOnFailure = FileManager.this.conf.getTableConfiguration(tablet).getBoolean(Property.TABLE_FAILURES_IGNORE);
            if (tablet.isMeta()) {
                this.continueOnFailure = false;
            }
        }

        private List<FileSKVIterator> openFiles(Collection<String> files) throws TooManyFilesException, IOException {
            if (this.tabletReservedReaders.size() + files.size() >= FileManager.this.maxOpen) {
                throw new TooManyFilesException("Request to open files would exceed max open files reservedReaders.size()=" + this.tabletReservedReaders.size() + " files.size()=" + files.size() + " maxOpen=" + FileManager.this.maxOpen + " tablet = " + this.tablet);
            }
            List newlyReservedReaders = FileManager.this.reserveReaders(this.tablet.getTableId(), files, this.continueOnFailure);
            this.tabletReservedReaders.addAll(newlyReservedReaders);
            return newlyReservedReaders;
        }

        synchronized List<InterruptibleIterator> openFiles(Map<String, MetadataTable.DataFileValue> files, boolean detachable) throws IOException {
            List<FileSKVIterator> newlyReservedReaders = this.openFiles(files.keySet());
            ArrayList<InterruptibleIterator> iters = new ArrayList<InterruptibleIterator>();
            for (FileSKVIterator reader : newlyReservedReaders) {
                ProblemReportingIterator iter;
                String filename = FileManager.this.getReservedReadeFilename(reader);
                if (detachable) {
                    FileDataSource fds = new FileDataSource(filename, (SortedKeyValueIterator<Key, Value>)reader);
                    this.dataSources.add(fds);
                    SourceSwitchingIterator ssi = new SourceSwitchingIterator((SourceSwitchingIterator.DataSource)fds);
                    iter = new ProblemReportingIterator(this.tablet.getTableId().toString(), filename, this.continueOnFailure, (SortedKeyValueIterator<Key, Value>)ssi);
                } else {
                    iter = new ProblemReportingIterator(this.tablet.getTableId().toString(), filename, this.continueOnFailure, (SortedKeyValueIterator<Key, Value>)reader);
                }
                if (files.get(filename).isTimeSet()) {
                    iter = new TimeSettingIterator((SortedKeyValueIterator)iter, files.get(filename).getTime());
                }
                iters.add(iter);
            }
            return iters;
        }

        synchronized void detach() {
            FileManager.this.releaseReaders(this.tabletReservedReaders, false);
            this.tabletReservedReaders.clear();
            for (FileDataSource fds : this.dataSources) {
                fds.unsetIterator();
            }
        }

        synchronized void reattach() throws IOException {
            if (this.tabletReservedReaders.size() != 0) {
                throw new IllegalStateException();
            }
            ArrayList<String> files = new ArrayList<String>();
            for (FileDataSource fds : this.dataSources) {
                files.add(fds.file);
            }
            List<FileSKVIterator> newlyReservedReaders = this.openFiles(files);
            HashMap<String, LinkedList<FileSKVIterator>> map = new HashMap<String, LinkedList<FileSKVIterator>>();
            for (FileSKVIterator reader : newlyReservedReaders) {
                String fileName = FileManager.this.getReservedReadeFilename(reader);
                LinkedList<FileSKVIterator> list = (LinkedList<FileSKVIterator>)map.get(fileName);
                if (list == null) {
                    list = new LinkedList<FileSKVIterator>();
                    map.put(fileName, list);
                }
                list.add(reader);
            }
            for (FileDataSource fds : this.dataSources) {
                FileSKVIterator reader = (FileSKVIterator)((List)map.get(fds.file)).remove(0);
                fds.setIterator((SortedKeyValueIterator<Key, Value>)reader);
            }
        }

        synchronized void releaseOpenFiles(boolean sawIOException) {
            FileManager.this.releaseReaders(this.tabletReservedReaders, sawIOException);
            this.tabletReservedReaders.clear();
            this.dataSources.clear();
        }

        synchronized int getNumOpenFiles() {
            return this.tabletReservedReaders.size();
        }
    }

    static class FileDataSource
    implements SourceSwitchingIterator.DataSource {
        private SortedKeyValueIterator<Key, Value> iter;
        private ArrayList<FileDataSource> deepCopies;
        private boolean current = true;
        private IteratorEnvironment env;
        private String file;

        FileDataSource(String file, SortedKeyValueIterator<Key, Value> iter) {
            this.file = file;
            this.iter = iter;
            this.deepCopies = new ArrayList();
        }

        public FileDataSource(IteratorEnvironment env, SortedKeyValueIterator<Key, Value> deepCopy, ArrayList<FileDataSource> deepCopies) {
            this.iter = deepCopy;
            this.env = env;
            this.deepCopies = deepCopies;
            deepCopies.add(this);
        }

        public boolean isCurrent() {
            return this.current;
        }

        public SourceSwitchingIterator.DataSource getNewDataSource() {
            this.current = true;
            return this;
        }

        public SourceSwitchingIterator.DataSource getDeepCopyDataSource(IteratorEnvironment env) {
            return new FileDataSource(env, (SortedKeyValueIterator<Key, Value>)this.iter.deepCopy(env), this.deepCopies);
        }

        public SortedKeyValueIterator<Key, Value> iterator() throws IOException {
            return this.iter;
        }

        void unsetIterator() {
            this.current = false;
            this.iter = null;
            for (FileDataSource fds : this.deepCopies) {
                fds.current = false;
                fds.iter = null;
            }
        }

        void setIterator(SortedKeyValueIterator<Key, Value> iter) {
            this.current = false;
            this.iter = iter;
            for (FileDataSource fds : this.deepCopies) {
                fds.current = false;
                fds.iter = iter.deepCopy(fds.env);
            }
        }
    }

    private class IdleFileCloser
    implements Runnable {
        private IdleFileCloser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long curTime = System.currentTimeMillis();
            ArrayList<FileSKVIterator> filesToClose = new ArrayList<FileSKVIterator>();
            FileManager fileManager = FileManager.this;
            synchronized (fileManager) {
                Iterator iter = FileManager.this.openFiles.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    List ofl = (List)entry.getValue();
                    Iterator oflIter = ofl.iterator();
                    while (oflIter.hasNext()) {
                        OpenReader openReader = (OpenReader)oflIter.next();
                        if (curTime - openReader.releaseTime <= FileManager.this.maxIdleTime) continue;
                        filesToClose.add(openReader.reader);
                        oflIter.remove();
                    }
                    if (ofl.size() != 0) continue;
                    iter.remove();
                }
            }
            FileManager.this.closeReaders(filesToClose);
        }
    }

    private static class OpenReader
    implements Comparable<OpenReader> {
        long releaseTime;
        FileSKVIterator reader;
        String fileName;

        public OpenReader(String fileName, FileSKVIterator reader) {
            this.fileName = fileName;
            this.reader = reader;
            this.releaseTime = System.currentTimeMillis();
        }

        @Override
        public int compareTo(OpenReader o) {
            if (this.releaseTime < o.releaseTime) {
                return -1;
            }
            if (this.releaseTime > o.releaseTime) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OpenReader) {
                return this.compareTo((OpenReader)obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            return this.fileName.hashCode();
        }
    }
}

