/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class DumpZookeeper {
    static IZooReaderWriter zk = null;
    private static final Logger log = Logger.getLogger(DumpZookeeper.class);

    public static void main(String[] args) {
        Opts opts = new Opts();
        opts.parseArgs(DumpZookeeper.class.getName(), args, new Object[0]);
        Logger.getRootLogger().setLevel(Level.WARN);
        PrintStream out = System.out;
        if (args.length > 0) {
            opts.root = args[0];
        }
        try {
            zk = ZooReaderWriter.getInstance();
            DumpZookeeper.write(out, 0, "<dump root='%s'>", opts.root);
            for (String child : zk.getChildren(opts.root, null)) {
                if (child.equals("zookeeper")) continue;
                DumpZookeeper.dump(out, opts.root, child, 1);
            }
            DumpZookeeper.write(out, 0, "</dump>", new Object[0]);
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
    }

    private static void dump(PrintStream out, String root, String child, int indent) throws KeeperException, InterruptedException, UnsupportedEncodingException {
        Stat stat;
        String path = root + "/" + child;
        if (root.endsWith("/")) {
            path = root + child;
        }
        if ((stat = zk.getStatus(path)) == null) {
            return;
        }
        String type = "node";
        if (stat.getEphemeralOwner() != 0L) {
            type = "ephemeral";
        }
        if (stat.getNumChildren() == 0) {
            if (stat.getDataLength() == 0) {
                DumpZookeeper.write(out, indent, "<%s name='%s'/>", type, child);
            } else {
                Encoded value = DumpZookeeper.value(path);
                DumpZookeeper.write(out, indent, "<%s name='%s' encoding='%s' value='%s'/>", type, child, value.encoding, value.value);
            }
        } else {
            if (stat.getDataLength() == 0) {
                DumpZookeeper.write(out, indent, "<%s name='%s'>", type, child);
            } else {
                Encoded value = DumpZookeeper.value(path);
                DumpZookeeper.write(out, indent, "<%s name='%s' encoding='%s' value='%s'>", type, child, value.encoding, value.value);
            }
            for (String c : zk.getChildren(path, null)) {
                DumpZookeeper.dump(out, path, c, indent + 1);
            }
            DumpZookeeper.write(out, indent, "</node>", new Object[0]);
        }
    }

    private static Encoded value(String path) throws KeeperException, InterruptedException, UnsupportedEncodingException {
        byte[] data = zk.getData(path, null);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] >= 32 && data[i] <= 126) continue;
            return new Encoded("base64", new String(Base64.encodeBase64((byte[])data), "utf8"));
        }
        return new Encoded("utf8", new String(data, "utf8"));
    }

    private static void write(PrintStream out, int indent, String fmt, Object ... args) {
        for (int i = 0; i < indent; ++i) {
            out.print(" ");
        }
        out.println(String.format(fmt, args));
    }

    static class Opts
    extends Help {
        @Parameter(names={"--root"}, description="the root of the znode tree to dump")
        String root = "/";

        Opts() {
        }
    }

    private static class Encoded {
        public String encoding;
        public String value;

        Encoded(String e, String v) {
            this.encoding = e;
            this.value = v;
        }
    }
}

