/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

public class MapCounter<KT> {
    private HashMap<KT, MutableLong> map = new HashMap();

    public long increment(KT key, long l) {
        MutableLong ml = this.map.get(key);
        if (ml == null) {
            ml = new MutableLong();
            this.map.put(key, ml);
        }
        ml.l += l;
        if (ml.l == 0L) {
            this.map.remove(key);
        }
        return ml.l;
    }

    public long decrement(KT key, long l) {
        return this.increment(key, -1L * l);
    }

    public boolean contains(KT key) {
        return this.map.containsKey(key);
    }

    public long get(KT key) {
        MutableLong ml = this.map.get(key);
        if (ml == null) {
            return 0L;
        }
        return ml.l;
    }

    public Set<KT> keySet() {
        return this.map.keySet();
    }

    public Collection<Long> values() {
        Collection<MutableLong> vals = this.map.values();
        ArrayList<Long> ret = new ArrayList<Long>(vals.size());
        for (MutableLong ml : vals) {
            ret.add(ml.l);
        }
        return ret;
    }

    public int size() {
        return this.map.size();
    }

    static class MutableLong {
        long l = 0L;

        MutableLong() {
        }
    }
}

