/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions;

import junit.extensions.TestDecorator;
import junit.framework.Test;
import junit.framework.TestResult;

public class RepeatedTest
extends TestDecorator {
    private int fTimesRepeat;

    public RepeatedTest(Test test, int n) {
        super(test);
        this.fTimesRepeat = n;
    }

    public int countTestCases() {
        return super.countTestCases() * this.fTimesRepeat;
    }

    public void run(TestResult testResult) {
        int n = 0;
        while (n < this.fTimesRepeat) {
            if (testResult.shouldStop()) break;
            super.run(testResult);
            ++n;
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + "(repeated)";
    }
}

