/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import junit.framework.AssertionFailedError;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Assert {
    protected Assert() {
    }

    public static void assert(String string, boolean bl) {
        if (!bl) {
            Assert.fail(string);
        }
    }

    public static void assert(boolean bl) {
        Assert.assert(null, bl);
    }

    public static void assertEquals(double d, double d2, double d3) {
        Assert.assertEquals(null, d, d2, d3);
    }

    public static void assertEquals(long l, long l2) {
        Assert.assertEquals(null, l, l2);
    }

    public static void assertEquals(Object object, Object object2) {
        Assert.assertEquals(null, object, object2);
    }

    public static void assertEquals(String string, double d, double d2, double d3) {
        if (Math.abs(d - d2) > d3) {
            Assert.failNotEquals(string, new Double(d), new Double(d2));
        }
    }

    public static void assertEquals(String string, long l, long l2) {
        Assert.assertEquals(string, new Long(l), new Long(l2));
    }

    public static void assertEquals(String string, Object object, Object object2) {
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && object.equals(object2)) {
            return;
        }
        Assert.failNotEquals(string, object, object2);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(null, object);
    }

    public static void assertNotNull(String string, Object object) {
        Assert.assert(string, object != null);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(null, object);
    }

    public static void assertNull(String string, Object object) {
        Assert.assert(string, object == null);
    }

    public static void assertSame(Object object, Object object2) {
        Assert.assertSame(null, object, object2);
    }

    public static void assertSame(String string, Object object, Object object2) {
        if (object == object2) {
            return;
        }
        Assert.failNotSame(string, object, object2);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void fail(String string) {
        throw new AssertionFailedError(string);
    }

    private static void failNotEquals(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null) {
            string2 = String.valueOf(string) + " ";
        }
        Assert.fail(String.valueOf(string2) + "expected:<" + object + "> but was:<" + object2 + ">");
    }

    private static void failNotSame(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null) {
            string2 = String.valueOf(string) + " ";
        }
        Assert.fail(String.valueOf(string2) + "expected same");
    }
}

