/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.StringBuilder;

public final class SparkCuratorUtil$
implements Logging {
    public static final SparkCuratorUtil$ MODULE$;
    private final int ZK_CONNECTION_TIMEOUT_MILLIS;
    private final int ZK_SESSION_TIMEOUT_MILLIS;
    private final int RETRY_WAIT_MILLIS;
    private final int MAX_RECONNECT_ATTEMPTS;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkCuratorUtil$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging$class.initializeLogIfNecessary(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging$class.initializeLogIfNecessary$default$2(this);
    }

    private int ZK_CONNECTION_TIMEOUT_MILLIS() {
        return this.ZK_CONNECTION_TIMEOUT_MILLIS;
    }

    private int ZK_SESSION_TIMEOUT_MILLIS() {
        return this.ZK_SESSION_TIMEOUT_MILLIS;
    }

    private int RETRY_WAIT_MILLIS() {
        return this.RETRY_WAIT_MILLIS;
    }

    private int MAX_RECONNECT_ATTEMPTS() {
        return this.MAX_RECONNECT_ATTEMPTS;
    }

    public CuratorFramework newClient(SparkConf conf, String zkUrlConf) {
        String ZK_URL = conf.get(zkUrlConf);
        CuratorFramework zk = CuratorFrameworkFactory.newClient((String)ZK_URL, (int)this.ZK_SESSION_TIMEOUT_MILLIS(), (int)this.ZK_CONNECTION_TIMEOUT_MILLIS(), (RetryPolicy)new ExponentialBackoffRetry(this.RETRY_WAIT_MILLIS(), this.MAX_RECONNECT_ATTEMPTS()));
        zk.start();
        return zk;
    }

    public String newClient$default$2() {
        return "spark.deploy.zookeeper.url";
    }

    public void mkdir(CuratorFramework zk, String path) {
        if (zk.checkExists().forPath(path) == null) {
            try {
                zk.create().creatingParentsIfNeeded().forPath(path);
            }
            catch (Exception exception2) {
                throw exception2;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
    }

    public void deleteRecursive(CuratorFramework zk, String path) {
        if (zk.checkExists().forPath(path) != null) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)zk.getChildren().forPath(path)).asScala()).foreach((Function1)new Serializable(zk, path){
                public static final long serialVersionUID = 0L;
                private final CuratorFramework zk$1;
                private final String path$1;

                public final Void apply(String child) {
                    return (Void)this.zk$1.delete().forPath(new StringBuilder().append((Object)this.path$1).append((Object)"/").append((Object)child).toString());
                }
                {
                    this.zk$1 = zk$1;
                    this.path$1 = path$1;
                }
            });
            zk.delete().forPath(path);
        }
    }

    private SparkCuratorUtil$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ZK_CONNECTION_TIMEOUT_MILLIS = 15000;
        this.ZK_SESSION_TIMEOUT_MILLIS = 60000;
        this.RETRY_WAIT_MILLIS = 5000;
        this.MAX_RECONNECT_ATTEMPTS = 3;
    }
}

