/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.clplog;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.plugin.inputformat.clplog.CLPLogRecordExtractor;
import org.apache.pinot.plugin.inputformat.clplog.CLPLogRecordExtractorConfig;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordExtractor;
import org.apache.pinot.spi.data.readers.RecordExtractorConfig;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.stream.StreamMessageDecoder;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLPLogMessageDecoder
implements StreamMessageDecoder<byte[]> {
    public static final String ERROR_SAMPLING_PERIOD_CONFIG_KEY = "errorSamplingPeriod";
    private static final Logger LOGGER = LoggerFactory.getLogger(CLPLogMessageDecoder.class);
    private static final int DEFAULT_ERROR_SAMPLING_PERIOD = 10000;
    private final ServerMetrics _serverMetrics = ServerMetrics.get();
    private RecordExtractor<Map<String, Object>> _recordExtractor;
    private int _errorSamplingPeriod = 10000;
    private int _numErrorsUntilNextPrint = 0;

    public void init(Map<String, String> props, Set<String> fieldsToRead, String topicName) throws Exception {
        String recordExtractorClass = null;
        String recordExtractorConfigClass = null;
        String errorSamplingPeriodString = null;
        if (null != props) {
            recordExtractorClass = props.get("recordExtractorClass");
            recordExtractorConfigClass = props.get("recordExtractorConfigClass");
            errorSamplingPeriodString = props.get(ERROR_SAMPLING_PERIOD_CONFIG_KEY);
        }
        if (null == recordExtractorClass) {
            recordExtractorClass = CLPLogRecordExtractor.class.getName();
            recordExtractorConfigClass = CLPLogRecordExtractorConfig.class.getName();
        }
        this._recordExtractor = (RecordExtractor)PluginManager.get().createInstance(recordExtractorClass);
        RecordExtractorConfig config = (RecordExtractorConfig)PluginManager.get().createInstance(recordExtractorConfigClass);
        config.init(props);
        if (this._recordExtractor instanceof CLPLogRecordExtractor) {
            ((CLPLogRecordExtractor)this._recordExtractor).init(fieldsToRead, config, topicName, this._serverMetrics);
        } else {
            this._recordExtractor.init(fieldsToRead, config);
        }
        if (null != errorSamplingPeriodString) {
            try {
                this._errorSamplingPeriod = Integer.parseInt(errorSamplingPeriodString);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Could not parse errorSamplingPeriod");
            }
            if (this._errorSamplingPeriod < 0) {
                LOGGER.error("errorSamplingPeriod cannot be less than 0");
                this._errorSamplingPeriod = 10000;
            }
        }
    }

    public GenericRow decode(byte[] payload, GenericRow destination) {
        try {
            JsonNode message = JsonUtils.bytesToJsonNode((byte[])payload);
            Map from = JsonUtils.jsonNodeToMap((JsonNode)message);
            this._recordExtractor.extract((Object)from, destination);
            return destination;
        }
        catch (Exception e) {
            if (0 != this._errorSamplingPeriod) {
                --this._numErrorsUntilNextPrint;
                if (0 == this._numErrorsUntilNextPrint) {
                    LOGGER.error("Caught exception while decoding row, discarding row. Payload is {}", (Object)new String(payload), (Object)e);
                    this._numErrorsUntilNextPrint = this._errorSamplingPeriod;
                }
            }
            return null;
        }
    }

    public GenericRow decode(byte[] payload, int offset, int length, GenericRow destination) {
        return this.decode(Arrays.copyOfRange(payload, offset, offset + length), destination);
    }
}

