/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.util.ArrayList;
import org.apache.kafka.common.metadata.QuotaRecord;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.BooleanNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.DoubleNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.NullNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.TextNode;

public class QuotaRecordJsonConverter {
    public static QuotaRecord read(JsonNode _node, short _version) {
        QuotaRecord _object = new QuotaRecord();
        JsonNode _entityNode = _node.get("entity");
        if (_entityNode == null) {
            throw new RuntimeException("QuotaRecord: unable to locate field 'entity', which is mandatory in version " + _version);
        }
        if (!_entityNode.isArray()) {
            throw new RuntimeException("QuotaRecord expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
        }
        ArrayList<QuotaRecord.EntityData> _collection = new ArrayList<QuotaRecord.EntityData>(_entityNode.size());
        _object.entity = _collection;
        for (JsonNode _element : _entityNode) {
            _collection.add(EntityDataJsonConverter.read(_element, _version));
        }
        JsonNode _keyNode = _node.get("key");
        if (_keyNode == null) {
            throw new RuntimeException("QuotaRecord: unable to locate field 'key', which is mandatory in version " + _version);
        }
        if (!_keyNode.isTextual()) {
            throw new RuntimeException("QuotaRecord expected a string type, but got " + (Object)((Object)_node.getNodeType()));
        }
        _object.key = _keyNode.asText();
        JsonNode _valueNode = _node.get("value");
        if (_valueNode == null) {
            throw new RuntimeException("QuotaRecord: unable to locate field 'value', which is mandatory in version " + _version);
        }
        _object.value = MessageUtil.jsonNodeToDouble(_valueNode, "QuotaRecord");
        JsonNode _removeNode = _node.get("remove");
        if (_removeNode == null) {
            throw new RuntimeException("QuotaRecord: unable to locate field 'remove', which is mandatory in version " + _version);
        }
        if (!_removeNode.isBoolean()) {
            throw new RuntimeException("QuotaRecord expected Boolean type, but got " + (Object)((Object)_node.getNodeType()));
        }
        _object.remove = _removeNode.asBoolean();
        return _object;
    }

    public static JsonNode write(QuotaRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _entityArray = new ArrayNode(JsonNodeFactory.instance);
        for (QuotaRecord.EntityData _element : _object.entity) {
            _entityArray.add(EntityDataJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("entity", _entityArray);
        _node.set("key", new TextNode(_object.key));
        _node.set("value", new DoubleNode(_object.value));
        _node.set("remove", BooleanNode.valueOf(_object.remove));
        return _node;
    }

    public static JsonNode write(QuotaRecord _object, short _version) {
        return QuotaRecordJsonConverter.write(_object, _version, true);
    }

    public static class EntityDataJsonConverter {
        public static QuotaRecord.EntityData read(JsonNode _node, short _version) {
            QuotaRecord.EntityData _object = new QuotaRecord.EntityData();
            JsonNode _entityTypeNode = _node.get("entityType");
            if (_entityTypeNode == null) {
                throw new RuntimeException("EntityData: unable to locate field 'entityType', which is mandatory in version " + _version);
            }
            if (!_entityTypeNode.isTextual()) {
                throw new RuntimeException("EntityData expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.entityType = _entityTypeNode.asText();
            JsonNode _entityNameNode = _node.get("entityName");
            if (_entityNameNode == null) {
                throw new RuntimeException("EntityData: unable to locate field 'entityName', which is mandatory in version " + _version);
            }
            if (_entityNameNode.isNull()) {
                _object.entityName = null;
            } else {
                if (!_entityNameNode.isTextual()) {
                    throw new RuntimeException("EntityData expected a string type, but got " + (Object)((Object)_node.getNodeType()));
                }
                _object.entityName = _entityNameNode.asText();
            }
            return _object;
        }

        public static JsonNode write(QuotaRecord.EntityData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("entityType", new TextNode(_object.entityType));
            if (_object.entityName == null) {
                _node.set("entityName", NullNode.instance);
            } else {
                _node.set("entityName", new TextNode(_object.entityName));
            }
            return _node;
        }

        public static JsonNode write(QuotaRecord.EntityData _object, short _version) {
            return EntityDataJsonConverter.write(_object, _version, true);
        }
    }
}

