/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;

public class CreateAclsRequest
extends AbstractRequest {
    private final CreateAclsRequestData data;

    CreateAclsRequest(CreateAclsRequestData data, short version) {
        super(ApiKeys.CREATE_ACLS, version);
        this.validate(data);
        this.data = data;
    }

    public List<CreateAclsRequestData.AclCreation> aclCreations() {
        return this.data.creations();
    }

    @Override
    public CreateAclsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable throwable) {
        CreateAclsResponseData.AclCreationResult result2 = CreateAclsRequest.aclResult(throwable);
        List<CreateAclsResponseData.AclCreationResult> results = Collections.nCopies(this.data.creations().size(), result2);
        return new CreateAclsResponse(new CreateAclsResponseData().setThrottleTimeMs(throttleTimeMs).setResults(results));
    }

    public static CreateAclsRequest parse(ByteBuffer buffer, short version) {
        return new CreateAclsRequest(new CreateAclsRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    private void validate(CreateAclsRequestData data) {
        boolean unsupported;
        if (this.version() == 0 && (unsupported = data.creations().stream().anyMatch(creation -> creation.resourcePatternType() != PatternType.LITERAL.code()))) {
            throw new UnsupportedVersionException("Version 0 only supports literal resource pattern types");
        }
        boolean unknown = data.creations().stream().anyMatch(creation -> creation.resourcePatternType() == PatternType.UNKNOWN.code() || creation.resourceType() == ResourceType.UNKNOWN.code() || creation.permissionType() == AclPermissionType.UNKNOWN.code() || creation.operation() == AclOperation.UNKNOWN.code());
        if (unknown) {
            throw new IllegalArgumentException("CreatableAcls contain unknown elements: " + data.creations());
        }
    }

    public static AclBinding aclBinding(CreateAclsRequestData.AclCreation acl) {
        ResourcePattern pattern = new ResourcePattern(ResourceType.fromCode(acl.resourceType()), acl.resourceName(), PatternType.fromCode(acl.resourcePatternType()));
        AccessControlEntry entry = new AccessControlEntry(acl.principal(), acl.host(), AclOperation.fromCode(acl.operation()), AclPermissionType.fromCode(acl.permissionType()));
        return new AclBinding(pattern, entry);
    }

    public static CreateAclsRequestData.AclCreation aclCreation(AclBinding binding) {
        return new CreateAclsRequestData.AclCreation().setHost(binding.entry().host()).setOperation(binding.entry().operation().code()).setPermissionType(binding.entry().permissionType().code()).setPrincipal(binding.entry().principal()).setResourceName(binding.pattern().name()).setResourceType(binding.pattern().resourceType().code()).setResourcePatternType(binding.pattern().patternType().code());
    }

    private static CreateAclsResponseData.AclCreationResult aclResult(Throwable throwable) {
        ApiError apiError = ApiError.fromThrowable(throwable);
        return new CreateAclsResponseData.AclCreationResult().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message());
    }

    public static class Builder
    extends AbstractRequest.Builder<CreateAclsRequest> {
        private final CreateAclsRequestData data;

        public Builder(CreateAclsRequestData data) {
            super(ApiKeys.CREATE_ACLS);
            this.data = data;
        }

        @Override
        public CreateAclsRequest build(short version) {
            return new CreateAclsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

