/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.jackson;

import io.confluent.kafka.schemaregistry.json.jackson.JSONArrayDeserializer;
import java.io.IOException;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONObjectDeserializer
extends StdDeserializer<JSONObject> {
    private static final long serialVersionUID = 1L;
    public static final JSONObjectDeserializer instance = new JSONObjectDeserializer();

    public JSONObjectDeserializer() {
        super(JSONObject.class);
    }

    @Override
    public JSONObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JSONObject ob = new JSONObject();
        JsonToken t2 = p.getCurrentToken();
        if (t2 == JsonToken.START_OBJECT) {
            t2 = p.nextToken();
        }
        while (t2 == JsonToken.FIELD_NAME) {
            block17: {
                String fieldName = p.getCurrentName();
                t2 = p.nextToken();
                try {
                    switch (t2) {
                        case START_ARRAY: {
                            ob.put(fieldName, JSONArrayDeserializer.instance.deserialize(p, ctxt));
                            break block17;
                        }
                        case START_OBJECT: {
                            ob.put(fieldName, this.deserialize(p, ctxt));
                            break block17;
                        }
                        case VALUE_STRING: {
                            ob.put(fieldName, p.getText());
                            break block17;
                        }
                        case VALUE_NULL: {
                            ob.put(fieldName, JSONObject.NULL);
                            break block17;
                        }
                        case VALUE_TRUE: {
                            ob.put(fieldName, Boolean.TRUE);
                            break block17;
                        }
                        case VALUE_FALSE: {
                            ob.put(fieldName, Boolean.FALSE);
                            break block17;
                        }
                        case VALUE_NUMBER_INT: {
                            Number num = p.getNumberValue();
                            if (num instanceof Byte || num instanceof Short) {
                                num = num.intValue();
                            }
                            ob.put(fieldName, num);
                            break block17;
                        }
                        case VALUE_NUMBER_FLOAT: {
                            ob.put(fieldName, p.getNumberValue());
                            break block17;
                        }
                        case VALUE_EMBEDDED_OBJECT: {
                            Object o = p.getEmbeddedObject();
                            if (o instanceof byte[]) {
                                o = p.getText();
                            }
                            ob.put(fieldName, o);
                            break block17;
                        }
                    }
                }
                catch (JSONException e) {
                    throw ctxt.instantiationException(this.handledType(), e);
                }
                return (JSONObject)ctxt.handleUnexpectedToken(JSONObject.class, p);
            }
            t2 = p.nextToken();
        }
        return ob;
    }
}

