/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava.ser;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.type.WritableTypeId;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ser.PropertyFilter;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ser.std.MapProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import org.apache.pinot.shaded.com.google.common.cache.Cache;

public class CacheSerializer
extends ContainerSerializer<Cache<?, ?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    private final MapLikeType _type;
    private final BeanProperty _property;
    private final JsonSerializer<Object> _keySerializer;
    private final TypeSerializer _valueTypeSerializer;
    private final JsonSerializer<Object> _valueSerializer;
    protected final Set<String> _ignoredEntries;
    protected final Object _filterId;
    protected final boolean _sortKeys;
    protected PropertySerializerMap _dynamicValueSerializers;

    public CacheSerializer(MapLikeType type, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer vts, JsonSerializer<Object> valueSerializer, Set<String> ignoredEntries, Object filterId) {
        super(type.getRawClass(), false);
        this._type = type;
        this._property = null;
        this._keySerializer = keySerializer;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSerializer;
        this._ignoredEntries = ignoredEntries;
        this._filterId = filterId;
        this._sortKeys = false;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
    }

    protected CacheSerializer(CacheSerializer src, BeanProperty property, JsonSerializer<?> keySerializer, TypeSerializer vts, JsonSerializer<?> valueSerializer, Set<String> ignoredEntries, Object filterId, boolean sortKeys) {
        super(src);
        this._type = src._type;
        this._property = property;
        this._keySerializer = keySerializer;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSerializer;
        this._dynamicValueSerializers = src._dynamicValueSerializers;
        this._ignoredEntries = ignoredEntries;
        this._filterId = filterId;
        this._sortKeys = sortKeys;
    }

    protected CacheSerializer withResolved(BeanProperty property, JsonSerializer<?> keySer, TypeSerializer vts, JsonSerializer<?> valueSer, Set<String> ignored, Object filterId, boolean sortKeys) {
        return new CacheSerializer(this, property, keySer, vts, valueSer, ignored, filterId, sortKeys);
    }

    @Override
    protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSer) {
        return new CacheSerializer(this, this._property, this._keySerializer, typeSer, this._valueSerializer, this._ignoredEntries, this._filterId, this._sortKeys);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        Boolean B;
        JsonFormat.Value format;
        JsonSerializer<Object> valueSer = this._valueSerializer;
        if (valueSer == null) {
            JavaType valueType = this._type.getContentType();
            if (valueType.isFinal()) {
                valueSer = provider.findValueSerializer(valueType, property);
            }
        } else if (valueSer instanceof ContextualSerializer) {
            valueSer = ((ContextualSerializer)((Object)valueSer)).createContextual(provider, property);
        }
        AnnotationIntrospector intr = provider.getAnnotationIntrospector();
        AnnotatedMember propertyAcc = property == null ? null : property.getMember();
        JsonSerializer<Object> keySer = null;
        Object filterId = this._filterId;
        if (propertyAcc != null && intr != null) {
            Object serDef = intr.findKeySerializer(propertyAcc);
            if (serDef != null) {
                keySer = provider.serializerInstance(propertyAcc, serDef);
            }
            if ((serDef = intr.findContentSerializer(propertyAcc)) != null) {
                valueSer = provider.serializerInstance(propertyAcc, serDef);
            }
            filterId = intr.findFilterId(propertyAcc);
        }
        if (valueSer == null) {
            valueSer = this._valueSerializer;
        }
        if ((valueSer = this.findContextualConvertingSerializer(provider, property, valueSer)) == null) {
            JavaType valueType = this._type.getContentType();
            if (valueType.useStaticType()) {
                valueSer = provider.findValueSerializer(valueType, property);
            }
        } else {
            valueSer = provider.handleSecondaryContextualization(valueSer, property);
        }
        if (keySer == null) {
            keySer = this._keySerializer;
        }
        keySer = keySer == null ? provider.findKeySerializer(this._type.getKeyType(), property) : provider.handleSecondaryContextualization(keySer, property);
        TypeSerializer typeSer = this._valueTypeSerializer;
        if (typeSer != null) {
            typeSer = typeSer.forProperty(property);
        }
        Set<String> ignored = this._ignoredEntries;
        boolean sortKeys = false;
        if (intr != null && propertyAcc != null) {
            Boolean b;
            Set<String> newIgnored;
            JsonIgnoreProperties.Value ignorals = intr.findPropertyIgnoralByName(provider.getConfig(), propertyAcc);
            if (ignorals != null && (newIgnored = ignorals.findIgnoredForSerialization()) != null && !newIgnored.isEmpty()) {
                ignored = ignored == null ? new HashSet<String>() : new HashSet<String>(ignored);
                for (String str : newIgnored) {
                    ignored.add(str);
                }
            }
            boolean bl = sortKeys = (b = intr.findSerializationSortAlphabetically(propertyAcc)) != null && b != false;
        }
        if ((format = this.findFormatOverrides(provider, property, this.handledType())) != null && (B = format.getFeature(JsonFormat.Feature.WRITE_SORTED_MAP_ENTRIES)) != null) {
            sortKeys = B;
        }
        return this.withResolved(property, keySer, typeSer, valueSer, ignored, filterId, sortKeys);
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public JavaType getContentType() {
        return this._type.getContentType();
    }

    @Override
    public boolean hasSingleElement(Cache<?, ?> cache) {
        return cache.size() == 1L;
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Cache<?, ?> value) {
        return value.size() == 0L;
    }

    @Override
    public void serialize(Cache<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject(value);
        this._writeContents(value, gen, provider);
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Cache<?, ?> value, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
        gen.assignCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        this._writeContents(value, gen, ctxt);
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    protected void _writeContents(Cache<?, ?> cache, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Map<?, ?> value = cache.asMap();
        if (!value.isEmpty()) {
            if (this._sortKeys || provider.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)) {
                value = this._orderEntriesByKey(value, gen, provider);
            }
            if (this._filterId != null) {
                this.serializeFilteredFields(value, gen, provider);
            } else {
                this.serializeFields(value, gen, provider);
            }
        }
    }

    private void serializeFields(Map<?, ?> mmap, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Set<String> ignored = this._ignoredEntries;
        PropertySerializerMap serializers = this._dynamicValueSerializers;
        for (Map.Entry<?, ?> entry : mmap.entrySet()) {
            Class<?> cc;
            Object key = entry.getKey();
            if (ignored != null && ignored.contains(key)) continue;
            if (key == null) {
                provider.findNullKeySerializer(this._type.getKeyType(), this._property).serialize(null, gen, provider);
            } else {
                this._keySerializer.serialize(key, gen, provider);
            }
            Object vv = entry.getValue();
            if (vv == null) {
                provider.defaultSerializeNull(gen);
                continue;
            }
            JsonSerializer<Object> valueSer = this._valueSerializer;
            if (valueSer == null && (valueSer = serializers.serializerFor(cc = vv.getClass())) == null) {
                valueSer = this._findAndAddDynamic(serializers, cc, provider);
                serializers = this._dynamicValueSerializers;
            }
            if (this._valueTypeSerializer == null) {
                valueSer.serialize(vv, gen, provider);
                continue;
            }
            valueSer.serializeWithType(vv, gen, provider, this._valueTypeSerializer);
        }
    }

    private void serializeFilteredFields(Map<?, ?> map, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Set<String> ignored = this._ignoredEntries;
        PropertyFilter filter = this.findPropertyFilter(provider, this._filterId, map);
        MapProperty prop = new MapProperty(this._valueTypeSerializer, this._property);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (ignored != null && ignored.contains(key)) continue;
            Object value = entry.getValue();
            JsonSerializer<Object> valueSer = value == null ? provider.getDefaultNullValueSerializer() : this._valueSerializer;
            prop.reset(key, value, this._keySerializer, valueSer);
            try {
                filter.serializeAsField(map, gen, provider, prop);
            }
            catch (Exception e) {
                String keyDesc = "" + key;
                this.wrapAndThrow(provider, (Throwable)e, value, keyDesc);
            }
        }
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonMapFormatVisitor v2;
        JsonMapFormatVisitor jsonMapFormatVisitor = v2 = visitor == null ? null : visitor.expectMapFormat(typeHint);
        if (v2 != null) {
            v2.keyFormat(this._keySerializer, this._type.getKeyType());
            JsonSerializer<Object> valueSer = this._valueSerializer;
            final JavaType vt = this._type.getContentType();
            final SerializerProvider prov = visitor.getProvider();
            if (valueSer == null) {
                valueSer = this._findAndAddDynamic(this._dynamicValueSerializers, vt, prov);
            }
            final JsonSerializer<Object> valueSer2 = valueSer;
            v2.valueFormat(new JsonFormatVisitable(){
                final JavaType arrayType;
                {
                    this.arrayType = prov.getTypeFactory().constructArrayType(vt);
                }

                @Override
                public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper v3, JavaType hint3) throws JsonMappingException {
                    JsonArrayFormatVisitor v4 = v3.expectArrayFormat(this.arrayType);
                    if (v4 != null) {
                        v4.itemsFormat(valueSer2, vt);
                    }
                }
            }, vt);
        }
    }

    protected Map<?, ?> _orderEntriesByKey(Map<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        try {
            return new TreeMap(value);
        }
        catch (ClassCastException e) {
            return value;
        }
        catch (NullPointerException e) {
            provider.reportMappingProblem("Failed to sort Multimap entries due to `NullPointerException`: `null` key?", new Object[0]);
            return null;
        }
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, Class<?> type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, provider, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, JavaType type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, provider, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }
}

