/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.util.CoreUtils;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.implementation.LinuxKeyRingAccessor;
import com.azure.identity.implementation.WindowsCredentialAccessor;
import com.azure.json.JsonOptions;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.microsoft.aad.msal4jextensions.persistence.mac.KeyChainAccessor;
import com.sun.jna.Platform;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class VisualStudioCacheAccessor {
    private static final String PLATFORM_NOT_SUPPORTED_ERROR = "Platform could not be determined for VS Code credential authentication.";
    private static final Pattern REFRESH_TOKEN_PATTERN = Pattern.compile("^[-_.a-zA-Z0-9]+$");

    public static String getSettingsPath() {
        String homeDir = System.getProperty("user.home");
        try {
            if (Platform.isWindows()) {
                return Paths.get(System.getenv("APPDATA"), "Code", "User", "settings.json").toString();
            }
            if (Platform.isMac()) {
                return Paths.get(homeDir, "Library", "Application Support", "Code", "User", "settings.json").toString();
            }
            if (Platform.isLinux()) {
                return Paths.get(homeDir, ".config", "Code", "User", "settings.json").toString();
            }
            throw new CredentialUnavailableException(PLATFORM_NOT_SUPPORTED_ERROR);
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    public Map<String, String> getUserSettingsDetails() {
        Map map;
        block8: {
            JsonReader jsonReader = JsonProviders.createReader(Files.readAllBytes(Paths.get(VisualStudioCacheAccessor.getSettingsPath(), new String[0])), new JsonOptions().setJsoncSupported(true));
            try {
                map = jsonReader.readObject(reader -> {
                    HashMap<String, String> result = new HashMap<String, String>();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("azure.cloud".equals(fieldName)) {
                            result.put("cloud", reader.getString());
                            continue;
                        }
                        if ("azure.tenant".equals(fieldName)) {
                            result.put("tenant", reader.getString());
                            continue;
                        }
                        reader.skipChildren();
                    }
                    if (!result.containsKey("cloud")) {
                        result.put("cloud", "AzureCloud");
                    }
                    return result;
                });
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            jsonReader.close();
        }
        return map;
    }

    public String getCredentials(String serviceName, String accountName) {
        String credential;
        if (Platform.isWindows()) {
            try {
                credential = new WindowsCredentialAccessor(serviceName, accountName).read();
            }
            catch (Error | Exception e) {
                throw new CredentialUnavailableException("Failed to read Vs Code credentials from Windows Credential API.", e);
            }
        } else if (Platform.isMac()) {
            try {
                KeyChainAccessor keyChainAccessor = new KeyChainAccessor(null, serviceName, accountName);
                byte[] readCreds = keyChainAccessor.read();
                credential = new String(readCreds, StandardCharsets.UTF_8);
            }
            catch (Error | Exception e) {
                throw new CredentialUnavailableException("Failed to read Vs Code credentials from Mac Native Key Chain.", e);
            }
        } else if (Platform.isLinux()) {
            try {
                LinuxKeyRingAccessor keyRingAccessor = new LinuxKeyRingAccessor("org.freedesktop.Secret.Generic", "service", serviceName, "account", accountName);
                byte[] readCreds = keyRingAccessor.read();
                credential = new String(readCreds, StandardCharsets.UTF_8);
            }
            catch (Error | Exception e) {
                throw new CredentialUnavailableException("Failed to read Vs Code credentials from Linux Key Ring.", e);
            }
        } else {
            throw new CredentialUnavailableException(PLATFORM_NOT_SUPPORTED_ERROR);
        }
        if (CoreUtils.isNullOrEmpty(credential) || !this.isRefreshTokenString(credential)) {
            throw new CredentialUnavailableException("Please authenticate via Azure Tools plugin in VS Code IDE.");
        }
        return credential;
    }

    private boolean isRefreshTokenString(String str) {
        return REFRESH_TOKEN_PATTERN.matcher(str).matches();
    }

    public String getAzureAuthHost(String cloud) {
        switch (cloud) {
            case "AzureCloud": {
                return "https://login.microsoftonline.com/";
            }
            case "AzureChina": {
                return "https://login.chinacloudapi.cn/";
            }
            case "AzureGermanCloud": {
                return "https://login.microsoftonline.de/";
            }
            case "AzureUSGovernment": {
                return "https://login.microsoftonline.us/";
            }
        }
        return "https://login.microsoftonline.com/";
    }
}

