/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.protobuf;

import com.google.protobuf.Descriptors;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.plugin.inputformat.protobuf.ProtoBufMessageDecoder;
import org.apache.pinot.plugin.inputformat.protobuf.ProtoBufUtils;
import org.apache.pinot.plugin.inputformat.protobuf.codegen.MessageCodeGen;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.stream.StreamMessageDecoder;
import org.codehaus.janino.SimpleCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoBufCodeGenMessageDecoder
implements StreamMessageDecoder<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtoBufCodeGenMessageDecoder.class);
    public static final String PROTOBUF_JAR_FILE_PATH = "jarFile";
    public static final String PROTO_CLASS_NAME = "protoClassName";
    private Class _recordExtractor = ProtoBufMessageDecoder.class;
    private Method _decodeMethod;

    public void init(Map<String, String> props, Set<String> fieldsToRead, String topicName) throws Exception {
        Preconditions.checkState((boolean)props.containsKey(PROTOBUF_JAR_FILE_PATH), (Object)"Protocol Buffer schema jar file must be provided");
        Preconditions.checkState((boolean)props.containsKey(PROTO_CLASS_NAME), (Object)"Protocol Buffer Message class name must be provided");
        String protoClassName = props.getOrDefault(PROTO_CLASS_NAME, "");
        String jarPath = props.getOrDefault(PROTOBUF_JAR_FILE_PATH, "");
        ClassLoader protoMessageClsLoader = ProtoBufCodeGenMessageDecoder.loadClass(jarPath);
        Descriptors.Descriptor descriptor = ProtoBufCodeGenMessageDecoder.getDescriptorForProtoClass(protoMessageClsLoader, protoClassName);
        String codeGenCode = new MessageCodeGen().codegen(descriptor, fieldsToRead);
        this._recordExtractor = ProtoBufCodeGenMessageDecoder.compileClass(protoMessageClsLoader, "org.apache.pinot.plugin.inputformat.protobuf.decoder.ProtobufRecorderMessageExtractor", codeGenCode);
        this._decodeMethod = this._recordExtractor.getMethod("execute", byte[].class, GenericRow.class);
    }

    @Nullable
    public GenericRow decode(byte[] payload, GenericRow destination) {
        try {
            destination = (GenericRow)this._decodeMethod.invoke(null, payload, destination);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return destination;
    }

    @Nullable
    public GenericRow decode(byte[] payload, int offset, int length, GenericRow destination) {
        return this.decode(Arrays.copyOfRange(payload, offset, offset + length), destination);
    }

    public static ClassLoader loadClass(String jarFilePath) {
        try {
            File file = ProtoBufUtils.getFileCopiedToLocal(jarFilePath);
            URL url = file.toURI().toURL();
            URL[] urls = new URL[]{url};
            return new URLClassLoader(urls);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading protobuf class", e);
        }
    }

    public static Class compileClass(ClassLoader classloader, String className, String code) throws ClassNotFoundException {
        SimpleCompiler simpleCompiler = new SimpleCompiler();
        simpleCompiler.setParentClassLoader(classloader);
        try {
            simpleCompiler.cook(code);
        }
        catch (Throwable t) {
            throw new RuntimeException("Program cannot be compiled. This is a bug. Please file an issue.", t);
        }
        return simpleCompiler.getClassLoader().loadClass(className);
    }

    public static Descriptors.Descriptor getDescriptorForProtoClass(ClassLoader protoMessageClsLoader, String protoClassName) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Class<?> updateMessage = protoMessageClsLoader.loadClass(protoClassName);
        return (Descriptors.Descriptor)updateMessage.getMethod("getDescriptor", new Class[0]).invoke(null, new Object[0]);
    }
}

