/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.retrying;

import com.google.api.gax.retrying.RetrySettings;
import java.time.Duration;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;

final class AutoValue_RetrySettings
extends RetrySettings {
    private final Duration totalTimeoutDuration;
    private final Duration initialRetryDelayDuration;
    private final double retryDelayMultiplier;
    private final Duration maxRetryDelayDuration;
    private final int maxAttempts;
    private final boolean jittered;
    private final Duration initialRpcTimeoutDuration;
    private final double rpcTimeoutMultiplier;
    private final Duration maxRpcTimeoutDuration;
    private static final long serialVersionUID = 8258475264439710899L;

    private AutoValue_RetrySettings(Duration totalTimeoutDuration, Duration initialRetryDelayDuration, double retryDelayMultiplier, Duration maxRetryDelayDuration, int maxAttempts, boolean jittered, Duration initialRpcTimeoutDuration, double rpcTimeoutMultiplier, Duration maxRpcTimeoutDuration) {
        this.totalTimeoutDuration = totalTimeoutDuration;
        this.initialRetryDelayDuration = initialRetryDelayDuration;
        this.retryDelayMultiplier = retryDelayMultiplier;
        this.maxRetryDelayDuration = maxRetryDelayDuration;
        this.maxAttempts = maxAttempts;
        this.jittered = jittered;
        this.initialRpcTimeoutDuration = initialRpcTimeoutDuration;
        this.rpcTimeoutMultiplier = rpcTimeoutMultiplier;
        this.maxRpcTimeoutDuration = maxRpcTimeoutDuration;
    }

    @Override
    public Duration getTotalTimeoutDuration() {
        return this.totalTimeoutDuration;
    }

    @Override
    public Duration getInitialRetryDelayDuration() {
        return this.initialRetryDelayDuration;
    }

    @Override
    public double getRetryDelayMultiplier() {
        return this.retryDelayMultiplier;
    }

    @Override
    public Duration getMaxRetryDelayDuration() {
        return this.maxRetryDelayDuration;
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    @Deprecated
    @VisibleForTesting
    public boolean isJittered() {
        return this.jittered;
    }

    @Override
    public Duration getInitialRpcTimeoutDuration() {
        return this.initialRpcTimeoutDuration;
    }

    @Override
    public double getRpcTimeoutMultiplier() {
        return this.rpcTimeoutMultiplier;
    }

    @Override
    public Duration getMaxRpcTimeoutDuration() {
        return this.maxRpcTimeoutDuration;
    }

    public String toString() {
        return "RetrySettings{totalTimeoutDuration=" + this.totalTimeoutDuration + ", initialRetryDelayDuration=" + this.initialRetryDelayDuration + ", retryDelayMultiplier=" + this.retryDelayMultiplier + ", maxRetryDelayDuration=" + this.maxRetryDelayDuration + ", maxAttempts=" + this.maxAttempts + ", jittered=" + this.jittered + ", initialRpcTimeoutDuration=" + this.initialRpcTimeoutDuration + ", rpcTimeoutMultiplier=" + this.rpcTimeoutMultiplier + ", maxRpcTimeoutDuration=" + this.maxRpcTimeoutDuration + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RetrySettings) {
            RetrySettings that = (RetrySettings)o;
            return this.totalTimeoutDuration.equals(that.getTotalTimeoutDuration()) && this.initialRetryDelayDuration.equals(that.getInitialRetryDelayDuration()) && Double.doubleToLongBits(this.retryDelayMultiplier) == Double.doubleToLongBits(that.getRetryDelayMultiplier()) && this.maxRetryDelayDuration.equals(that.getMaxRetryDelayDuration()) && this.maxAttempts == that.getMaxAttempts() && this.jittered == that.isJittered() && this.initialRpcTimeoutDuration.equals(that.getInitialRpcTimeoutDuration()) && Double.doubleToLongBits(this.rpcTimeoutMultiplier) == Double.doubleToLongBits(that.getRpcTimeoutMultiplier()) && this.maxRpcTimeoutDuration.equals(that.getMaxRpcTimeoutDuration());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.totalTimeoutDuration.hashCode();
        h$ *= 1000003;
        h$ ^= this.initialRetryDelayDuration.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.retryDelayMultiplier) >>> 32 ^ Double.doubleToLongBits(this.retryDelayMultiplier));
        h$ *= 1000003;
        h$ ^= this.maxRetryDelayDuration.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxAttempts;
        h$ *= 1000003;
        h$ ^= this.jittered ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.initialRpcTimeoutDuration.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.rpcTimeoutMultiplier) >>> 32 ^ Double.doubleToLongBits(this.rpcTimeoutMultiplier));
        h$ *= 1000003;
        return h$ ^= this.maxRpcTimeoutDuration.hashCode();
    }

    @Override
    public RetrySettings.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends RetrySettings.Builder {
        private Duration totalTimeoutDuration;
        private Duration initialRetryDelayDuration;
        private double retryDelayMultiplier;
        private Duration maxRetryDelayDuration;
        private int maxAttempts;
        private boolean jittered;
        private Duration initialRpcTimeoutDuration;
        private double rpcTimeoutMultiplier;
        private Duration maxRpcTimeoutDuration;
        private byte set$0;

        Builder() {
        }

        Builder(RetrySettings source) {
            this.totalTimeoutDuration = source.getTotalTimeoutDuration();
            this.initialRetryDelayDuration = source.getInitialRetryDelayDuration();
            this.retryDelayMultiplier = source.getRetryDelayMultiplier();
            this.maxRetryDelayDuration = source.getMaxRetryDelayDuration();
            this.maxAttempts = source.getMaxAttempts();
            this.jittered = source.isJittered();
            this.initialRpcTimeoutDuration = source.getInitialRpcTimeoutDuration();
            this.rpcTimeoutMultiplier = source.getRpcTimeoutMultiplier();
            this.maxRpcTimeoutDuration = source.getMaxRpcTimeoutDuration();
            this.set$0 = (byte)15;
        }

        @Override
        public RetrySettings.Builder setTotalTimeoutDuration(Duration totalTimeoutDuration) {
            if (totalTimeoutDuration == null) {
                throw new NullPointerException("Null totalTimeoutDuration");
            }
            this.totalTimeoutDuration = totalTimeoutDuration;
            return this;
        }

        @Override
        public Duration getTotalTimeoutDuration() {
            if (this.totalTimeoutDuration == null) {
                throw new IllegalStateException("Property \"totalTimeoutDuration\" has not been set");
            }
            return this.totalTimeoutDuration;
        }

        @Override
        public RetrySettings.Builder setInitialRetryDelayDuration(Duration initialRetryDelayDuration) {
            if (initialRetryDelayDuration == null) {
                throw new NullPointerException("Null initialRetryDelayDuration");
            }
            this.initialRetryDelayDuration = initialRetryDelayDuration;
            return this;
        }

        @Override
        public Duration getInitialRetryDelayDuration() {
            if (this.initialRetryDelayDuration == null) {
                throw new IllegalStateException("Property \"initialRetryDelayDuration\" has not been set");
            }
            return this.initialRetryDelayDuration;
        }

        @Override
        public RetrySettings.Builder setRetryDelayMultiplier(double retryDelayMultiplier) {
            this.retryDelayMultiplier = retryDelayMultiplier;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public double getRetryDelayMultiplier() {
            if ((this.set$0 & 1) == 0) {
                throw new IllegalStateException("Property \"retryDelayMultiplier\" has not been set");
            }
            return this.retryDelayMultiplier;
        }

        @Override
        public RetrySettings.Builder setMaxRetryDelayDuration(Duration maxRetryDelayDuration) {
            if (maxRetryDelayDuration == null) {
                throw new NullPointerException("Null maxRetryDelayDuration");
            }
            this.maxRetryDelayDuration = maxRetryDelayDuration;
            return this;
        }

        @Override
        public Duration getMaxRetryDelayDuration() {
            if (this.maxRetryDelayDuration == null) {
                throw new IllegalStateException("Property \"maxRetryDelayDuration\" has not been set");
            }
            return this.maxRetryDelayDuration;
        }

        @Override
        public RetrySettings.Builder setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public int getMaxAttempts() {
            if ((this.set$0 & 2) == 0) {
                throw new IllegalStateException("Property \"maxAttempts\" has not been set");
            }
            return this.maxAttempts;
        }

        @Override
        public RetrySettings.Builder setJittered(boolean jittered) {
            this.jittered = jittered;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public boolean isJittered() {
            if ((this.set$0 & 4) == 0) {
                throw new IllegalStateException("Property \"jittered\" has not been set");
            }
            return this.jittered;
        }

        @Override
        public RetrySettings.Builder setInitialRpcTimeoutDuration(Duration initialRpcTimeoutDuration) {
            if (initialRpcTimeoutDuration == null) {
                throw new NullPointerException("Null initialRpcTimeoutDuration");
            }
            this.initialRpcTimeoutDuration = initialRpcTimeoutDuration;
            return this;
        }

        @Override
        public Duration getInitialRpcTimeoutDuration() {
            if (this.initialRpcTimeoutDuration == null) {
                throw new IllegalStateException("Property \"initialRpcTimeoutDuration\" has not been set");
            }
            return this.initialRpcTimeoutDuration;
        }

        @Override
        public RetrySettings.Builder setRpcTimeoutMultiplier(double rpcTimeoutMultiplier) {
            this.rpcTimeoutMultiplier = rpcTimeoutMultiplier;
            this.set$0 = (byte)(this.set$0 | 8);
            return this;
        }

        @Override
        public double getRpcTimeoutMultiplier() {
            if ((this.set$0 & 8) == 0) {
                throw new IllegalStateException("Property \"rpcTimeoutMultiplier\" has not been set");
            }
            return this.rpcTimeoutMultiplier;
        }

        @Override
        public RetrySettings.Builder setMaxRpcTimeoutDuration(Duration maxRpcTimeoutDuration) {
            if (maxRpcTimeoutDuration == null) {
                throw new NullPointerException("Null maxRpcTimeoutDuration");
            }
            this.maxRpcTimeoutDuration = maxRpcTimeoutDuration;
            return this;
        }

        @Override
        public Duration getMaxRpcTimeoutDuration() {
            if (this.maxRpcTimeoutDuration == null) {
                throw new IllegalStateException("Property \"maxRpcTimeoutDuration\" has not been set");
            }
            return this.maxRpcTimeoutDuration;
        }

        @Override
        RetrySettings autoBuild() {
            if (this.set$0 != 15 || this.totalTimeoutDuration == null || this.initialRetryDelayDuration == null || this.maxRetryDelayDuration == null || this.initialRpcTimeoutDuration == null || this.maxRpcTimeoutDuration == null) {
                StringBuilder missing = new StringBuilder();
                if (this.totalTimeoutDuration == null) {
                    missing.append(" totalTimeoutDuration");
                }
                if (this.initialRetryDelayDuration == null) {
                    missing.append(" initialRetryDelayDuration");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" retryDelayMultiplier");
                }
                if (this.maxRetryDelayDuration == null) {
                    missing.append(" maxRetryDelayDuration");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" maxAttempts");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" jittered");
                }
                if (this.initialRpcTimeoutDuration == null) {
                    missing.append(" initialRpcTimeoutDuration");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" rpcTimeoutMultiplier");
                }
                if (this.maxRpcTimeoutDuration == null) {
                    missing.append(" maxRpcTimeoutDuration");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RetrySettings(this.totalTimeoutDuration, this.initialRetryDelayDuration, this.retryDelayMultiplier, this.maxRetryDelayDuration, this.maxAttempts, this.jittered, this.initialRpcTimeoutDuration, this.rpcTimeoutMultiplier, this.maxRpcTimeoutDuration);
        }
    }
}

