/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum Attribute {
  Manufacturer((short) 0x00, (short) 8),
  Type((short) 0x01, (short) 8),
  FirmwareVersion((short) 0x02, (short) 8),
  Summary((short) 0x03, (short) 9),
  ExtendedDiagnosticSummary((short) 0x04, (short) 13),
  NetworkTerminalLevels((short) 0x05, (short) 13),
  TerminalLevel((short) 0x06, (short) 13),
  NetworkVoltage((short) 0x07, (short) 5),
  GAVValuesCurrent((short) 0x08, (short) 16),
  GAVValuesStored((short) 0x09, (short) 16),
  GAVPhysicalAddresses((short) 0x0A, (short) 16),
  LogicalAssignment((short) 0x0B, (short) 13),
  Delays((short) 0x0C, (short) 14),
  MinimumLevels((short) 0x0D, (short) 13),
  MaximumLevels((short) 0x0E, (short) 13),
  CurrentSenseLevels((short) 0x0F, (short) 8),
  OutputUnitSummary((short) 0x10, (short) 4),
  DSIStatus((short) 0x11, (short) 10);
  private static final Map<Short, Attribute> map;

  static {
    map = new HashMap<>();
    for (Attribute value : Attribute.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;
  private final short bytesReturned;

  Attribute(short value, short bytesReturned) {
    this.value = value;
    this.bytesReturned = bytesReturned;
  }

  public short getValue() {
    return value;
  }

  public short getBytesReturned() {
    return bytesReturned;
  }

  public static Attribute firstEnumForFieldBytesReturned(short fieldValue) {
    for (Attribute _val : Attribute.values()) {
      if (_val.getBytesReturned() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<Attribute> enumsForFieldBytesReturned(short fieldValue) {
    List<Attribute> _values = new ArrayList<>();
    for (Attribute _val : Attribute.values()) {
      if (_val.getBytesReturned() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static Attribute enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
