/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class LinearConversionDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 32437;
  }

  // Properties.
  protected final float initialAddend;
  protected final float multiplicand;
  protected final float divisor;
  protected final float finalAddend;

  public LinearConversionDataType(
      float initialAddend, float multiplicand, float divisor, float finalAddend) {
    super();
    this.initialAddend = initialAddend;
    this.multiplicand = multiplicand;
    this.divisor = divisor;
    this.finalAddend = finalAddend;
  }

  public float getInitialAddend() {
    return initialAddend;
  }

  public float getMultiplicand() {
    return multiplicand;
  }

  public float getDivisor() {
    return divisor;
  }

  public float getFinalAddend() {
    return finalAddend;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("LinearConversionDataType");

    // Simple Field (initialAddend)
    writeSimpleField("initialAddend", initialAddend, writeFloat(writeBuffer, 32));

    // Simple Field (multiplicand)
    writeSimpleField("multiplicand", multiplicand, writeFloat(writeBuffer, 32));

    // Simple Field (divisor)
    writeSimpleField("divisor", divisor, writeFloat(writeBuffer, 32));

    // Simple Field (finalAddend)
    writeSimpleField("finalAddend", finalAddend, writeFloat(writeBuffer, 32));

    writeBuffer.popContext("LinearConversionDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    LinearConversionDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (initialAddend)
    lengthInBits += 32;

    // Simple field (multiplicand)
    lengthInBits += 32;

    // Simple field (divisor)
    lengthInBits += 32;

    // Simple field (finalAddend)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("LinearConversionDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    float initialAddend = readSimpleField("initialAddend", readFloat(readBuffer, 32));

    float multiplicand = readSimpleField("multiplicand", readFloat(readBuffer, 32));

    float divisor = readSimpleField("divisor", readFloat(readBuffer, 32));

    float finalAddend = readSimpleField("finalAddend", readFloat(readBuffer, 32));

    readBuffer.closeContext("LinearConversionDataType");
    // Create the instance
    return new LinearConversionDataTypeBuilderImpl(
        initialAddend, multiplicand, divisor, finalAddend);
  }

  public static class LinearConversionDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final float initialAddend;
    private final float multiplicand;
    private final float divisor;
    private final float finalAddend;

    public LinearConversionDataTypeBuilderImpl(
        float initialAddend, float multiplicand, float divisor, float finalAddend) {
      this.initialAddend = initialAddend;
      this.multiplicand = multiplicand;
      this.divisor = divisor;
      this.finalAddend = finalAddend;
    }

    public LinearConversionDataType build() {
      LinearConversionDataType linearConversionDataType =
          new LinearConversionDataType(initialAddend, multiplicand, divisor, finalAddend);
      return linearConversionDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof LinearConversionDataType)) {
      return false;
    }
    LinearConversionDataType that = (LinearConversionDataType) o;
    return (getInitialAddend() == that.getInitialAddend())
        && (getMultiplicand() == that.getMultiplicand())
        && (getDivisor() == that.getDivisor())
        && (getFinalAddend() == that.getFinalAddend())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getInitialAddend(), getMultiplicand(), getDivisor(), getFinalAddend());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
