/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class RenameMaterializedView
extends Statement {
    private final QualifiedName source;
    private final QualifiedName target;
    private final boolean exists;

    public RenameMaterializedView(QualifiedName source, QualifiedName target, boolean exists) {
        this(Optional.empty(), source, target, exists);
    }

    public RenameMaterializedView(NodeLocation location, QualifiedName source, QualifiedName target, boolean exists) {
        this(Optional.of(location), source, target, exists);
    }

    private RenameMaterializedView(Optional<NodeLocation> location, QualifiedName source, QualifiedName target, boolean exists) {
        super(location);
        this.source = Objects.requireNonNull(source, "source name is null");
        this.target = Objects.requireNonNull(target, "target name is null");
        this.exists = exists;
    }

    public QualifiedName getSource() {
        return this.source;
    }

    public QualifiedName getTarget() {
        return this.target;
    }

    public boolean isExists() {
        return this.exists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRenameMaterializedView(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.target, this.exists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RenameMaterializedView o = (RenameMaterializedView)obj;
        return Objects.equals(this.source, o.source) && Objects.equals(this.target, o.target) && Objects.equals(this.exists, o.exists);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("target", (Object)this.target).add("exists", this.exists).toString();
    }
}

