/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.util.Failures;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Description(value="Creates a multimap by splitting a string into key/value pairs")
@ScalarFunction(value="split_to_multimap")
public class SplitToMultimapFunction {
    private final PageBuilder pageBuilder;

    public SplitToMultimapFunction(@TypeParameter(value="map(varchar,array(varchar))") Type mapType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)mapType));
    }

    @SqlType(value="map(varchar,array(varchar))")
    public Block splitToMultimap(@TypeParameter(value="map(varchar,array(varchar))") Type mapType, @SqlType(value="varchar") Slice string, @SqlType(value="varchar") Slice entryDelimiter, @SqlType(value="varchar") Slice keyValueDelimiter) {
        Failures.checkCondition(entryDelimiter.length() > 0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "entryDelimiter is empty", new Object[0]);
        Failures.checkCondition(keyValueDelimiter.length() > 0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "keyValueDelimiter is empty", new Object[0]);
        Failures.checkCondition(!entryDelimiter.equals((Object)keyValueDelimiter), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "entryDelimiter and keyValueDelimiter must not be the same", new Object[0]);
        ArrayListMultimap multimap = ArrayListMultimap.create();
        int entryStart = 0;
        while (entryStart < string.length()) {
            int entryEnd = string.indexOf(entryDelimiter, entryStart);
            Slice keyValuePair = entryEnd >= 0 ? string.slice(entryStart, entryEnd - entryStart) : string.slice(entryStart, string.length() - entryStart);
            int keyEnd = keyValuePair.indexOf(keyValueDelimiter);
            if (keyEnd < 0) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Key-value delimiter must appear exactly once in each entry. Bad input: " + keyValuePair.toStringUtf8());
            }
            int valueStart = keyEnd + keyValueDelimiter.length();
            Slice key = keyValuePair.slice(0, keyEnd);
            Slice value = keyValuePair.slice(valueStart, keyValuePair.length() - valueStart);
            if (value.indexOf(keyValueDelimiter) >= 0) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Key-value delimiter must appear exactly once in each entry. Bad input: " + keyValuePair.toStringUtf8());
            }
            multimap.put((Object)key, (Object)value);
            if (entryEnd < 0) break;
            entryStart = entryEnd + entryDelimiter.length();
        }
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        this.pageBuilder.declarePosition();
        BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
        BlockBuilder singleMapBlockBuilder = blockBuilder.beginBlockEntry();
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            VarcharType.VARCHAR.writeSlice(singleMapBlockBuilder, (Slice)entry.getKey());
            Collection values = (Collection)entry.getValue();
            BlockBuilder valueBlockBuilder = singleMapBlockBuilder.beginBlockEntry();
            for (Slice value : values) {
                VarcharType.VARCHAR.writeSlice(valueBlockBuilder, value);
            }
            singleMapBlockBuilder.closeEntry();
        }
        blockBuilder.closeEntry();
        return (Block)mapType.getObject((Block)blockBuilder, blockBuilder.getPositionCount() - 1);
    }
}

