/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class TypeProvider {
    private final Map<Symbol, Type> types;

    public static TypeProvider viewOf(Map<Symbol, Type> types) {
        return new TypeProvider(types);
    }

    public static TypeProvider copyOf(Map<Symbol, Type> types) {
        return new TypeProvider((Map<Symbol, Type>)ImmutableMap.copyOf(types));
    }

    public static TypeProvider empty() {
        return new TypeProvider((Map<Symbol, Type>)ImmutableMap.of());
    }

    private TypeProvider(Map<Symbol, Type> types) {
        this.types = types;
    }

    public Type get(Symbol symbol) {
        Objects.requireNonNull(symbol, "symbol is null");
        Type type = this.types.get(symbol);
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"no type found for symbol '%s'", (Object)symbol);
        return type;
    }

    public Map<Symbol, Type> allTypes() {
        return Collections.unmodifiableMap(this.types);
    }
}

