/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ProcedureTester {
    private boolean called;
    private String name;
    private List<Object> arguments;

    public synchronized void reset() {
        this.called = false;
    }

    public void recordCalled(String name, Object ... arguments) {
        this.recordCalled(name, Arrays.asList(arguments));
    }

    public synchronized void recordCalled(String name, List<Object> arguments) {
        Preconditions.checkState((!this.called ? 1 : 0) != 0, (Object)"already called");
        this.called = true;
        this.name = Objects.requireNonNull(name, "name is null");
        this.arguments = Collections.unmodifiableList(Objects.requireNonNull(arguments, "arguments is null"));
    }

    public synchronized boolean wasCalled() {
        return this.called;
    }

    public synchronized String getCalledName() {
        Preconditions.checkState((boolean)this.called, (Object)"not called");
        return this.name;
    }

    public synchronized List<Object> getCalledArguments() {
        Preconditions.checkState((boolean)this.called, (Object)"not called");
        return this.arguments;
    }
}

