/*
 * Decompiled with CFR 0.152.
 */
package io.trino.geospatial;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCPoint;
import com.esri.core.geometry.ogc.OGCPolygon;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.HashSet;
import java.util.Map;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.geojson.GeoJsonReader;
import org.locationtech.jts.io.geojson.GeoJsonWriter;

public final class GeometryUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String COORDINATES_ATTRIBUTE = "coordinates";
    private static final Map<String, String> EMPTY_ATOMIC_GEOMETRY_JSON_OVERRIDE = ImmutableMap.of((Object)"LineString", (Object)"{\"type\":\"LineString\",\"coordinates\":[]}", (Object)"Point", (Object)"{\"type\":\"Point\",\"coordinates\":[]}");
    private static final Map<String, org.locationtech.jts.geom.Geometry> EMPTY_ATOMIC_GEOMETRY_OVERRIDE = ImmutableMap.of((Object)"Polygon", (Object)GEOMETRY_FACTORY.createPolygon(), (Object)"Point", (Object)GEOMETRY_FACTORY.createPoint());

    private GeometryUtils() {
    }

    private static double translateFromAVNaN(double n) {
        return n < -1.0E38 ? Double.NaN : n;
    }

    public static double translateToAVNaN(double n) {
        return Double.isNaN(n) ? -1.7976931348623157E308 : n;
    }

    public static boolean isEsriNaN(double d) {
        return Double.isNaN(d) || Double.isNaN(GeometryUtils.translateFromAVNaN(d));
    }

    public static int getPointCount(OGCGeometry ogcGeometry) {
        GeometryCursor cursor = ogcGeometry.getEsriGeometryCursor();
        int points = 0;
        Geometry geometry;
        while ((geometry = cursor.next()) != null) {
            if (geometry.isEmpty()) continue;
            if (geometry instanceof Point) {
                ++points;
                continue;
            }
            points += ((MultiVertexGeometry)geometry).getPointCount();
        }
        return points;
    }

    public static Envelope getEnvelope(OGCGeometry ogcGeometry) {
        GeometryCursor cursor = ogcGeometry.getEsriGeometryCursor();
        Envelope overallEnvelope = new Envelope();
        Geometry geometry;
        while ((geometry = cursor.next()) != null) {
            Envelope envelope = new Envelope();
            geometry.queryEnvelope(envelope);
            overallEnvelope.merge(envelope);
        }
        return overallEnvelope;
    }

    public static boolean disjoint(Envelope envelope, OGCGeometry ogcGeometry) {
        Geometry geometry;
        GeometryCursor cursor = ogcGeometry.getEsriGeometryCursor();
        do {
            if ((geometry = cursor.next()) != null) continue;
            return true;
        } while (GeometryEngine.disjoint((Geometry)geometry, (Geometry)envelope, null));
        return false;
    }

    public static boolean contains(OGCGeometry ogcGeometry, Envelope envelope) {
        Geometry geometry;
        GeometryCursor cursor = ogcGeometry.getEsriGeometryCursor();
        do {
            if ((geometry = cursor.next()) != null) continue;
            return false;
        } while (!GeometryEngine.contains((Geometry)geometry, (Geometry)envelope, null));
        return true;
    }

    public static boolean isPointOrRectangle(OGCGeometry ogcGeometry, Envelope envelope) {
        if (ogcGeometry instanceof OGCPoint) {
            return true;
        }
        if (!(ogcGeometry instanceof OGCPolygon)) {
            return false;
        }
        Polygon polygon = (Polygon)ogcGeometry.getEsriGeometry();
        if (polygon.getPathCount() > 1) {
            return false;
        }
        if (polygon.getPointCount() != 4) {
            return false;
        }
        HashSet<Point> corners = new HashSet<Point>();
        corners.add(new Point(envelope.getXMin(), envelope.getYMin()));
        corners.add(new Point(envelope.getXMin(), envelope.getYMax()));
        corners.add(new Point(envelope.getXMax(), envelope.getYMin()));
        corners.add(new Point(envelope.getXMax(), envelope.getYMax()));
        for (int i = 0; i < 4; ++i) {
            Point point = polygon.getPoint(i);
            if (corners.contains(point)) continue;
            return false;
        }
        return true;
    }

    public static org.locationtech.jts.geom.Geometry jtsGeometryFromJson(String json) {
        try {
            org.locationtech.jts.geom.Geometry emptyGeoJsonOverride = GeometryUtils.getEmptyGeometryOverride(json);
            if (emptyGeoJsonOverride != null) {
                return emptyGeoJsonOverride;
            }
            return new GeoJsonReader().read(json);
        }
        catch (IllegalArgumentException | ParseException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid GeoJSON: " + e.getMessage(), e);
        }
    }

    private static org.locationtech.jts.geom.Geometry getEmptyGeometryOverride(String json) {
        try {
            JsonNode coordinatesNode;
            org.locationtech.jts.geom.Geometry emptyGeometry;
            JsonNode jsonNode = OBJECT_MAPPER.readTree(json);
            JsonNode typeNode = jsonNode.get(TYPE_ATTRIBUTE);
            if (typeNode != null && (emptyGeometry = EMPTY_ATOMIC_GEOMETRY_OVERRIDE.get(typeNode.textValue())) != null && (coordinatesNode = jsonNode.get(COORDINATES_ATTRIBUTE)) != null && coordinatesNode.isArray() && coordinatesNode.isEmpty()) {
                return emptyGeometry;
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return null;
    }

    public static String jsonFromJtsGeometry(org.locationtech.jts.geom.Geometry geometry) {
        String geoJsonOverride = GeometryUtils.getEmptyGeoJsonOverride(geometry);
        if (geoJsonOverride != null) {
            return geoJsonOverride;
        }
        return new GeoJsonWriter().write(geometry);
    }

    private static String getEmptyGeoJsonOverride(org.locationtech.jts.geom.Geometry geometry) {
        if (geometry.isEmpty()) {
            return EMPTY_ATOMIC_GEOMETRY_JSON_OVERRIDE.get(geometry.getGeometryType());
        }
        return null;
    }
}

