/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ForwardingExecutorService;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.bookkeeper.common.util.BoundedExecutorService;
import org.apache.bookkeeper.common.util.MathUtils;
import org.apache.bookkeeper.common.util.MdcUtils;
import org.apache.bookkeeper.common.util.SingleThreadExecutor;
import org.apache.bookkeeper.common.util.affinity.CpuAffinity;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.ThreadRegistry;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class OrderedExecutor
implements ExecutorService {
    private static final Logger log = LoggerFactory.getLogger(OrderedExecutor.class);
    public static final int NO_TASK_LIMIT = -1;
    private static final int DEFAULT_MAX_ARRAY_QUEUE_SIZE = 10000;
    protected static final long WARN_TIME_MICRO_SEC_DEFAULT = TimeUnit.SECONDS.toMicros(1L);
    final String name;
    final ExecutorService[] threads;
    final long[] threadIds;
    final Random rand = new Random();
    final OpStatsLogger taskExecutionStats;
    final OpStatsLogger taskPendingStats;
    final boolean traceTaskExecution;
    final boolean preserveMdcForTaskExecution;
    final long warnTimeMicroSec;
    final int maxTasksInQueue;
    final boolean enableBusyWait;
    final boolean enableThreadScopedMetrics;

    public static Builder newBuilder() {
        return new Builder();
    }

    protected ExecutorService createSingleThreadExecutor(ThreadFactory factory) {
        if (this.maxTasksInQueue > 0) {
            return new SingleThreadExecutor(factory, this.maxTasksInQueue, true);
        }
        return new SingleThreadExecutor(factory);
    }

    protected ExecutorService getBoundedExecutor(ExecutorService executor) {
        Preconditions.checkArgument((boolean)(executor instanceof ThreadPoolExecutor));
        return new BoundedExecutorService((ThreadPoolExecutor)executor, this.maxTasksInQueue);
    }

    protected ExecutorService addExecutorDecorators(final ExecutorService executor) {
        return new ForwardingExecutorService(){

            protected ExecutorService delegate() {
                return executor;
            }

            public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
                return super.invokeAll(OrderedExecutor.this.timedCallables(tasks));
            }

            public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
                return super.invokeAll(OrderedExecutor.this.timedCallables(tasks), timeout, unit);
            }

            public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
                return (T)super.invokeAny(OrderedExecutor.this.timedCallables(tasks));
            }

            public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return (T)super.invokeAny(OrderedExecutor.this.timedCallables(tasks), timeout, unit);
            }

            public void execute(Runnable command) {
                super.execute(OrderedExecutor.this.timedRunnable(command));
            }

            public <T> Future<T> submit(Callable<T> task) {
                return super.submit(OrderedExecutor.this.timedCallable(task));
            }

            public Future<?> submit(Runnable task) {
                return super.submit(OrderedExecutor.this.timedRunnable(task));
            }

            public <T> Future<T> submit(Runnable task, T result) {
                return super.submit(OrderedExecutor.this.timedRunnable(task), result);
            }
        };
    }

    protected OrderedExecutor(String baseName, final int numThreads, ThreadFactory threadFactory, StatsLogger statsLogger, boolean traceTaskExecution, boolean preserveMdcForTaskExecution, long warnTimeMicroSec, final int maxTasksInQueue, boolean enableBusyWait, boolean enableThreadScopedMetrics) {
        Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)baseName) ? 1 : 0) != 0);
        this.maxTasksInQueue = maxTasksInQueue;
        this.warnTimeMicroSec = warnTimeMicroSec;
        this.enableBusyWait = enableBusyWait;
        this.enableThreadScopedMetrics = enableThreadScopedMetrics;
        this.name = baseName;
        this.threads = new ExecutorService[numThreads];
        this.threadIds = new long[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            ExecutorService thread = this.createSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(this.name + "-" + this.getClass().getSimpleName() + "-" + i + "-%d").setThreadFactory(threadFactory).build());
            SingleThreadExecutor ste = null;
            if (thread instanceof SingleThreadExecutor) {
                ste = (SingleThreadExecutor)thread;
            }
            if (traceTaskExecution || preserveMdcForTaskExecution) {
                thread = this.addExecutorDecorators(thread);
            }
            this.threads[i] = thread;
            int idx = i;
            try {
                this.threads[idx].submit(() -> {
                    this.threadIds[idx] = Thread.currentThread().getId();
                    if (enableThreadScopedMetrics) {
                        ThreadRegistry.register((String)baseName, (int)idx);
                    }
                    if (enableBusyWait) {
                        try {
                            CpuAffinity.acquireCore();
                        }
                        catch (Throwable t) {
                            log.warn("Failed to acquire CPU core for thread {}: {}", new Object[]{Thread.currentThread().getName(), t.getMessage(), t});
                        }
                    }
                }).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Couldn't start thread " + i, e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Couldn't start thread " + i, e);
            }
            if (ste == null) continue;
            ste.registerMetrics(statsLogger);
        }
        statsLogger.registerGauge(String.format("%s-threads", this.name), (Gauge)new Gauge<Number>(){

            public Number getDefaultValue() {
                return numThreads;
            }

            public Number getSample() {
                return numThreads;
            }
        });
        statsLogger.registerGauge(String.format("%s-max-queue-size", this.name), (Gauge)new Gauge<Number>(){

            public Number getDefaultValue() {
                return maxTasksInQueue;
            }

            public Number getSample() {
                return maxTasksInQueue;
            }
        });
        if (enableThreadScopedMetrics) {
            this.taskExecutionStats = statsLogger.scope(this.name).getThreadScopedOpStatsLogger("task_execution");
            this.taskPendingStats = statsLogger.scope(this.name).getThreadScopedOpStatsLogger("task_queued");
        } else {
            this.taskExecutionStats = statsLogger.scope(this.name).getOpStatsLogger("task_execution");
            this.taskPendingStats = statsLogger.scope(this.name).getOpStatsLogger("task_queued");
        }
        this.traceTaskExecution = traceTaskExecution;
        this.preserveMdcForTaskExecution = preserveMdcForTaskExecution;
    }

    public boolean preserveMdc() {
        return this.preserveMdcForTaskExecution;
    }

    public void executeOrdered(Object orderingKey, Runnable r) {
        this.chooseThread(orderingKey).execute(r);
    }

    public void executeOrdered(long orderingKey, Runnable r) {
        this.chooseThread(orderingKey).execute(r);
    }

    public void executeOrdered(int orderingKey, Runnable r) {
        this.chooseThread(orderingKey).execute(r);
    }

    public <T> ListenableFuture<T> submitOrdered(long orderingKey, Callable<T> task) {
        SettableFuture future = SettableFuture.create();
        this.executeOrdered(orderingKey, () -> {
            try {
                Object result = task.call();
                future.set(result);
            }
            catch (Throwable t) {
                future.setException(t);
            }
        });
        return future;
    }

    public long getThreadID(long orderingKey) {
        if (this.threadIds.length == 1) {
            return this.threadIds[0];
        }
        return this.threadIds[OrderedExecutor.chooseThreadIdx(orderingKey, this.threads.length)];
    }

    public ExecutorService chooseThread() {
        if (this.threads.length == 1) {
            return this.threads[0];
        }
        return this.threads[this.rand.nextInt(this.threads.length)];
    }

    public ExecutorService chooseThread(Object orderingKey) {
        if (this.threads.length == 1) {
            return this.threads[0];
        }
        if (null == orderingKey) {
            return this.threads[this.rand.nextInt(this.threads.length)];
        }
        return this.threads[OrderedExecutor.chooseThreadIdx(orderingKey.hashCode(), this.threads.length)];
    }

    public ExecutorService chooseThread(long orderingKey) {
        if (this.threads.length == 1) {
            return this.threads[0];
        }
        return this.threads[OrderedExecutor.chooseThreadIdx(orderingKey, this.threads.length)];
    }

    protected static int chooseThreadIdx(long orderingKey, int numThreads) {
        return MathUtils.signSafeMod(orderingKey >>> 1, numThreads);
    }

    protected Runnable timedRunnable(Runnable r) {
        Runnable runMe = this.traceTaskExecution ? new TimedRunnable(r) : r;
        return this.preserveMdcForTaskExecution ? new ContextPreservingRunnable(runMe) : runMe;
    }

    protected <T> Callable<T> timedCallable(Callable<T> c) {
        TimedCallable callMe = this.traceTaskExecution ? new TimedCallable(c) : c;
        return this.preserveMdcForTaskExecution ? new ContextPreservingCallable(callMe) : callMe;
    }

    protected <T> Collection<? extends Callable<T>> timedCallables(Collection<? extends Callable<T>> tasks) {
        if (this.traceTaskExecution || this.preserveMdcForTaskExecution) {
            return tasks.stream().map(this::timedCallable).collect(Collectors.toList());
        }
        return tasks;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.chooseThread().submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.chooseThread().submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.chooseThread().submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.chooseThread().invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.chooseThread().invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.chooseThread().invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.chooseThread().invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.chooseThread().execute(command);
    }

    @Override
    public void shutdown() {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        for (ExecutorService executor : this.threads) {
            runnables.addAll(executor.shutdownNow());
        }
        return runnables;
    }

    @Override
    public boolean isShutdown() {
        for (ExecutorService executor : this.threads) {
            if (executor.isShutdown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean ret = true;
        for (int i = 0; i < this.threads.length; ++i) {
            ret = ret && this.threads[i].awaitTermination(timeout, unit);
        }
        return ret;
    }

    @Override
    public boolean isTerminated() {
        for (ExecutorService executor : this.threads) {
            if (executor.isTerminated()) continue;
            return false;
        }
        return true;
    }

    public void forceShutdown(long timeout, TimeUnit unit) {
        for (int i = 0; i < this.threads.length; ++i) {
            try {
                if (this.threads[i].awaitTermination(timeout, unit)) continue;
                this.threads[i].shutdownNow();
                continue;
            }
            catch (InterruptedException exception) {
                this.threads[i].shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    static class ContextPreservingCallable<T>
    implements Callable<T> {
        private final Callable<T> callable;
        private final Map<String, String> mdcContextMap;

        ContextPreservingCallable(Callable<T> callable) {
            this.callable = callable;
            this.mdcContextMap = MDC.getCopyOfContextMap();
        }

        @Override
        public T call() throws Exception {
            MdcUtils.restoreContext(this.mdcContextMap);
            try {
                T t = this.callable.call();
                return t;
            }
            finally {
                MDC.clear();
            }
        }
    }

    static class ContextPreservingRunnable
    implements Runnable {
        private final Runnable runnable;
        private final Map<String, String> mdcContextMap;

        ContextPreservingRunnable(Runnable runnable) {
            this.runnable = runnable;
            this.mdcContextMap = MDC.getCopyOfContextMap();
        }

        @Override
        public void run() {
            MdcUtils.restoreContext(this.mdcContextMap);
            try {
                this.runnable.run();
            }
            finally {
                MDC.clear();
            }
        }
    }

    protected class TimedCallable<T>
    implements Callable<T> {
        final Callable<T> callable;
        final long initNanos;
        final Class<?> callableClass;

        TimedCallable(Callable<T> callable) {
            this.callable = callable;
            this.initNanos = MathUtils.nowInNano();
            this.callableClass = callable.getClass();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            OrderedExecutor.this.taskPendingStats.registerSuccessfulEvent(MathUtils.elapsedNanos(this.initNanos), TimeUnit.NANOSECONDS);
            long startNanos = MathUtils.nowInNano();
            try {
                T t = this.callable.call();
                return t;
            }
            finally {
                long elapsedMicroSec = MathUtils.elapsedMicroSec(startNanos);
                OrderedExecutor.this.taskExecutionStats.registerSuccessfulEvent(elapsedMicroSec, TimeUnit.MICROSECONDS);
                if (elapsedMicroSec >= OrderedExecutor.this.warnTimeMicroSec) {
                    log.warn("Callable {} took too long {} micros to execute.", this.callableClass, (Object)elapsedMicroSec);
                }
            }
        }
    }

    protected class TimedRunnable
    implements Runnable {
        final Runnable runnable;
        final long initNanos;
        final Class<?> runnableClass;

        TimedRunnable(Runnable runnable) {
            this.runnable = runnable;
            this.initNanos = MathUtils.nowInNano();
            this.runnableClass = runnable.getClass();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OrderedExecutor.this.taskPendingStats.registerSuccessfulEvent(MathUtils.elapsedNanos(this.initNanos), TimeUnit.NANOSECONDS);
            long startNanos = MathUtils.nowInNano();
            try {
                this.runnable.run();
            }
            finally {
                long elapsedMicroSec = MathUtils.elapsedMicroSec(startNanos);
                OrderedExecutor.this.taskExecutionStats.registerSuccessfulEvent(elapsedMicroSec, TimeUnit.MICROSECONDS);
                if (elapsedMicroSec >= OrderedExecutor.this.warnTimeMicroSec) {
                    log.warn("Runnable {} took too long {} micros to execute.", this.runnableClass, (Object)elapsedMicroSec);
                }
            }
        }
    }

    public static abstract class AbstractBuilder<T extends OrderedExecutor> {
        protected String name = this.getClass().getSimpleName();
        protected int numThreads = Runtime.getRuntime().availableProcessors();
        protected ThreadFactory threadFactory = null;
        protected StatsLogger statsLogger = NullStatsLogger.INSTANCE;
        protected boolean traceTaskExecution = false;
        protected boolean preserveMdcForTaskExecution = false;
        protected long warnTimeMicroSec = WARN_TIME_MICRO_SEC_DEFAULT;
        protected int maxTasksInQueue = -1;
        protected boolean enableBusyWait = false;
        protected boolean enableThreadScopedMetrics = false;

        public AbstractBuilder<T> name(String name) {
            this.name = name;
            return this;
        }

        public AbstractBuilder<T> numThreads(int num) {
            this.numThreads = num;
            return this;
        }

        public AbstractBuilder<T> maxTasksInQueue(int num) {
            this.maxTasksInQueue = num;
            return this;
        }

        public AbstractBuilder<T> threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public AbstractBuilder<T> statsLogger(StatsLogger statsLogger) {
            this.statsLogger = statsLogger;
            return this;
        }

        public AbstractBuilder<T> traceTaskExecution(boolean enabled) {
            this.traceTaskExecution = enabled;
            return this;
        }

        public AbstractBuilder<T> preserveMdcForTaskExecution(boolean enabled) {
            this.preserveMdcForTaskExecution = enabled;
            return this;
        }

        public AbstractBuilder<T> traceTaskWarnTimeMicroSec(long warnTimeMicroSec) {
            this.warnTimeMicroSec = warnTimeMicroSec;
            return this;
        }

        public AbstractBuilder<T> enableBusyWait(boolean enableBusyWait) {
            this.enableBusyWait = enableBusyWait;
            return this;
        }

        public AbstractBuilder<T> enableThreadScopedMetrics(boolean enableThreadScopedMetrics) {
            this.enableThreadScopedMetrics = enableThreadScopedMetrics;
            return this;
        }

        public T build() {
            if (null == this.threadFactory) {
                this.threadFactory = new DefaultThreadFactory(this.name);
            }
            return (T)new OrderedExecutor(this.name, this.numThreads, this.threadFactory, this.statsLogger, this.traceTaskExecution, this.preserveMdcForTaskExecution, this.warnTimeMicroSec, this.maxTasksInQueue, this.enableBusyWait, this.enableThreadScopedMetrics);
        }
    }

    public static class Builder
    extends AbstractBuilder<OrderedExecutor> {
        @Override
        public OrderedExecutor build() {
            if (null == this.threadFactory) {
                this.threadFactory = new DefaultThreadFactory("bookkeeper-ordered-safe-executor");
            }
            return new OrderedExecutor(this.name, this.numThreads, this.threadFactory, this.statsLogger, this.traceTaskExecution, this.preserveMdcForTaskExecution, this.warnTimeMicroSec, this.maxTasksInQueue, this.enableBusyWait, this.enableThreadScopedMetrics);
        }
    }
}

