/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;

public class LeaderBulkByScrollTaskState {
    private final BulkByScrollTask task;
    private final int slices;
    private final AtomicArray<Result> results;
    private final AtomicInteger runningSubtasks;

    public LeaderBulkByScrollTaskState(BulkByScrollTask task, int slices) {
        this.task = task;
        this.slices = slices;
        this.results = new AtomicArray(slices);
        this.runningSubtasks = new AtomicInteger(slices);
    }

    public int getSlices() {
        return this.slices;
    }

    public BulkByScrollTask.Status getStatus(List<BulkByScrollTask.StatusOrException> statuses) {
        if (statuses.size() != this.results.length()) {
            throw new IllegalArgumentException("Given number of statuses does not match amount of expected results");
        }
        this.addResultsToList(statuses);
        return new BulkByScrollTask.Status(Collections.unmodifiableList(statuses), this.task.getReasonCancelled());
    }

    public BulkByScrollTask.Status getStatus() {
        return this.getStatus(Arrays.asList(new BulkByScrollTask.StatusOrException[this.results.length()]));
    }

    public int runningSliceSubTasks() {
        return this.runningSubtasks.get();
    }

    private void addResultsToList(List<BulkByScrollTask.StatusOrException> sliceStatuses) {
        for (Result t : this.results.asList()) {
            if (t.response != null) {
                sliceStatuses.set(t.sliceId, new BulkByScrollTask.StatusOrException(t.response.getStatus()));
                continue;
            }
            sliceStatuses.set(t.sliceId, new BulkByScrollTask.StatusOrException(t.failure));
        }
    }

    public void onSliceResponse(ActionListener<BulkByScrollResponse> listener, int sliceId, BulkByScrollResponse response) {
        this.results.setOnce(sliceId, new Result(sliceId, response));
        this.recordSliceCompletionAndRespondIfAllDone(listener);
    }

    public void onSliceFailure(ActionListener<BulkByScrollResponse> listener, int sliceId, Exception e) {
        this.results.setOnce(sliceId, new Result(sliceId, e));
        this.recordSliceCompletionAndRespondIfAllDone(listener);
    }

    private void recordSliceCompletionAndRespondIfAllDone(ActionListener<BulkByScrollResponse> listener) {
        if (this.runningSubtasks.decrementAndGet() != 0) {
            return;
        }
        ArrayList<BulkByScrollResponse> responses = new ArrayList<BulkByScrollResponse>(this.results.length());
        Exception exception = null;
        for (Result t : this.results.asList()) {
            if (t.response == null) {
                assert (t.failure != null) : "exception shouldn't be null if value is null";
                if (exception == null) {
                    exception = t.failure;
                    continue;
                }
                exception.addSuppressed(t.failure);
                continue;
            }
            assert (t.failure == null) : "exception should be null if response is not null";
            responses.add(t.response);
        }
        if (exception == null) {
            listener.onResponse(new BulkByScrollResponse(responses, this.task.getReasonCancelled()));
        } else {
            listener.onFailure(exception);
        }
    }

    private static final class Result {
        final BulkByScrollResponse response;
        final int sliceId;
        final Exception failure;

        private Result(int sliceId, BulkByScrollResponse response) {
            this.sliceId = sliceId;
            this.response = response;
            this.failure = null;
        }

        private Result(int sliceId, Exception failure) {
            this.sliceId = sliceId;
            this.failure = failure;
            this.response = null;
        }
    }
}

