/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.destination;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.MiscUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAuditDestination
extends AuditDestination {
    private static final Logger logger = LoggerFactory.getLogger(FileAuditDestination.class);
    public static final String PROP_FILE_LOCAL_DIR = "dir";
    public static final String PROP_FILE_LOCAL_FILE_NAME_FORMAT = "filename.format";
    public static final String PROP_FILE_FILE_ROLLOVER = "file.rollover.sec";
    String baseFolder = null;
    String fileFormat = null;
    int fileRolloverSec = 86400;
    private String logFileNameFormat;
    boolean initDone = false;
    private File logFolder;
    PrintWriter logWriter = null;
    private Date fileCreateTime = null;
    private String currentFileName;
    private boolean isStopped = false;

    @Override
    public void init(Properties prop, String propPrefix) {
        super.init(prop, propPrefix);
        String logFolderProp = MiscUtil.getStringProperty(this.props, propPrefix + "." + PROP_FILE_LOCAL_DIR);
        this.logFileNameFormat = MiscUtil.getStringProperty(this.props, propPrefix + "." + PROP_FILE_LOCAL_FILE_NAME_FORMAT);
        this.fileRolloverSec = MiscUtil.getIntProperty(this.props, propPrefix + "." + PROP_FILE_FILE_ROLLOVER, this.fileRolloverSec);
        if (logFolderProp == null || logFolderProp.isEmpty()) {
            logger.error("File destination folder is not configured. Please set {}. {}. name= {}", new Object[]{propPrefix, PROP_FILE_LOCAL_DIR, this.getName()});
            return;
        }
        this.logFolder = new File(logFolderProp);
        if (!this.logFolder.isDirectory()) {
            this.logFolder.mkdirs();
            if (!this.logFolder.isDirectory()) {
                logger.error("FileDestination folder not found and can't be created. folder={}, name={}", (Object)this.logFolder.getAbsolutePath(), (Object)this.getName());
                return;
            }
        }
        logger.info("logFolder={}, name={}", (Object)this.logFolder, (Object)this.getName());
        if (this.logFileNameFormat == null || this.logFileNameFormat.isEmpty()) {
            this.logFileNameFormat = "%app-type%_ranger_audit.log";
        }
        logger.info("logFileNameFormat={}, destName={}", (Object)this.logFileNameFormat, (Object)this.getName());
        this.initDone = true;
    }

    @Override
    public synchronized boolean logJSON(Collection<String> events) {
        this.logStatusIfRequired();
        this.addTotalCount(events.size());
        if (this.isStopped) {
            this.logError("logJSON() called after stop was requested. name={}", this.getName());
            this.addDeferredCount(events.size());
            return false;
        }
        try {
            PrintWriter out = this.getLogFileStream();
            for (String event : events) {
                out.println(event);
            }
            out.flush();
        }
        catch (Throwable t) {
            this.addDeferredCount(events.size());
            this.logError("Error writing to log file.", t);
            return false;
        }
        this.addSuccessCount(events.size());
        return true;
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        if (this.isStopped) {
            this.addTotalCount(events.size());
            this.addDeferredCount(events.size());
            this.logError("log() called after stop was requested. name={}", this.getName());
            return false;
        }
        ArrayList<String> jsonList = new ArrayList<String>();
        for (AuditEventBase event : events) {
            try {
                jsonList.add(MiscUtil.stringify(event));
            }
            catch (Throwable t) {
                this.addTotalCount(1);
                this.addFailedCount(1);
                this.logFailedEvent(event);
                logger.error("Error converting to JSON. event={}", (Object)event);
            }
        }
        return this.logJSON(jsonList);
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized void stop() {
        this.isStopped = true;
        if (this.logWriter != null) {
            try {
                this.logWriter.flush();
                this.logWriter.close();
            }
            catch (Throwable t) {
                logger.error("Error on closing log writer. Exception will be ignored. name= {}, fileName=  {}", (Object)this.getName(), (Object)this.currentFileName);
            }
            this.logWriter = null;
        }
        this.logStatus();
    }

    private synchronized PrintWriter getLogFileStream() throws Exception {
        this.closeFileIfNeeded();
        if (this.logWriter == null) {
            Date currentTime = new Date();
            String fileName = MiscUtil.replaceTokens(this.logFileNameFormat, currentTime.getTime());
            File outLogFile = new File(this.logFolder, fileName);
            if (outLogFile.exists()) {
                String extension;
                String baseName;
                String newFileName;
                File newLogFile;
                int i = 0;
                do {
                    int lastDot = fileName.lastIndexOf(46);
                    baseName = fileName.substring(0, lastDot);
                    extension = fileName.substring(lastDot);
                } while ((newLogFile = new File(this.logFolder, newFileName = baseName + "." + ++i + extension)).exists());
                if (!outLogFile.renameTo(newLogFile)) {
                    logger.error("Error renameing file. {}  to {} ", (Object)outLogFile, (Object)newLogFile);
                }
            }
            if (!outLogFile.exists()) {
                logger.info("Creating new file. destName={} , fileName={} ", (Object)this.getName(), (Object)fileName);
                this.logWriter = new PrintWriter(new BufferedWriter(new FileWriter(outLogFile)));
            } else {
                this.logWriter = new PrintWriter(new BufferedWriter(new FileWriter(outLogFile, true)));
            }
            this.fileCreateTime = new Date();
            this.currentFileName = outLogFile.getPath();
        }
        return this.logWriter;
    }

    private void closeFileIfNeeded() {
        if (this.logWriter == null) {
            return;
        }
        if (System.currentTimeMillis() - this.fileCreateTime.getTime() > (long)(this.fileRolloverSec * 1000)) {
            logger.info("Closing file. Rolling over. name={} , fileName={}", (Object)this.getName(), (Object)this.currentFileName);
            try {
                this.logWriter.flush();
                this.logWriter.close();
            }
            catch (Throwable t) {
                logger.error("Error on closing log writter. Exception will be ignored. name={} , fileName={}", (Object)this.getName(), (Object)this.currentFileName);
            }
            this.logWriter = null;
            this.currentFileName = null;
        }
    }
}

