/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.store.AbstractPredicateUtil;
import org.apache.ranger.plugin.util.SearchFilter;

public class RolePredicateUtil
extends AbstractPredicateUtil {
    @Override
    public void addPredicates(SearchFilter filter, List<Predicate> predicates) {
        this.addPredicateForRoleName(filter.getParam("roleName"), predicates);
        this.addPredicateForRoleId(filter.getParam("roleId"), predicates);
        this.addPredicateForGroupName(filter.getParam("groupName"), predicates);
        this.addPredicateForUserName(filter.getParam("userName"), predicates);
        this.addPredicateForPartialRoleName(filter.getParam("roleNamePartial"), predicates);
        this.addPredicateForPartialGroupName(filter.getParam("groupNamePartial"), predicates);
        this.addPredicateForPartialUserName(filter.getParam("userNamePartial"), predicates);
    }

    private Predicate addPredicateForRoleName(final String roleName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)roleName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret;
                block2: {
                    RangerRole.RoleMember member;
                    RangerRole role;
                    if (object == null) {
                        return false;
                    }
                    ret = false;
                    if (!(object instanceof RangerRole) || (ret = StringUtils.equals((String)(role = (RangerRole)object).getName(), (String)roleName))) break block2;
                    List<RangerRole.RoleMember> roles = role.getRoles();
                    Iterator<RangerRole.RoleMember> iterator = roles.iterator();
                    while (iterator.hasNext() && !(ret = StringUtils.equals((String)(member = iterator.next()).getName(), (String)roleName))) {
                    }
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPartialRoleName(final String roleNamePartial, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)roleNamePartial)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret;
                block2: {
                    RangerRole.RoleMember member;
                    RangerRole role;
                    if (object == null) {
                        return false;
                    }
                    ret = false;
                    if (!(object instanceof RangerRole) || (ret = StringUtils.containsIgnoreCase((String)(role = (RangerRole)object).getName(), (String)roleNamePartial))) break block2;
                    List<RangerRole.RoleMember> roles = role.getRoles();
                    Iterator<RangerRole.RoleMember> iterator = roles.iterator();
                    while (iterator.hasNext() && !(ret = StringUtils.containsIgnoreCase((String)(member = iterator.next()).getName(), (String)roleNamePartial))) {
                    }
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForRoleId(final String roleId, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)roleId)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                if (object == null) {
                    return false;
                }
                boolean ret = false;
                if (object instanceof RangerRole) {
                    RangerRole role = (RangerRole)object;
                    ret = StringUtils.equals((String)roleId, (String)role.getId().toString());
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForGroupName(final String groupName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)groupName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret;
                block2: {
                    RangerRole.RoleMember member;
                    if (object == null) {
                        return false;
                    }
                    ret = false;
                    if (!(object instanceof RangerRole)) break block2;
                    RangerRole role = (RangerRole)object;
                    List<RangerRole.RoleMember> groups = role.getGroups();
                    Iterator<RangerRole.RoleMember> iterator = groups.iterator();
                    while (iterator.hasNext() && !(ret = StringUtils.equals((String)(member = iterator.next()).getName(), (String)groupName))) {
                    }
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPartialGroupName(final String groupNamePartial, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)groupNamePartial)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret;
                block2: {
                    RangerRole.RoleMember member;
                    if (object == null) {
                        return false;
                    }
                    ret = false;
                    if (!(object instanceof RangerRole)) break block2;
                    RangerRole role = (RangerRole)object;
                    List<RangerRole.RoleMember> groups = role.getGroups();
                    Iterator<RangerRole.RoleMember> iterator = groups.iterator();
                    while (iterator.hasNext() && !(ret = StringUtils.containsIgnoreCase((String)(member = iterator.next()).getName(), (String)groupNamePartial))) {
                    }
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForUserName(final String userName, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)userName)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret;
                block2: {
                    RangerRole.RoleMember member;
                    if (object == null) {
                        return false;
                    }
                    ret = false;
                    if (!(object instanceof RangerRole)) break block2;
                    RangerRole role = (RangerRole)object;
                    List<RangerRole.RoleMember> users = role.getUsers();
                    Iterator<RangerRole.RoleMember> iterator = users.iterator();
                    while (iterator.hasNext() && !(ret = StringUtils.equals((String)(member = iterator.next()).getName(), (String)userName))) {
                    }
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }

    private Predicate addPredicateForPartialUserName(final String userNamePartial, List<Predicate> predicates) {
        if (StringUtils.isEmpty((String)userNamePartial)) {
            return null;
        }
        Predicate ret = new Predicate(){

            public boolean evaluate(Object object) {
                boolean ret;
                block2: {
                    RangerRole.RoleMember member;
                    if (object == null) {
                        return false;
                    }
                    ret = false;
                    if (!(object instanceof RangerRole)) break block2;
                    RangerRole role = (RangerRole)object;
                    List<RangerRole.RoleMember> users = role.getUsers();
                    Iterator<RangerRole.RoleMember> iterator = users.iterator();
                    while (iterator.hasNext() && !(ret = StringUtils.containsIgnoreCase((String)(member = iterator.next()).getName(), (String)userNamePartial))) {
                    }
                }
                return ret;
            }
        };
        if (predicates != null) {
            predicates.add(ret);
        }
        return ret;
    }
}

