/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.bval.util.Validate;

public class EmulatedAnnotatedType<T extends Type>
implements AnnotatedType {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    protected final T wrapped;
    private final Optional<AnnotatedElement> annotated;

    public static EmulatedAnnotatedType<?> wrap(Type type) {
        if (type instanceof ParameterizedType) {
            return new Parameterized((ParameterizedType)type);
        }
        if (type instanceof TypeVariable) {
            return new Variable((TypeVariable)type);
        }
        if (type instanceof WildcardType) {
            return new Wildcard((WildcardType)type);
        }
        return new EmulatedAnnotatedType<Type>(type);
    }

    private static EmulatedAnnotatedType<?>[] wrapArray(Type[] types) {
        return (EmulatedAnnotatedType[])Stream.of(types).map(EmulatedAnnotatedType::wrap).toArray(EmulatedAnnotatedType[]::new);
    }

    private EmulatedAnnotatedType(T wrapped) {
        this.wrapped = (Type)Validate.notNull(wrapped);
        this.annotated = Optional.of(wrapped).filter(AnnotatedElement.class::isInstance).map(AnnotatedElement.class::cast);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return (A)((Annotation)this.annotated.map(e -> e.getAnnotation(annotationClass)).orElse(null));
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotated.map(AnnotatedElement::getAnnotations).orElse(EMPTY_ANNOTATION_ARRAY);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.annotated.map(AnnotatedElement::getDeclaredAnnotations).orElse(EMPTY_ANNOTATION_ARRAY);
    }

    @Override
    public Type getType() {
        return this.wrapped;
    }

    /* synthetic */ EmulatedAnnotatedType(Type x0, 1 x1) {
        this(x0);
    }

    private static class Wildcard
    extends EmulatedAnnotatedType<WildcardType>
    implements AnnotatedWildcardType {
        Wildcard(WildcardType wrapped) {
            super(wrapped, null);
        }

        @Override
        public AnnotatedType[] getAnnotatedLowerBounds() {
            return EmulatedAnnotatedType.wrapArray(((WildcardType)this.wrapped).getLowerBounds());
        }

        @Override
        public AnnotatedType[] getAnnotatedUpperBounds() {
            return EmulatedAnnotatedType.wrapArray(((WildcardType)this.wrapped).getUpperBounds());
        }
    }

    private static class Variable
    extends EmulatedAnnotatedType<TypeVariable<?>>
    implements AnnotatedTypeVariable {
        Variable(TypeVariable<?> wrapped) {
            super(wrapped, null);
        }

        @Override
        public AnnotatedType[] getAnnotatedBounds() {
            return ((TypeVariable)this.wrapped).getAnnotatedBounds();
        }
    }

    private static class Parameterized
    extends EmulatedAnnotatedType<ParameterizedType>
    implements AnnotatedParameterizedType {
        Parameterized(ParameterizedType wrapped) {
            super(wrapped, null);
        }

        @Override
        public AnnotatedType[] getAnnotatedActualTypeArguments() {
            return EmulatedAnnotatedType.wrapArray(((ParameterizedType)this.wrapped).getActualTypeArguments());
        }
    }
}

