/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.apache.avro.reflect.Stringable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

@Stringable
@InterfaceAudience.Public
@InterfaceStability.Stable
public class Path
implements Comparable<Path>,
Serializable,
ObjectInputValidation {
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    public static final String CUR_DIR = ".";
    public static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final Pattern HAS_DRIVE_LETTER_SPECIFIER = Pattern.compile("^/?[a-zA-Z]:");
    private static final Pattern SLASHES = Pattern.compile("/+");
    private static final long serialVersionUID = 708623L;
    private URI uri;

    void checkNotSchemeWithRelative() {
        if (this.toUri().isAbsolute() && !this.isUriPathAbsolute()) {
            throw new HadoopIllegalArgumentException("Unsupported name: has scheme but relative path-part");
        }
    }

    void checkNotRelative() {
        if (!this.isAbsolute() && this.toUri().getScheme() == null) {
            throw new HadoopIllegalArgumentException("Path is relative");
        }
    }

    public static Path getPathWithoutSchemeAndAuthority(Path path) {
        Path newPath = path.isUriPathAbsolute() ? new Path(null, null, path.toUri().getPath()) : path;
        return newPath;
    }

    public Path(String parent, String child) {
        this(new Path(parent), new Path(child));
    }

    public Path(Path parent, String child) {
        this(parent, new Path(child));
    }

    public Path(String parent, Path child) {
        this(new Path(parent), child);
    }

    public Path(Path parent, Path child) {
        URI parentUri = parent.uri;
        String parentPath = parentUri.getPath();
        if (!parentPath.equals(SEPARATOR) && !parentPath.isEmpty()) {
            try {
                parentUri = new URI(parentUri.getScheme(), parentUri.getAuthority(), parentUri.getPath() + SEPARATOR, null, parentUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        URI resolved = parentUri.resolve(child.uri);
        this.initialize(resolved.getScheme(), resolved.getAuthority(), resolved.getPath(), resolved.getFragment());
    }

    private void checkPathArg(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("Can not create a Path from a null string");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Can not create a Path from an empty string");
        }
    }

    public Path(String pathString) throws IllegalArgumentException {
        this.checkPathArg(pathString);
        if (Path.hasWindowsDrive(pathString) && pathString.charAt(0) != '/') {
            pathString = SEPARATOR + pathString;
        }
        String scheme = null;
        String authority = null;
        int start = 0;
        int colon = pathString.indexOf(58);
        int slash = pathString.indexOf(47);
        if (colon != -1 && (slash == -1 || colon < slash)) {
            scheme = pathString.substring(0, colon);
            start = colon + 1;
        }
        if (pathString.startsWith("//", start) && pathString.length() - start > 2) {
            int nextSlash = pathString.indexOf(47, start + 2);
            int authEnd = nextSlash > 0 ? nextSlash : pathString.length();
            authority = pathString.substring(start + 2, authEnd);
            start = authEnd;
        }
        String path = pathString.substring(start, pathString.length());
        this.initialize(scheme, authority, path, null);
    }

    public Path(URI aUri) {
        this.uri = aUri.normalize();
    }

    public Path(String scheme, String authority, String path) {
        this.checkPathArg(path);
        if (Path.hasWindowsDrive(path) && path.charAt(0) != '/') {
            path = SEPARATOR + path;
        }
        if (!WINDOWS && path.charAt(0) != '/') {
            path = "./" + path;
        }
        this.initialize(scheme, authority, path, null);
    }

    private void initialize(String scheme, String authority, String path, String fragment) {
        try {
            this.uri = new URI(scheme, authority, Path.normalizePath(scheme, path), null, fragment).normalize();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Path mergePaths(Path path1, Path path2) {
        String path2Str = path2.toUri().getPath();
        path2Str = path2Str.substring(Path.startPositionWithoutWindowsDrive(path2Str));
        return new Path(path1.toUri().getScheme(), path1.toUri().getAuthority(), path1.toUri().getPath() + path2Str);
    }

    private static String normalizePath(String scheme, String path) {
        path = SLASHES.matcher(path).replaceAll(SEPARATOR);
        if (WINDOWS && (Path.hasWindowsDrive(path) || scheme == null || scheme.isEmpty() || scheme.equals("file"))) {
            path = StringUtils.replace((String)path, (String)"\\", (String)SEPARATOR);
        }
        int minLength = Path.startPositionWithoutWindowsDrive(path) + 1;
        if (path.length() > minLength && path.endsWith(SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static boolean hasWindowsDrive(String path) {
        return WINDOWS && HAS_DRIVE_LETTER_SPECIFIER.matcher(path).find();
    }

    private static int startPositionWithoutWindowsDrive(String path) {
        if (Path.hasWindowsDrive(path)) {
            return path.charAt(0) == '/' ? 3 : 2;
        }
        return 0;
    }

    public static boolean isWindowsAbsolutePath(String pathString, boolean slashed) {
        int start = Path.startPositionWithoutWindowsDrive(pathString);
        return start > 0 && pathString.length() > start && (pathString.charAt(start) == '/' || pathString.charAt(start) == '\\');
    }

    public URI toUri() {
        return this.uri;
    }

    public FileSystem getFileSystem(Configuration conf) throws IOException {
        return FileSystem.get(this.toUri(), conf);
    }

    public boolean isAbsoluteAndSchemeAuthorityNull() {
        return this.isUriPathAbsolute() && this.uri.getScheme() == null && this.uri.getAuthority() == null;
    }

    public boolean isUriPathAbsolute() {
        int start = Path.startPositionWithoutWindowsDrive(this.uri.getPath());
        return this.uri.getPath().startsWith(SEPARATOR, start);
    }

    public boolean isAbsolute() {
        return this.isUriPathAbsolute();
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public String getName() {
        String path = this.uri.getPath();
        int slash = path.lastIndexOf(SEPARATOR);
        return path.substring(slash + 1);
    }

    public Path getParent() {
        String path = this.uri.getPath();
        int lastSlash = path.lastIndexOf(47);
        int start = Path.startPositionWithoutWindowsDrive(path);
        if (path.length() == start || lastSlash == start && path.length() == start + 1) {
            return null;
        }
        String parent = lastSlash == -1 ? CUR_DIR : path.substring(0, lastSlash == start ? start + 1 : lastSlash);
        return new Path(this.uri.getScheme(), this.uri.getAuthority(), parent);
    }

    public Path suffix(String suffix) {
        Path parent = this.getParent();
        if (parent == null) {
            return new Path(SEPARATOR, this.getName() + suffix);
        }
        return new Path(parent, this.getName() + suffix);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.uri.getScheme() != null) {
            buffer.append(this.uri.getScheme()).append(":");
        }
        if (this.uri.getAuthority() != null) {
            buffer.append("//").append(this.uri.getAuthority());
        }
        if (this.uri.getPath() != null) {
            String path = this.uri.getPath();
            if (path.indexOf(47) == 0 && Path.hasWindowsDrive(path) && this.uri.getScheme() == null && this.uri.getAuthority() == null) {
                path = path.substring(1);
            }
            buffer.append(path);
        }
        if (this.uri.getFragment() != null) {
            buffer.append("#").append(this.uri.getFragment());
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Path)) {
            return false;
        }
        Path that = (Path)o;
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    @Override
    public int compareTo(Path o) {
        return this.uri.compareTo(o.uri);
    }

    public int depth() {
        int slash;
        String path = this.uri.getPath();
        int depth = 0;
        int n = slash = path.length() == 1 && path.charAt(0) == '/' ? -1 : 0;
        while (slash != -1) {
            ++depth;
            slash = path.indexOf(SEPARATOR, slash + 1);
        }
        return depth;
    }

    @Deprecated
    public Path makeQualified(FileSystem fs) {
        return this.makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    public Path makeQualified(URI defaultUri, Path workingDir) {
        Path path = this;
        if (!this.isAbsolute()) {
            path = new Path(workingDir, this);
        }
        URI pathUri = path.toUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        String fragment = pathUri.getFragment();
        if (scheme != null && (authority != null || defaultUri.getAuthority() == null)) {
            return path;
        }
        if (scheme == null) {
            scheme = defaultUri.getScheme();
        }
        if (authority == null && (authority = defaultUri.getAuthority()) == null) {
            authority = "";
        }
        URI newUri = null;
        try {
            newUri = new URI(scheme, authority, Path.normalizePath(scheme, pathUri.getPath()), null, fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return new Path(newUri);
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        if (this.uri == null) {
            throw new InvalidObjectException("No URI in deserialized Path");
        }
    }
}

