/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import org.apache.commons.collections.CollectionUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAccessedNotFromClusterTypeCondition
extends RangerAbstractConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAccessedNotFromClusterTypeCondition.class);
    private boolean isAlwaysTrue = false;

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAccessedNotFromClusterTypeCondition.init(" + this.condition + ")");
        }
        super.init();
        this.isAlwaysTrue = CollectionUtils.isEmpty(this.condition.getValues());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAccessedNotFromClusterTypeCondition.init(" + this.condition + ")");
        }
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAccessedNotFromClusterTypeCondition.isMatched(" + this.condition + ")");
        }
        if (this.isAlwaysTrue || request.getClusterType() == null) {
            ret = true;
        } else {
            boolean bl = ret = !this.condition.getValues().contains(request.getClusterType());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAccessedNotFromClusterTypeCondition.isMatched(" + this.condition + "): " + ret);
        }
        return ret;
    }
}

