/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.filestore;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TraditionalBinaryPrefix;

public interface FileStoreCommon {
    public static final String STATEMACHINE_PREFIX = "example.filestore.statemachine";
    public static final String STATEMACHINE_DIR_KEY = "example.filestore.statemachine.dir";
    public static final String STATEMACHINE_WRITE_THREAD_NUM = "example.filestore.statemachine.write.thread.num";
    public static final String STATEMACHINE_READ_THREAD_NUM = "example.filestore.statemachine.read.thread.num";
    public static final String STATEMACHINE_COMMIT_THREAD_NUM = "example.filestore.statemachine.commit.thread.num";
    public static final String STATEMACHINE_DELETE_THREAD_NUM = "example.filestore.statemachine.delete.thread.num";
    public static final SizeInBytes MAX_CHUNK_SIZE = SizeInBytes.valueOf(64L, TraditionalBinaryPrefix.MEGA);

    public static int getChunkSize(long suggestedSize) {
        return Math.toIntExact(Math.min(suggestedSize, MAX_CHUNK_SIZE.getSize()));
    }

    public static ByteString toByteString(Path p) {
        return ProtoUtils.toByteString(p.toString());
    }

    public static <T> CompletableFuture<T> completeExceptionally(long index, String message) {
        return FileStoreCommon.completeExceptionally(index, message, null);
    }

    public static <T> CompletableFuture<T> completeExceptionally(long index, String message, Throwable cause) {
        return FileStoreCommon.completeExceptionally(message + ", index=" + index, cause);
    }

    public static <T> CompletableFuture<T> completeExceptionally(String message, Throwable cause) {
        return JavaUtils.completeExceptionally(new IOException(message, cause));
    }
}

