/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.config.ConfigRocksDBStorage;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.rocksdb.CompressionType;
import org.rocksdb.FlushOptions;
import org.rocksdb.RocksIterator;
import org.rocksdb.Statistics;
import org.rocksdb.WriteBatch;

public class RocksDBConfigManager {
    protected static final Logger BROKER_LOG = LoggerFactory.getLogger((String)"RocketmqBroker");
    public volatile boolean isStop = false;
    public ConfigRocksDBStorage configRocksDBStorage = null;
    private FlushOptions flushOptions = null;
    private volatile long lastFlushMemTableMicroSecond = 0L;
    private final String filePath;
    private final long memTableFlushInterval;
    private final CompressionType compressionType;
    private DataVersion kvDataVersion = new DataVersion();

    public RocksDBConfigManager(String filePath, long memTableFlushInterval, CompressionType compressionType) {
        this.filePath = filePath;
        this.memTableFlushInterval = memTableFlushInterval;
        this.compressionType = compressionType;
    }

    public boolean init() {
        this.isStop = false;
        this.configRocksDBStorage = new ConfigRocksDBStorage(this.filePath, this.compressionType);
        return this.configRocksDBStorage.start();
    }

    public boolean loadDataVersion() {
        String currDataVersionString = null;
        try {
            byte[] dataVersion = this.configRocksDBStorage.getKvDataVersion();
            if (dataVersion != null && dataVersion.length > 0) {
                currDataVersionString = new String(dataVersion, StandardCharsets.UTF_8);
            }
            this.kvDataVersion = StringUtils.isNotBlank(currDataVersionString) ? (DataVersion)JSON.parseObject(currDataVersionString, DataVersion.class) : new DataVersion();
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean loadData(BiConsumer<byte[], byte[]> biConsumer) {
        try (RocksIterator iterator = this.configRocksDBStorage.iterator();){
            iterator.seekToFirst();
            while (iterator.isValid()) {
                biConsumer.accept(iterator.key(), iterator.value());
                iterator.next();
            }
        }
        this.flushOptions = new FlushOptions();
        this.flushOptions.setWaitForFlush(false);
        this.flushOptions.setAllowWriteStall(false);
        return true;
    }

    public void start() {
    }

    public boolean stop() {
        this.isStop = true;
        if (this.configRocksDBStorage != null) {
            return this.configRocksDBStorage.shutdown();
        }
        if (this.flushOptions != null) {
            this.flushOptions.close();
        }
        return true;
    }

    public void flushWAL() {
        try {
            if (this.isStop) {
                return;
            }
            if (this.configRocksDBStorage != null) {
                this.configRocksDBStorage.flushWAL();
                long now = System.currentTimeMillis();
                if (now > this.lastFlushMemTableMicroSecond + this.memTableFlushInterval) {
                    this.configRocksDBStorage.flush(this.flushOptions);
                    this.lastFlushMemTableMicroSecond = now;
                }
            }
        }
        catch (Exception e) {
            BROKER_LOG.error("kv flush WAL Failed.", (Throwable)e);
        }
    }

    public void put(byte[] keyBytes, int keyLen, byte[] valueBytes) throws Exception {
        this.configRocksDBStorage.put(keyBytes, keyLen, valueBytes);
    }

    public void delete(byte[] keyBytes) throws Exception {
        this.configRocksDBStorage.delete(keyBytes);
    }

    public void updateKvDataVersion() throws Exception {
        this.kvDataVersion.nextVersion();
        this.configRocksDBStorage.updateKvDataVersion(JSON.toJSONString((Object)this.kvDataVersion).getBytes(StandardCharsets.UTF_8));
    }

    public DataVersion getKvDataVersion() {
        return this.kvDataVersion;
    }

    public void updateForbidden(String key, String value) throws Exception {
        this.configRocksDBStorage.updateForbidden(key.getBytes(StandardCharsets.UTF_8), value.getBytes(StandardCharsets.UTF_8));
    }

    public void batchPutWithWal(WriteBatch batch) throws Exception {
        this.configRocksDBStorage.batchPutWithWal(batch);
    }

    public Statistics getStatistics() {
        if (this.configRocksDBStorage == null) {
            return null;
        }
        return this.configRocksDBStorage.getStatistics();
    }
}

