/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.route;

import apache.rocketmq.v2.Endpoints;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.rocketmq.client.java.route.Address;
import org.apache.rocketmq.client.java.route.AddressScheme;
import org.apache.rocketmq.shaded.com.google.common.base.Objects;
import org.apache.rocketmq.shaded.com.google.common.base.Preconditions;
import org.apache.rocketmq.shaded.com.google.common.net.InternetDomainName;

public class Endpoints {
    public static final int DEFAULT_PORT = 80;
    public static final String HTTP_PREFIX = "http://";
    public static final String HTTPS_PREFIX = "https://";
    private static final Pattern IPV4_HOST_PATTERN = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])*$");
    private static final String ENDPOINT_SEPARATOR = ";";
    private static final String ADDRESS_SEPARATOR = ",";
    private static final String COLON = ":";
    private final AddressScheme scheme;
    private final String facade;
    private final List<Address> addresses;
    private int hash;

    public Endpoints(apache.rocketmq.v2.Endpoints endpoints) {
        this.addresses = new ArrayList<Address>();
        for (apache.rocketmq.v2.Address address : endpoints.getAddressesList()) {
            this.addresses.add(new Address(address));
        }
        if (this.addresses.isEmpty()) {
            throw new UnsupportedOperationException("No available address");
        }
        apache.rocketmq.v2.AddressScheme scheme = endpoints.getScheme();
        switch (scheme) {
            case IPv4: {
                this.scheme = AddressScheme.IPv4;
                break;
            }
            case IPv6: {
                this.scheme = AddressScheme.IPv6;
                break;
            }
            default: {
                this.scheme = AddressScheme.DOMAIN_NAME;
                if (this.addresses.size() <= 1) break;
                throw new UnsupportedOperationException("Multiple addresses not allowed in domain schema");
            }
        }
        StringBuilder facadeBuilder = new StringBuilder();
        facadeBuilder.append(this.scheme.getPrefix());
        for (Address address : this.addresses) {
            facadeBuilder.append(address.getAddress()).append(ADDRESS_SEPARATOR);
        }
        this.facade = facadeBuilder.substring(0, facadeBuilder.length() - 1);
    }

    public Endpoints(String endpoints) {
        String host;
        int index;
        String[] addressesStr = endpoints.split(ENDPOINT_SEPARATOR);
        this.addresses = new ArrayList<Address>();
        if (addressesStr.length > 1) {
            String firstAddress = addressesStr[0];
            String firstHost = firstAddress.substring(0, firstAddress.lastIndexOf(COLON));
            this.scheme = IPV4_HOST_PATTERN.matcher(firstHost).matches() ? AddressScheme.IPv4 : AddressScheme.IPv6;
            for (String addressStr : addressesStr) {
                int portIndex = addressStr.lastIndexOf(COLON);
                String host2 = addressStr.substring(0, portIndex);
                int port = Integer.parseInt(addressStr.substring(1 + portIndex));
                Address addr = new Address(host2, port);
                this.addresses.add(addr);
            }
            this.facade = this.scheme.getPrefix() + endpoints.replace(ENDPOINT_SEPARATOR, ADDRESS_SEPARATOR);
            return;
        }
        if (endpoints.startsWith(HTTP_PREFIX)) {
            endpoints = endpoints.substring(HTTP_PREFIX.length());
        }
        if (endpoints.startsWith(HTTPS_PREFIX)) {
            endpoints = endpoints.substring(HTTPS_PREFIX.length());
        }
        int port = (index = endpoints.lastIndexOf(COLON)) > 0 ? Integer.parseInt(endpoints.substring(1 + index)) : 80;
        String string = host = index > 0 ? endpoints.substring(0, index) : endpoints;
        this.scheme = IPV4_HOST_PATTERN.matcher(host).matches() ? AddressScheme.IPv4 : (InternetDomainName.isValid(host) ? AddressScheme.DOMAIN_NAME : AddressScheme.IPv6);
        this.facade = this.scheme.getPrefix() + host + COLON + port;
        Address address = new Address(host, port);
        this.addresses.add(address);
    }

    public Endpoints(AddressScheme scheme, List<Address> addresses) {
        if (AddressScheme.DOMAIN_NAME.equals((Object)scheme) && addresses.size() > 1) {
            throw new UnsupportedOperationException("Multiple addresses not allowed in domain schema.");
        }
        Preconditions.checkNotNull(addresses, "addresses");
        if (addresses.isEmpty()) {
            throw new UnsupportedOperationException("No available address");
        }
        this.scheme = scheme;
        this.addresses = addresses;
        StringBuilder facadeBuilder = new StringBuilder();
        facadeBuilder.append(scheme.getPrefix());
        for (Address address : addresses) {
            facadeBuilder.append(address.getAddress()).append(ADDRESS_SEPARATOR);
        }
        this.facade = facadeBuilder.substring(0, facadeBuilder.length() - 1);
    }

    public AddressScheme getScheme() {
        return this.scheme;
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public List<InetSocketAddress> toSocketAddresses() {
        switch (this.scheme) {
            case DOMAIN_NAME: {
                return null;
            }
        }
        ArrayList<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>();
        for (Address address : this.addresses) {
            socketAddresses.add(new InetSocketAddress(address.getHost(), address.getPort()));
        }
        return socketAddresses;
    }

    public apache.rocketmq.v2.Endpoints toProtobuf() {
        Endpoints.Builder builder = apache.rocketmq.v2.Endpoints.newBuilder();
        for (Address address : this.addresses) {
            builder.addAddresses(address.toProtobuf());
        }
        return builder.setScheme(this.scheme.toProtobuf()).build();
    }

    public String toString() {
        return this.facade;
    }

    public String getFacade() {
        return this.facade;
    }

    public String getGrpcTarget() {
        if (AddressScheme.DOMAIN_NAME.equals((Object)this.scheme)) {
            return this.facade.substring(this.scheme.getPrefix().length());
        }
        return this.facade;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoints endpoints = (Endpoints)o;
        return this.scheme == endpoints.scheme && Objects.equal(this.facade, endpoints.facade) && Objects.equal(this.addresses, endpoints.addresses);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hashCode(new Object[]{this.scheme, this.facade, this.addresses});
        }
        return this.hash;
    }
}

