/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { defineComponent } from 'vue'
import {
  NConfigProvider,
  NMessageProvider,
  NDialogProvider,
  dateZhCN,
  dateEnUS,
  zhCN,
  enUS
} from 'naive-ui'
import { useSettingStore } from '@/store/setting'
import { useI18n } from 'vue-i18n'

const App = defineComponent({
  setup() {
    const settingStore = useSettingStore()

    if (settingStore.getLocales) {
      const { locale } = useI18n()
      locale.value = settingStore.getLocales
    }

    const themeOverrides = {
      common: {
        primaryColor: settingStore.primaryColor
      }
    }
    return {
      settingStore,
      themeOverrides
    }
  },
  render() {
    return (
      <NConfigProvider
        date-locale={this.settingStore.getLocales === 'zh_CN' ? dateZhCN : dateEnUS}
        locale={this.settingStore.getLocales === 'zh_CN' ? zhCN : enUS}
        themeOverrides={this.themeOverrides}
      >
        <NMessageProvider>
          <NDialogProvider>
            <router-view />
          </NDialogProvider>
        </NMessageProvider>
      </NConfigProvider>
    )
  }
})

export default App
