/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.http.client.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.servicecomb.http.client.common.MessageObjectMapper;

public final class HttpUtils {
    private static final String ALGORITHM_HMACSHA256 = "HmacSHA256";
    private static final ObjectMapper MAPPER = new MessageObjectMapper();

    public static <T> T deserialize(String content, Class<T> clazz) throws IOException {
        return (T)MAPPER.readValue(content, clazz);
    }

    public static <T> T deserialize(String content, TypeReference<T> clazz) throws IOException {
        return (T)MAPPER.readValue(content, clazz);
    }

    public static String serialize(Object value) throws IOException {
        return MAPPER.writeValueAsString(value);
    }

    public static JsonNode readTree(String content) throws IOException {
        return MAPPER.readTree(content);
    }

    public static String encodeURLParam(String value) throws IOException {
        if (value == null) {
            return "";
        }
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public static String decodeURLParam(String value) throws IOException {
        if (value == null) {
            return null;
        }
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }

    public static String sha256Encode(String key, String data) throws Exception {
        Mac mac = Mac.getInstance(ALGORITHM_HMACSHA256);
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), ALGORITHM_HMACSHA256);
        mac.init(secretKey);
        return Hex.encodeHexString((byte[])mac.doFinal(data.getBytes(StandardCharsets.UTF_8)));
    }
}

